/*
 * Decompiled with CFR 0.152.
 */
package morethanhidden.restrictedportals;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import morethanhidden.restrictedportals.RestrictedPortals;
import org.apache.commons.io.FileUtils;

public class AdvancementHelper {
    public static void AddCustomAdvancement(String title, String description, String item, String shortname, String path) {
        JsonObject jitem = new JsonObject();
        jitem.add("item", (JsonElement)new JsonPrimitive(item));
        JsonObject display = new JsonObject();
        display.add("icon", (JsonElement)jitem);
        display.add("title", (JsonElement)new JsonPrimitive(title));
        display.add("description", (JsonElement)new JsonPrimitive(description));
        JsonArray itemarray = new JsonArray();
        itemarray.add((JsonElement)jitem);
        JsonObject items = new JsonObject();
        items.add("items", (JsonElement)itemarray);
        JsonObject crit1 = new JsonObject();
        crit1.add("trigger", (JsonElement)new JsonPrimitive("minecraft:inventory_changed"));
        crit1.add("conditions", (JsonElement)items);
        JsonObject criteria = new JsonObject();
        criteria.add(shortname, (JsonElement)crit1);
        JsonObject jo = new JsonObject();
        jo.add("display", (JsonElement)display);
        jo.add("parent", (JsonElement)new JsonPrimitive("restrictedportals:root"));
        jo.add("criteria", (JsonElement)criteria);
        File file = new File(path + "/restrictedportals/data/restrictedportals/advancements/" + shortname + ".json");
        try {
            if (file.createNewFile()) {
                RestrictedPortals.LOGGER.info("Created Json File: " + file.getPath());
            } else {
                RestrictedPortals.LOGGER.info("File already Exists: " + file.getPath());
            }
        }
        catch (IOException e) {
            RestrictedPortals.LOGGER.info("Creating file failed: " + file.getPath());
        }
        try {
            FileWriter fileWriter = new FileWriter(file.getPath());
            fileWriter.write(jo.toString());
            fileWriter.close();
        }
        catch (IOException e) {
            RestrictedPortals.LOGGER.info("Editing File Failed: " + file.getPath());
        }
    }

    public static void ClearCustomAdvancements(String path) {
        try {
            FileUtils.cleanDirectory((File)new File(path + "/restrictedportals/data/restrictedportals/advancements"));
        }
        catch (Exception e) {
            RestrictedPortals.LOGGER.info("Failed to clean Advancements Folder");
        }
    }

    public static void CreateDatapack(String path) {
        File folder = new File(path + "/restrictedportals");
        if (folder.mkdir()) {
            RestrictedPortals.LOGGER.info("Created DataPack Folder: " + folder.getPath());
        } else {
            RestrictedPortals.LOGGER.info("DataPack Already Exists or Failed: " + folder.getPath());
        }
        JsonObject pack = new JsonObject();
        pack.add("description", (JsonElement)new JsonPrimitive("restrictedportals resources"));
        pack.add("pack_format", (JsonElement)new JsonPrimitive((Number)4));
        JsonObject mcmeta = new JsonObject();
        mcmeta.add("pack", (JsonElement)pack);
        File file = new File(path + "/restrictedportals/pack.mcmeta");
        try {
            if (file.createNewFile()) {
                RestrictedPortals.LOGGER.info("Created Data Pack mcmeta: " + file.getPath());
            } else {
                RestrictedPortals.LOGGER.info("File already Exists: " + file.getPath());
            }
        }
        catch (IOException e) {
            RestrictedPortals.LOGGER.info("Creating file failed: " + file.getPath());
        }
        try {
            FileWriter fileWriter = new FileWriter(file.getPath());
            fileWriter.write(mcmeta.toString());
            fileWriter.close();
        }
        catch (IOException e) {
            RestrictedPortals.LOGGER.info("Editing File Failed: " + file.getPath());
        }
        folder = new File(path + "/restrictedportals/data");
        if (folder.mkdir()) {
            RestrictedPortals.LOGGER.info("Created DataPack Folder: " + folder.getPath());
        } else {
            RestrictedPortals.LOGGER.info("DataPack Already Exists or Failed: " + folder.getPath());
        }
        folder = new File(path + "/restrictedportals/data/restrictedportals");
        if (folder.mkdir()) {
            RestrictedPortals.LOGGER.info("Created DataPack Folder: " + folder.getPath());
        } else {
            RestrictedPortals.LOGGER.info("DataPack Already Exists or Failed: " + folder.getPath());
        }
        folder = new File(path + "/restrictedportals/data/restrictedportals/advancements");
        if (folder.mkdir()) {
            RestrictedPortals.LOGGER.info("Created DataPack Folder: " + folder.getPath());
        } else {
            RestrictedPortals.LOGGER.info("DataPack Already Exists or Failed: " + folder.getPath());
        }
    }
}

