/*
 * Decompiled with CFR 0.152.
 */
package morethanhidden.restrictedportals.handlers;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHandler {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class General {
        public final ForgeConfigSpec.BooleanValue preventEPDeath;
        public final ForgeConfigSpec.ConfigValue<String> blockedmessage;
        public final ForgeConfigSpec.ConfigValue<String> craftedmessage;
        public final ForgeConfigSpec.ConfigValue<String> craftItems;
        public final ForgeConfigSpec.ConfigValue<String> dimIDs;
        public final ForgeConfigSpec.ConfigValue<String> dimNames;

        General(ForgeConfigSpec.Builder builder) {
            builder.push("options");
            this.preventEPDeath = builder.comment("Prevents Death by Teleporting Player to Spawn if trying to enter an Ender Portal").translation("restrictedportals.configgui.preventdeath").define("preventdeath", true);
            this.blockedmessage = builder.comment("Message that displays when Teleport is blocked").translation("restrictedportals.configgui.blockedmessage").define("blockedmessage", (Object)"Please obtain a %item% to enter the %dim%");
            this.craftedmessage = builder.comment("Title for the Advancements").translation("restrictedportals.configgui.craftedmessage").define("craftedmessage", (Object)"%dim% Unlocked!");
            this.craftItems = builder.comment("Comma seperated list of items that when crafted unlock the corresponding dimension").translation("restrictedportals.configgui.craftitems").define("craftitems", (Object)"minecraft:flint_and_steel,minecraft:ender_eye");
            this.dimIDs = builder.comment("Comma seperated list of Dimension IDs to be blocked by items").translation("restrictedportals.configgui.dimids").define("dimids", (Object)"-1,1");
            this.dimNames = builder.comment("Comma seperated list of Dimension Names to match IDs").translation("restrictedportals.configgui.dimnames").define("dimnames", (Object)"Nether,End");
            builder.pop();
        }
    }
}

