/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.incontrol.InControl;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.RuleBase;
import mcjty.tools.typed.Attribute;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.GenericAttributeMapFactory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class PotentialSpawnRule
extends RuleBase<RuleBase.EventGetter> {
    public static final IEventQuery<WorldEvent.PotentialSpawns> EVENT_QUERY = new IEventQuery<WorldEvent.PotentialSpawns>(){

        @Override
        public World getWorld(WorldEvent.PotentialSpawns o) {
            return o.getWorld().func_201672_e();
        }

        @Override
        public BlockPos getPos(WorldEvent.PotentialSpawns o) {
            return o.getPos();
        }

        @Override
        public BlockPos getValidBlockPos(WorldEvent.PotentialSpawns o) {
            return o.getPos().func_177977_b();
        }

        @Override
        public int getY(WorldEvent.PotentialSpawns o) {
            return o.getPos().func_177956_o();
        }

        @Override
        public Entity getEntity(WorldEvent.PotentialSpawns o) {
            return null;
        }

        @Override
        public DamageSource getSource(WorldEvent.PotentialSpawns o) {
            return null;
        }

        @Override
        public Entity getAttacker(WorldEvent.PotentialSpawns o) {
            return null;
        }

        @Override
        public PlayerEntity getPlayer(WorldEvent.PotentialSpawns o) {
            return null;
        }

        @Override
        public ItemStack getItem(WorldEvent.PotentialSpawns o) {
            return ItemStack.field_190927_a;
        }
    };
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    private static final GenericAttributeMapFactory MOB_FACTORY = new GenericAttributeMapFactory();
    private final GenericRuleEvaluator ruleEvaluator;
    private List<Biome.SpawnListEntry> spawnEntries = new ArrayList<Biome.SpawnListEntry>();
    private Set<EntityType> toRemoveMobs = new HashSet<EntityType>();

    private PotentialSpawnRule(AttributeMap map) {
        super(InControl.setup.getLogger());
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        if (!map.has(RuleKeys.ACTION_MOBS) && !map.has(RuleKeys.ACTION_REMOVE_MOBS)) {
            InControl.setup.getLogger().log(Level.ERROR, "No 'mobs' or 'remove' specified!");
            return;
        }
        this.makeSpawnEntries(map);
        if (map.has(RuleKeys.ACTION_REMOVE_MOBS)) {
            this.addToRemoveAction(map);
        }
    }

    public static PotentialSpawnRule parse(JsonElement element) {
        if (element == null) {
            return null;
        }
        JsonObject jsonObject = element.getAsJsonObject();
        if (!jsonObject.has("mobs") && !jsonObject.has("remove")) {
            return null;
        }
        AttributeMap map = FACTORY.parse(element);
        if (jsonObject.has("mobs")) {
            JsonArray mobs = jsonObject.get("mobs").getAsJsonArray();
            for (JsonElement mob : mobs) {
                AttributeMap mobMap = MOB_FACTORY.parse(mob);
                map.addList(RuleKeys.ACTION_MOBS, mobMap);
            }
        }
        return new PotentialSpawnRule(map);
    }

    private void addToRemoveAction(AttributeMap map) {
        List<String> toremove = map.getList(RuleKeys.ACTION_REMOVE_MOBS);
        for (String s : toremove) {
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(s));
            if (type == null) {
                InControl.setup.getLogger().log(Level.ERROR, "Cannot find mob '" + s + "'!");
                return;
            }
            this.toRemoveMobs.add(type);
        }
    }

    private void makeSpawnEntries(AttributeMap map) {
        for (AttributeMap mobMap : map.getList(RuleKeys.ACTION_MOBS)) {
            Integer groupCountMax;
            Integer groupCountMin;
            String id = mobMap.get(RuleKeys.MOB_NAME);
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
            if (type == null) {
                InControl.setup.getLogger().log(Level.ERROR, "Cannot find mob '" + mobMap.get(RuleKeys.MOB_NAME) + "'!");
                return;
            }
            Integer weight = mobMap.get(RuleKeys.MOB_WEIGHT);
            if (weight == null) {
                weight = 1;
            }
            if ((groupCountMin = mobMap.get(RuleKeys.MOB_GROUPCOUNTMIN)) == null) {
                groupCountMin = 1;
            }
            if ((groupCountMax = mobMap.get(RuleKeys.MOB_GROUPCOUNTMAX)) == null) {
                groupCountMax = Math.max(groupCountMin, 1);
            }
            Biome.SpawnListEntry entry = new Biome.SpawnListEntry(type, weight.intValue(), groupCountMin.intValue(), groupCountMax.intValue());
            this.spawnEntries.add(entry);
        }
    }

    public List<Biome.SpawnListEntry> getSpawnEntries() {
        return this.spawnEntries;
    }

    public boolean match(WorldEvent.PotentialSpawns event) {
        return this.ruleEvaluator.match((Event)event, EVENT_QUERY);
    }

    public Set<EntityType> getToRemoveMobs() {
        return this.toRemoveMobs;
    }

    static {
        FACTORY.attribute(Attribute.create(RuleKeys.MINCOUNT)).attribute(Attribute.create(RuleKeys.MAXCOUNT)).attribute(Attribute.create(RuleKeys.MINTIME)).attribute(Attribute.create(RuleKeys.MAXTIME)).attribute(Attribute.create(RuleKeys.MINLIGHT)).attribute(Attribute.create(RuleKeys.MAXLIGHT)).attribute(Attribute.create(RuleKeys.MINHEIGHT)).attribute(Attribute.create(RuleKeys.MAXHEIGHT)).attribute(Attribute.create(RuleKeys.MINDIFFICULTY)).attribute(Attribute.create(RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create(RuleKeys.MINSPAWNDIST)).attribute(Attribute.create(RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create(RuleKeys.RANDOM)).attribute(Attribute.create(RuleKeys.SEESKY)).attribute(Attribute.create(RuleKeys.WEATHER)).attribute(Attribute.create(RuleKeys.TEMPCATEGORY)).attribute(Attribute.create(RuleKeys.DIFFICULTY)).attribute(Attribute.create(RuleKeys.STRUCTURE)).attribute(Attribute.create(RuleKeys.WINTER)).attribute(Attribute.create(RuleKeys.SUMMER)).attribute(Attribute.create(RuleKeys.SPRING)).attribute(Attribute.create(RuleKeys.AUTUMN)).attribute(Attribute.create(RuleKeys.STATE)).attribute(Attribute.createMulti(RuleKeys.BLOCK)).attribute(Attribute.create(RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti(RuleKeys.BIOME)).attribute(Attribute.createMulti(RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti(RuleKeys.DIMENSION)).attribute(Attribute.createMulti(RuleKeys.ACTION_REMOVE_MOBS));
        MOB_FACTORY.attribute(Attribute.create(RuleKeys.MOB_NAME)).attribute(Attribute.create(RuleKeys.MOB_WEIGHT)).attribute(Attribute.create(RuleKeys.MOB_GROUPCOUNTMIN)).attribute(Attribute.create(RuleKeys.MOB_GROUPCOUNTMAX));
    }
}

