/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IColorManager;
import com.mamiyaotaru.voxelmap.interfaces.IMap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.persistent.GuiPersistentMap;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.BlockRepository;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.FullMapData;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.LayoutVariables;
import com.mamiyaotaru.voxelmap.util.LiveGLBufferedImage;
import com.mamiyaotaru.voxelmap.util.LiveScaledGLBufferedImage;
import com.mamiyaotaru.voxelmap.util.MapChunkCache;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import com.mamiyaotaru.voxelmap.util.NetworkUtils;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mamiyaotaru.voxelmap.util.TickCounter;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.MemoryErrorScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.AbstractOption;
import net.minecraft.client.settings.AmbientOcclusionStatus;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import org.lwjgl.BufferUtils;

public class Map
implements Runnable,
IMap {
    private IVoxelMap master;
    private Minecraft game;
    private String zmodver = "v1.9.28";
    private ClientWorld world = null;
    private final int WORLD_HEIGHT = 256;
    private MapSettingsManager options = null;
    private LayoutVariables layoutVariables = null;
    private IColorManager colorManager = null;
    private IWaypointManager waypointManager = null;
    private int availableProcessors = Runtime.getRuntime().availableProcessors();
    private boolean multicore = this.availableProcessors > 1;
    private FullMapData[] mapData = new FullMapData[5];
    private MapChunkCache[] chunkCache = new MapChunkCache[5];
    private LiveGLBufferedImage[] mapImages;
    private LiveGLBufferedImage[] mapImagesFiltered = new LiveGLBufferedImage[5];
    private LiveGLBufferedImage[] mapImagesUnfiltered = new LiveScaledGLBufferedImage[5];
    private ConcurrentLinkedQueue<int[]> chunkUpdateQueue = new ConcurrentLinkedQueue();
    private MutableBlockPos blockPos = new MutableBlockPos(0, 0, 0);
    private MutableBlockPos tempBlockPos = new MutableBlockPos(0, 0, 0);
    private BlockState transparentBlockState;
    private BlockState surfaceBlockState;
    private BlockState seafloorBlockState;
    private BlockState foliageBlockState;
    private boolean imageChanged = true;
    private DynamicTexture lightmapTexture = null;
    private boolean needLightmapRefresh = true;
    private int tickCounter = 0;
    private int tickWithLightChange = 0;
    private boolean lastPaused = true;
    private final float[] lastLightBrightnessTable = new float[16];
    private double lastGamma = 0.0;
    private float lastSunBrightness = 0.0f;
    private float lastLightning = 0.0f;
    private float lastPotion = 0.0f;
    private int[] lastLightmapValues = new int[]{-16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216};
    private boolean lastBeneathRendering = false;
    private boolean needSkyColor = false;
    private boolean lastAboveHorizon = true;
    private int lastBiome = 0;
    private int lastSkyColor = 0;
    private Random generator = new Random();
    private boolean showWelcomeScreen = true;
    private Screen lastGuiScreen = null;
    private boolean enabled = true;
    private boolean fullscreenMap = false;
    private boolean active = false;
    private int zoom = 2;
    private int mapX = 37;
    private int mapY = 37;
    private int scWidth;
    private int scHeight;
    private String error = "";
    private String[] welcomeString = new String[8];
    private int ztimer = 0;
    private int heightMapFudge = 0;
    private int timer = 0;
    private boolean doFullRender = true;
    private boolean zoomChanged;
    private int lastX = 0;
    private int lastZ = 0;
    private int lastY = 0;
    private int lastImageX = 0;
    private int lastImageZ = 0;
    private boolean lastFullscreen = false;
    private float direction = 0.0f;
    private float percentX;
    private float percentY;
    private String subworldName = "";
    private int heightMapResetHeight = this.multicore ? 2 : 5;
    private int heightMapResetTime = this.multicore ? 300 : 3000;
    private int northRotate = 0;
    private Thread zCalc = new Thread((Runnable)this, "Voxelmap LiveMap Calculation Thread");
    private int zCalcTicker = 0;
    private boolean threading = this.multicore;
    private FontRenderer fontRenderer;
    private int[] lightmapColors = new int[256];
    private final Object coordinateLock = new Object();
    private final int SEAFLOORLAYER = 0;
    private final int GROUNDLAYER = 1;
    private final int FOLIAGELAYER = 2;
    private final int TRANSPARENTLAYER = 3;
    private double zoomScale = 1.0;
    private double zoomScaleAdjusted = 1.0;
    private final float SQRT2 = 1.4142f;
    private boolean optifineInstalled = false;
    LiveGLBufferedImage roundImage = new LiveGLBufferedImage(128, 128, 6);
    private int mapImageInt = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map(IVoxelMap master) {
        this.master = master;
        this.game = GameVariableAccessShim.getMinecraft();
        this.options = master.getMapOptions();
        this.colorManager = master.getColorManager();
        this.waypointManager = master.getWaypointManager();
        this.layoutVariables = new LayoutVariables();
        try {
            NetworkUtils.enumerateInterfaces();
        }
        catch (SocketException e) {
            System.err.println("could not get network interface addresses");
            e.printStackTrace();
        }
        ArrayList<KeyBinding> tempBindings = new ArrayList<KeyBinding>();
        tempBindings.addAll(Arrays.asList(this.game.field_71474_y.field_74324_K));
        tempBindings.addAll(Arrays.asList(this.options.keyBindings));
        this.game.field_71474_y.field_74324_K = tempBindings.toArray(new KeyBinding[tempBindings.size()]);
        java.util.Map categoryOrder = (java.util.Map)ReflectionUtils.getPrivateFieldValueByType(null, KeyBinding.class, java.util.Map.class, 1);
        System.out.println("CATEGORY ORDER IS " + categoryOrder.size());
        Integer categoryPlace = (Integer)categoryOrder.get("controls.minimap.title");
        if (categoryPlace == null) {
            int currentSize = categoryOrder.size();
            categoryOrder.put("controls.minimap.title", currentSize + 1);
        }
        this.showWelcomeScreen = this.options.welcome;
        this.zCalc.start();
        this.zCalc.setPriority(5);
        this.mapData[0] = new FullMapData(32, 32);
        this.mapData[1] = new FullMapData(64, 64);
        this.mapData[2] = new FullMapData(128, 128);
        this.mapData[3] = new FullMapData(256, 256);
        this.mapData[4] = new FullMapData(512, 512);
        this.chunkCache[0] = new MapChunkCache(3, 3, this);
        this.chunkCache[1] = new MapChunkCache(5, 5, this);
        this.chunkCache[2] = new MapChunkCache(9, 9, this);
        this.chunkCache[3] = new MapChunkCache(17, 17, this);
        this.chunkCache[4] = new MapChunkCache(33, 33, this);
        this.mapImagesFiltered[0] = new LiveGLBufferedImage(32, 32, 6);
        this.mapImagesFiltered[1] = new LiveGLBufferedImage(64, 64, 6);
        this.mapImagesFiltered[2] = new LiveGLBufferedImage(128, 128, 6);
        this.mapImagesFiltered[3] = new LiveGLBufferedImage(256, 256, 6);
        this.mapImagesFiltered[4] = new LiveGLBufferedImage(512, 512, 6);
        this.mapImagesUnfiltered[0] = new LiveScaledGLBufferedImage(32, 32, 6);
        this.mapImagesUnfiltered[1] = new LiveScaledGLBufferedImage(64, 64, 6);
        this.mapImagesUnfiltered[2] = new LiveScaledGLBufferedImage(128, 128, 6);
        this.mapImagesUnfiltered[3] = new LiveScaledGLBufferedImage(256, 256, 6);
        this.mapImagesUnfiltered[4] = new LiveScaledGLBufferedImage(512, 512, 6);
        this.mapImages = this.options.filtering ? this.mapImagesFiltered : this.mapImagesUnfiltered;
        GLUtils.setupFrameBuffer();
        this.fontRenderer = this.game.field_71466_p;
        this.zoom = this.options.zoom;
        this.setZoomScale();
        this.optifineInstalled = false;
        Field ofProfiler = null;
        try {
            ofProfiler = GameSettings.class.getDeclaredField("ofProfiler");
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        finally {
            if (ofProfiler != null) {
                this.optifineInstalled = true;
            }
        }
    }

    @Override
    public void forceFullRender(boolean forceFullRender) {
        this.doFullRender = forceFullRender;
        this.master.getSettingsAndLightingChangeNotifier().notifyOfChanges();
    }

    @Override
    public float getPercentX() {
        return this.percentX;
    }

    @Override
    public float getPercentY() {
        return this.percentY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.game == null) {
            return;
        }
        while (true) {
            Thread thread;
            if (this.threading) {
                this.active = true;
                while (this.game.field_71439_g != null && this.world != null && this.active) {
                    if (!this.options.hide) {
                        try {
                            this.mapCalc(this.doFullRender);
                            if (!this.doFullRender) {
                                this.chunkCache[this.zoom].centerChunks(this.blockPos.withXYZ(this.lastX, 0, this.lastZ));
                                this.chunkCache[this.zoom].checkIfChunksChanged();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.doFullRender = this.zoomChanged;
                    this.zoomChanged = false;
                    this.active = false;
                }
                this.zCalcTicker = 0;
                thread = this.zCalc;
                synchronized (thread) {
                    try {
                        this.zCalc.wait(0L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            thread = this.zCalc;
            synchronized (thread) {
                try {
                    this.zCalc.wait(0L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void newWorld(ClientWorld world) {
        this.world = world;
        this.lightmapTexture = this.getLightmapTexture();
        this.mapData[this.zoom].blank();
        this.mapImages[this.options.zoom].blank();
        this.chunkUpdateQueue.clear();
        this.doFullRender = true;
        this.master.getSettingsAndLightingChangeNotifier().notifyOfChanges();
    }

    @Override
    public void newWorldName() {
        this.subworldName = this.waypointManager.getCurrentSubworldDescriptor(true);
        StringBuilder subworldNameBuilder = new StringBuilder("\u00a7r").append(I18nUtils.getString("worldmap.multiworld.newworld", new Object[0])).append(":").append(" ");
        if (this.subworldName.equals("") && this.waypointManager.isMultiworld()) {
            subworldNameBuilder.append("???");
        } else if (!this.subworldName.equals("")) {
            subworldNameBuilder.append(this.subworldName);
        }
        this.error = subworldNameBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTickInGame(Minecraft mc) {
        int n = this.northRotate = this.options.oldNorth ? 90 : 0;
        if (this.game == null) {
            this.game = mc;
        }
        if (this.lightmapTexture == null) {
            this.lightmapTexture = this.getLightmapTexture();
        }
        if (this.game.field_71462_r == null && this.options.keyBindMenu.func_151468_f()) {
            this.showWelcomeScreen = false;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            this.game.func_147108_a((Screen)new GuiPersistentMap(null, this.master));
        }
        if (this.game.field_71462_r == null && this.options.keyBindWaypointMenu.func_151468_f()) {
            this.showWelcomeScreen = false;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            this.game.func_147108_a((Screen)new GuiWaypoints(null, this.master));
        }
        if (this.game.field_71462_r == null && this.options.keyBindWaypoint.func_151468_f()) {
            float b;
            float g;
            float r;
            this.showWelcomeScreen = false;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            if (this.waypointManager.getWaypoints().size() == 0) {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            } else {
                r = this.generator.nextFloat();
                g = this.generator.nextFloat();
                b = this.generator.nextFloat();
            }
            TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
            dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByDimension(this.game.field_71441_e.field_73011_w));
            Waypoint newWaypoint = new Waypoint("", this.game.field_71439_g.field_71093_bK != DimensionType.field_223228_b_ ? GameVariableAccessShim.xCoord() : GameVariableAccessShim.xCoord() * 8, this.game.field_71439_g.field_71093_bK != DimensionType.field_223228_b_ ? GameVariableAccessShim.zCoord() : GameVariableAccessShim.zCoord() * 8, GameVariableAccessShim.yCoord(), true, r, g, b, "", this.master.getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
            this.game.func_147108_a((Screen)new GuiAddWaypoint(null, this.master, newWaypoint, false));
        }
        if (this.game.field_71462_r == null && this.options.keyBindMobToggle.func_151468_f()) {
            this.master.getRadarOptions().setOptionValue(EnumOptionsMinimap.SHOWRADAR, 0);
            this.options.saveAll();
        }
        if (this.game.field_71462_r == null && this.options.keyBindWaypointToggle.func_151468_f()) {
            this.options.toggleIngameWaypoints();
        }
        if (this.game.field_71462_r == null && this.options.keyBindZoom.func_151468_f()) {
            this.showWelcomeScreen = false;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            } else {
                this.cycleZoomLevel();
            }
        }
        if (this.game.field_71462_r == null && this.options.keyBindFullscreen.func_151468_f()) {
            boolean bl = this.fullscreenMap = !this.fullscreenMap;
            this.error = this.zoom == 4 ? I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (0.25x)" : (this.zoom == 3 ? I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (0.5x)" : (this.zoom == 2 ? I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (1.0x)" : (this.zoom == 1 ? I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (2.0x)" : I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (4.0x)")));
        }
        this.checkForChanges();
        if (this.game.field_71462_r instanceof DeathScreen && !(this.lastGuiScreen instanceof DeathScreen)) {
            this.waypointManager.handleDeath();
        }
        this.lastGuiScreen = this.game.field_71462_r;
        this.calculateCurrentLightAndSkyColor();
        if (this.threading) {
            if (!this.zCalc.isAlive() && this.threading) {
                this.zCalc = new Thread((Runnable)this, "Voxelmap LiveMap Calculation Thread");
                this.zCalc.setPriority(5);
                this.zCalc.start();
            }
            if (!(this.game.field_71462_r instanceof DeathScreen) && !(this.game.field_71462_r instanceof MemoryErrorScreen)) {
                ++this.zCalcTicker;
                if (this.zCalcTicker > 200) {
                    this.zCalcTicker = 0;
                    this.zCalc.stop();
                } else {
                    Thread r = this.zCalc;
                    synchronized (r) {
                        this.zCalc.notify();
                    }
                }
            }
        } else if (!this.threading) {
            if (!this.options.hide && this.world != null) {
                this.mapCalc(this.doFullRender);
                if (!this.doFullRender) {
                    this.chunkCache[this.zoom].centerChunks(this.blockPos.withXYZ(this.lastX, 0, this.lastZ));
                    this.chunkCache[this.zoom].checkIfChunksChanged();
                }
            }
            this.doFullRender = false;
        }
        this.enabled = !mc.field_71474_y.field_74319_N && (this.options.showUnderMenus || this.game.field_71462_r == null || this.game.field_71462_r instanceof ChatScreen) && !this.game.field_71474_y.field_74330_P;
        this.direction = GameVariableAccessShim.rotationYaw() + 180.0f;
        while (this.direction >= 360.0f) {
            this.direction -= 360.0f;
        }
        while (this.direction < 0.0f) {
            this.direction += 360.0f;
        }
        if (!this.error.equals("") && this.ztimer == 0) {
            this.ztimer = 500;
        }
        if (this.ztimer > 0) {
            --this.ztimer;
        }
        if (this.ztimer == 0 && !this.error.equals("")) {
            this.error = "";
        }
        if (this.enabled) {
            this.drawMinimap(mc);
        }
        if (this.world != null) {
            while (!this.chunkUpdateQueue.isEmpty() && Math.abs(TickCounter.tickCounter - this.chunkUpdateQueue.peek()[2]) >= 4) {
                int[] popped = (int[])this.chunkUpdateQueue.remove();
                this.chunkCache[this.zoom].registerChangeAt(popped[0], popped[1]);
            }
        }
        this.timer = this.timer > 5000 ? 0 : this.timer + 1;
    }

    private void cycleZoomLevel() {
        if (this.options.zoom == 4) {
            this.options.zoom = 3;
            this.error = I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (0.5x)";
        } else if (this.options.zoom == 3) {
            this.options.zoom = 2;
            this.error = I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (1.0x)";
        } else if (this.options.zoom == 2) {
            this.options.zoom = 1;
            this.error = I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (2.0x)";
        } else if (this.options.zoom == 1) {
            this.options.zoom = 0;
            this.error = I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (4.0x)";
        } else if (this.options.zoom == 0) {
            if (this.multicore && AbstractOption.field_216706_m.func_216729_a(this.game.field_71474_y) > 8.0) {
                this.options.zoom = 4;
                this.error = I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (0.25x)";
            } else {
                this.options.zoom = 3;
                this.error = I18nUtils.getString("minimap.ui.zoomlevel", new Object[0]) + " (0.5x)";
            }
        }
        this.options.saveAll();
        this.mapImages[this.options.zoom].blank();
        this.zoomChanged = true;
        this.zoom = this.options.zoom;
        this.setZoomScale();
        this.doFullRender = true;
    }

    private void setZoomScale() {
        this.zoomScale = Math.pow(2.0, this.zoom) / 2.0;
        if (this.options.squareMap && this.options.rotates) {
            this.getClass();
            this.zoomScaleAdjusted = this.zoomScale / (double)1.4142f;
        } else {
            this.zoomScaleAdjusted = this.zoomScale;
        }
    }

    private DynamicTexture getLightmapTexture() {
        Object lightTextureObj = ReflectionUtils.getPrivateFieldValueByType(this.game.field_71460_t, GameRenderer.class, LightTexture.class);
        if (lightTextureObj == null) {
            return null;
        }
        LightTexture lightTexture = (LightTexture)lightTextureObj;
        Object lightmapTextureObj = ReflectionUtils.getPrivateFieldValueByType(lightTexture, LightTexture.class, DynamicTexture.class);
        if (lightmapTextureObj == null) {
            return null;
        }
        return (DynamicTexture)lightmapTextureObj;
    }

    public void calculateCurrentLightAndSkyColor() {
        int biomeID;
        boolean aboveHorizon;
        boolean scheduledUpdate;
        int lastLightningBolt;
        int t;
        if (this.world == null) {
            return;
        }
        if (this.needLightmapRefresh && TickCounter.tickCounter != this.tickWithLightChange && !this.game.func_147113_T() || this.options.realTimeTorches) {
            GLUtils.disp(this.lightmapTexture.func_110552_b());
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder());
            GLShim.glGetTexImage(3553, 0, 6408, 5121, byteBuffer);
            for (int i = 0; i < this.lightmapColors.length; ++i) {
                int index = i * 4;
                this.lightmapColors[i] = (byteBuffer.get(index + 3) << 24) + (byteBuffer.get(index) << 16) + (byteBuffer.get(index + 1) << 8) + (byteBuffer.get(index + 2) << 0);
            }
            if (this.lightmapColors[255] != 0) {
                this.needLightmapRefresh = false;
            }
        }
        boolean lightChanged = false;
        if (this.game.field_71474_y.field_74333_Y != this.lastGamma) {
            lightChanged = true;
            this.lastGamma = this.game.field_71474_y.field_74333_Y;
        }
        float[] providerLightBrightnessTable = new float[16];
        for (t = 0; t < 16; ++t) {
            providerLightBrightnessTable[t] = this.world.field_73011_w.func_227174_a_(t);
        }
        for (t = 0; t < 16; ++t) {
            if (providerLightBrightnessTable[t] == this.lastLightBrightnessTable[t]) continue;
            lightChanged = true;
            this.lastLightBrightnessTable[t] = providerLightBrightnessTable[t];
        }
        float sunBrightness = this.world.func_228326_g_(1.0f);
        if ((double)Math.abs(this.lastSunBrightness - sunBrightness) > 0.01 || (double)sunBrightness == 1.0 && sunBrightness != this.lastSunBrightness || (double)sunBrightness == 0.0 && sunBrightness != this.lastSunBrightness) {
            lightChanged = true;
            this.needSkyColor = true;
            this.lastSunBrightness = sunBrightness;
        }
        float potionEffect = 0.0f;
        if (this.game.field_71439_g.func_70644_a(Effects.field_76439_r)) {
            int duration = this.game.field_71439_g.func_70660_b(Effects.field_76439_r).func_76459_b();
            float f = potionEffect = duration > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)(((float)duration - 1.0f) * (float)Math.PI * 0.2f)) * 0.3f;
        }
        if (this.lastPotion != potionEffect) {
            this.lastPotion = potionEffect;
            lightChanged = true;
        }
        if (this.lastLightning != (float)(lastLightningBolt = this.world.func_228332_n_())) {
            this.lastLightning = lastLightningBolt;
            lightChanged = true;
        }
        if (this.lastPaused != this.game.func_147113_T()) {
            this.lastPaused = !this.lastPaused;
            lightChanged = true;
        }
        boolean bl = scheduledUpdate = (this.timer - 50) % (this.lastLightBrightnessTable[0] == 0.0f ? 250 : (this.game.field_71439_g.field_71093_bK != DimensionType.field_223228_b_ ? 500 : 5000)) == 0;
        if (lightChanged || scheduledUpdate) {
            this.tickWithLightChange = this.tickCounter;
            lightChanged = false;
            this.needLightmapRefresh = true;
        }
        boolean bl2 = aboveHorizon = this.game.field_71439_g.func_174824_e((float)0.0f).field_72448_b + (double)this.game.field_71439_g.func_70047_e() >= this.world.func_228331_m_();
        if (DimensionType.func_212678_a((DimensionType)this.world.field_73011_w.func_186058_p()).toString().toLowerCase().contains("ether")) {
            aboveHorizon = true;
        }
        if (aboveHorizon != this.lastAboveHorizon) {
            this.needSkyColor = true;
            this.lastAboveHorizon = aboveHorizon;
        }
        if ((biomeID = Registry.field_212624_m.func_148757_b((Object)this.world.func_226691_t_((BlockPos)this.blockPos.withXYZ(GameVariableAccessShim.xCoord(), GameVariableAccessShim.yCoord(), GameVariableAccessShim.zCoord())))) != this.lastBiome) {
            this.needSkyColor = true;
            this.lastBiome = biomeID;
        }
        if (this.needSkyColor || scheduledUpdate) {
            this.colorManager.setSkyColor(this.getSkyColor());
        }
    }

    private int getSkyColor() {
        this.needSkyColor = false;
        boolean aboveHorizon = this.lastAboveHorizon;
        float[] fogColors = new float[4];
        FloatBuffer temp = BufferUtils.createFloatBuffer((int)4);
        FogRenderer.func_228371_a_((ActiveRenderInfo)this.game.field_71460_t.func_215316_n(), (float)0.0f, (ClientWorld)this.world, (int)this.game.field_71474_y.field_151451_c, (float)this.game.field_71460_t.func_205002_d(0.0f));
        GLShim.glGetFloat(3106, temp);
        temp.get(fogColors);
        float r = fogColors[0];
        float g = fogColors[1];
        float b = fogColors[2];
        if (!aboveHorizon && this.game.field_71474_y.field_151451_c >= 4) {
            return 0xA000000 + (int)(r * 255.0f) * 65536 + (int)(g * 255.0f) * 256 + (int)(b * 255.0f);
        }
        int backgroundColor = -16777216 + (int)(r * 255.0f) * 65536 + (int)(g * 255.0f) * 256 + (int)(b * 255.0f);
        float[] sunsetColors = this.world.field_73011_w.func_76560_a(this.world.func_72826_c(0.0f), 0.0f);
        if (sunsetColors != null && this.game.field_71474_y.field_151451_c >= 4) {
            int sunsetColor = (int)(sunsetColors[3] * 128.0f) * 0x1000000 + (int)(sunsetColors[0] * 255.0f) * 65536 + (int)(sunsetColors[1] * 255.0f) * 256 + (int)(sunsetColors[2] * 255.0f);
            return this.colorManager.colorAdder(sunsetColor, backgroundColor);
        }
        return backgroundColor;
    }

    @Override
    public int[] getLightmapArray() {
        return this.lightmapColors;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void drawMinimap(Minecraft mc) {
        scScale = 1;
        while (this.game.func_228018_at_().func_198109_k() / (scScale + 1) >= 320 && this.game.func_228018_at_().func_198091_l() / (scScale + 1) >= 240) {
            ++scScale;
        }
        scaledWidthD = (double)this.game.func_228018_at_().func_198109_k() / (double)(scScale += this.fullscreenMap != false ? 0 : this.options.sizeModifier);
        scaledHeightD = (double)this.game.func_228018_at_().func_198091_l() / (double)scScale;
        this.scWidth = MathHelper.func_76143_f((double)scaledWidthD);
        this.scHeight = MathHelper.func_76143_f((double)scaledHeightD);
        GLShim.glMatrixMode(5889);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glOrtho(0.0, scaledWidthD, scaledHeightD, 0.0, 1000.0, 3000.0);
        GLShim.glMatrixMode(5888);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glTranslatef(0.0f, 0.0f, -2000.0f);
        v0 = this.options.mapCorner;
        this.options.getClass();
        if (v0 == 0) ** GOTO lbl-1000
        v1 = this.options.mapCorner;
        this.options.getClass();
        if (v1 == 3) lbl-1000:
        // 2 sources

        {
            this.mapX = 37;
        } else {
            this.mapX = this.scWidth - 37;
        }
        v2 = this.options.mapCorner;
        this.options.getClass();
        if (v2 == 0) ** GOTO lbl-1000
        v3 = this.options.mapCorner;
        this.options.getClass();
        if (v3 == 1) lbl-1000:
        // 2 sources

        {
            this.mapY = 37;
        } else {
            this.mapY = this.scHeight - 37;
        }
        v4 = this.options.mapCorner;
        this.options.getClass();
        if (v4 == 1 && this.game.field_71439_g.func_70651_bq().size() > 0) {
            statusIconOffset = 0.0f;
            statusEffectInstances = this.game.field_71439_g.func_70651_bq();
            for (EffectInstance statusEffectInstance : statusEffectInstances) {
                if (!statusEffectInstance.func_205348_f()) continue;
                if (statusEffectInstance.func_188419_a().func_188408_i()) {
                    statusIconOffset = Math.max(statusIconOffset, 24.0f);
                    continue;
                }
                statusIconOffset = Math.max(statusIconOffset, 50.0f);
            }
            scHeight = this.game.func_228018_at_().func_198087_p();
            resFactor = (float)this.scHeight / (float)scHeight;
            this.mapY += (int)(statusIconOffset * resFactor);
        }
        GLShim.glEnable(3042);
        GLShim.glEnable(3553);
        GLShim.glBlendFunc(770, 0);
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (!this.options.hide) {
            if (this.fullscreenMap) {
                this.renderMapFull(this.scWidth, this.scHeight);
            } else {
                this.renderMap(this.mapX, this.mapY, scScale);
            }
            GLShim.glDisable(2929);
            if (this.master.getRadar() != null && !this.fullscreenMap) {
                this.layoutVariables.updateVars(scScale, this.mapX, this.mapY, this.zoomScale, this.zoomScaleAdjusted);
                this.master.getRadar().OnTickInGame(mc, this.layoutVariables);
            }
            if (!this.fullscreenMap) {
                this.drawDirections(this.mapX, this.mapY);
            }
            GLShim.glEnable(3042);
            if (this.fullscreenMap) {
                this.drawArrow(this.scWidth / 2, this.scHeight / 2);
            } else {
                this.drawArrow(this.mapX, this.mapY);
            }
        }
        if (this.options.coords) {
            this.showCoords(this.mapX, this.mapY);
        }
        if (this.showWelcomeScreen) {
            this.drawWelcomeScreen(this.scWidth, this.scHeight);
        }
        GLShim.glDepthMask(true);
        GLShim.glEnable(2929);
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLShim.glMatrixMode(5889);
        GLShim.glPopMatrix();
        GLShim.glMatrixMode(5888);
        GLShim.glPopMatrix();
        GLShim.glTexParameteri(3553, 10241, 9728);
        GLShim.glTexParameteri(3553, 10240, 9728);
    }

    private void checkForChanges() {
        boolean changed = false;
        if (this.colorManager.checkForChanges()) {
            this.loadMapImage();
            changed = true;
        }
        if (this.options.isChanged()) {
            this.mapImages = this.options.filtering ? this.mapImagesFiltered : this.mapImagesUnfiltered;
            changed = true;
            this.setZoomScale();
        }
        if (changed) {
            this.doFullRender = true;
            this.master.getSettingsAndLightingChangeNotifier().notifyOfChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapCalc(boolean full) {
        int imageX;
        int imageY;
        int currentX = GameVariableAccessShim.xCoord();
        int currentZ = GameVariableAccessShim.zCoord();
        int currentY = GameVariableAccessShim.yCoord();
        int offsetX = currentX - this.lastX;
        int offsetZ = currentZ - this.lastZ;
        int offsetY = currentY - this.lastY;
        int multi = (int)Math.pow(2.0, this.zoom);
        boolean needHeightAndID = false;
        boolean needHeightMap = false;
        boolean needLight = false;
        boolean skyColorChanged = false;
        int skyColor = this.colorManager.getAirColor();
        if (this.lastSkyColor != skyColor) {
            skyColorChanged = true;
            this.lastSkyColor = skyColor;
        }
        if (this.options.lightmap) {
            int torchOffset = this.options.realTimeTorches ? 8 : 0;
            int skylightMultiplier = 16;
            for (int t = 0; t < 16; ++t) {
                if (this.lastLightmapValues[t] == this.lightmapColors[t * skylightMultiplier + torchOffset]) continue;
                needLight = true;
                this.lastLightmapValues[t] = this.lightmapColors[t * skylightMultiplier + torchOffset];
            }
        }
        if (offsetY != 0) {
            ++this.heightMapFudge;
        } else if (this.heightMapFudge != 0) {
            ++this.heightMapFudge;
        }
        if (full || Math.abs(offsetY) >= this.heightMapResetHeight || this.heightMapFudge > this.heightMapResetTime) {
            if (this.lastY != currentY) {
                needHeightMap = true;
            }
            this.lastY = currentY;
            this.heightMapFudge = 0;
        }
        if (Math.abs(offsetX) > 32 * multi || Math.abs(offsetZ) > 32 * multi) {
            full = true;
        }
        boolean nether = false;
        boolean caves = false;
        boolean netherPlayerInOpen = false;
        this.blockPos.setXYZ(this.lastX, Math.max(Math.min(GameVariableAccessShim.yCoord(), this.WORLD_HEIGHT - 1), 0), this.lastZ);
        Chunk playerChunk = this.world.func_175726_f((BlockPos)this.blockPos);
        if (this.game.field_71439_g.field_71093_bK == DimensionType.field_223228_b_) {
            netherPlayerInOpen = this.world.func_217349_x((BlockPos)this.blockPos).func_201576_a(Heightmap.Type.MOTION_BLOCKING, this.blockPos.func_177958_n() & 0xF, this.blockPos.func_177952_p() & 0xF) <= currentY;
            boolean bl = nether = currentY < 126;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && currentY >= 126 && !netherPlayerInOpen) {
                caves = true;
            }
        } else if (this.game.field_71439_g.field_71093_bK == DimensionType.field_223229_c_) {
            boolean endPlayerInOpen;
            boolean bl = endPlayerInOpen = this.world.func_217349_x((BlockPos)this.blockPos).func_201576_a(Heightmap.Type.MOTION_BLOCKING, this.blockPos.func_177958_n() & 0xF, this.blockPos.func_177952_p() & 0xF) <= currentY;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && !endPlayerInOpen) {
                caves = true;
            }
        } else if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && this.world.func_226658_a_(LightType.SKY, (BlockPos)this.blockPos) <= 0) {
            caves = true;
        }
        if (this.lastBeneathRendering != (caves || nether && (currentY <= 125 || !netherPlayerInOpen && this.options.showCaves))) {
            this.lastBeneathRendering = caves || nether && (currentY <= 125 || !netherPlayerInOpen && this.options.showCaves);
            full = true;
        }
        needHeightAndID = needHeightMap && (nether || caves);
        int color24 = -1;
        Object object = this.coordinateLock;
        synchronized (object) {
            if (!full) {
                this.mapImages[this.zoom].moveY(offsetZ);
                this.mapImages[this.zoom].moveX(offsetX);
            }
            this.lastX = currentX;
            this.lastZ = currentZ;
        }
        int startX = currentX - 16 * multi;
        int startZ = currentZ - 16 * multi;
        if (!full) {
            this.mapData[this.zoom].moveZ(offsetZ);
            this.mapData[this.zoom].moveX(offsetX);
            for (imageY = offsetZ > 0 ? 32 * multi - 1 : -offsetZ - 1; imageY >= (offsetZ > 0 ? 32 * multi - offsetZ : 0); --imageY) {
                for (imageX = 0; imageX < 32 * multi; ++imageX) {
                    color24 = this.getPixelColor(true, true, true, true, nether, caves, (World)this.world, multi, startX, startZ, imageX, imageY);
                    this.mapImages[this.zoom].setRGB(imageX, imageY, color24);
                }
            }
            for (imageY = 32 * multi - 1; imageY >= 0; --imageY) {
                for (imageX = offsetX > 0 ? 32 * multi - offsetX : 0; imageX < (offsetX > 0 ? 32 * multi : -offsetX); ++imageX) {
                    color24 = this.getPixelColor(true, true, true, true, nether, caves, (World)this.world, multi, startX, startZ, imageX, imageY);
                    this.mapImages[this.zoom].setRGB(imageX, imageY, color24);
                }
            }
        }
        if (full || this.options.heightmap && needHeightMap || needHeightAndID || this.options.lightmap && needLight || skyColorChanged) {
            for (imageY = 32 * multi - 1; imageY >= 0; --imageY) {
                for (imageX = 0; imageX < 32 * multi; ++imageX) {
                    color24 = this.getPixelColor(full, full || needHeightAndID, full, full || needLight || needHeightAndID, nether, caves, (World)this.world, multi, startX, startZ, imageX, imageY);
                    this.mapImages[this.zoom].setRGB(imageX, imageY, color24);
                }
            }
        }
        if ((full || offsetX != 0 || offsetZ != 0 || !this.lastFullscreen) && this.fullscreenMap) {
            int n = this.options.biomeOverlay;
            this.options.getClass();
            if (n != 0) {
                this.mapData[this.zoom].segmentBiomes();
                this.mapData[this.zoom].findCenterOfSegments(!this.options.oldNorth);
            }
        }
        this.lastFullscreen = this.fullscreenMap;
        if (full || offsetX != 0 || offsetZ != 0 || needHeightMap || needLight || skyColorChanged) {
            this.imageChanged = true;
        }
        if (needLight || skyColorChanged) {
            this.master.getSettingsAndLightingChangeNotifier().notifyOfChanges();
        }
    }

    @Override
    public void handleChangeInWorld(int chunkX, int chunkZ, boolean immediate) {
        if (immediate) {
            this.chunkCache[this.zoom].registerChangeAt(chunkX, chunkZ);
        } else {
            this.chunkUpdateQueue.add(new int[]{chunkX, chunkZ, TickCounter.tickCounter});
        }
    }

    @Override
    public void processChunk(Chunk chunk) {
        this.rectangleCalc(chunk.func_76632_l().field_77276_a * 16, chunk.func_76632_l().field_77275_b * 16, chunk.func_76632_l().field_77276_a * 16 + 15, chunk.func_76632_l().field_77275_b * 16 + 15);
    }

    private void rectangleCalc(int left, int top, int right, int bottom) {
        boolean nether = false;
        boolean caves = false;
        boolean netherPlayerInOpen = false;
        this.blockPos.setXYZ(this.lastX, Math.max(Math.min(GameVariableAccessShim.yCoord(), this.WORLD_HEIGHT - 1), 0), this.lastZ);
        Chunk playerChunk = this.world.func_175726_f((BlockPos)this.blockPos);
        if (this.game.field_71439_g.field_71093_bK == DimensionType.field_223228_b_) {
            int currentY = GameVariableAccessShim.yCoord();
            netherPlayerInOpen = this.world.func_175710_j((BlockPos)this.blockPos);
            boolean bl = nether = currentY < 126;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && currentY >= 126 && !netherPlayerInOpen) {
                caves = true;
            }
        } else if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && this.world.func_226658_a_(LightType.SKY, (BlockPos)this.blockPos) <= 0) {
            caves = true;
        }
        int startX = this.lastX;
        int startZ = this.lastZ;
        int multi = (int)Math.pow(2.0, this.zoom);
        left = left - (startX -= 16 * multi) - 1;
        right = right - startX + 1;
        top = top - (startZ -= 16 * multi) - 1;
        bottom = bottom - startZ + 1;
        left = Math.max(0, left);
        right = Math.min(32 * multi - 1, right);
        top = Math.max(0, top);
        bottom = Math.min(32 * multi - 1, bottom);
        int color24 = 0;
        for (int imageY = bottom; imageY >= top; --imageY) {
            for (int imageX = left; imageX <= right; ++imageX) {
                color24 = this.getPixelColor(true, true, true, true, nether, caves, (World)this.world, multi, startX, startZ, imageX, imageY);
                this.mapImages[this.zoom].setRGB(imageX, imageY, color24);
            }
        }
        this.imageChanged = true;
    }

    private int getPixelColor(boolean needBiome, boolean needHeightAndID, boolean needTint, boolean needLight, boolean nether, boolean caves, World world, int multi, int startX, int startZ, int imageX, int imageY) {
        int light;
        int surfaceHeight = 0;
        int seafloorHeight = -1;
        int transparentHeight = -1;
        int foliageHeight = -1;
        int surfaceColor = 0;
        int seafloorColor = 0;
        int transparentColor = 0;
        int foliageColor = 0;
        this.surfaceBlockState = null;
        this.transparentBlockState = BlockRepository.air.func_176223_P();
        this.foliageBlockState = BlockRepository.air.func_176223_P();
        this.seafloorBlockState = BlockRepository.air.func_176223_P();
        boolean surfaceBlockChangeForcedTint = false;
        boolean transparentBlockChangeForcedTint = false;
        boolean foliageBlockChangeForcedTint = false;
        boolean seafloorBlockChangeForcedTint = false;
        int surfaceBlockStateID = 0;
        int transparentBlockStateID = 0;
        int foliageBlockStateID = 0;
        int seafloorBlockStateID = 0;
        this.blockPos = this.blockPos.withXYZ(startX + imageX, 0, startZ + imageY);
        int color24 = 0;
        int biomeID = 0;
        if (needBiome) {
            biomeID = world.func_175667_e((BlockPos)this.blockPos) ? Registry.field_212624_m.func_148757_b((Object)world.func_226691_t_((BlockPos)this.blockPos)) : -1;
            this.mapData[this.zoom].setBiomeID(imageX, imageY, biomeID);
        } else {
            biomeID = this.mapData[this.zoom].getBiomeID(imageX, imageY);
        }
        int n = this.options.biomeOverlay;
        this.options.getClass();
        if (n == 1) {
            color24 = biomeID >= 0 ? BiomeRepository.getBiomeColor(biomeID) | 0xFF000000 : 0;
            color24 = this.doSlimeAndGrid(color24, startX + imageX, startZ + imageY);
            return color24;
        }
        boolean solid = false;
        if (needHeightAndID) {
            if (nether || caves) {
                surfaceHeight = this.getNetherHeight(nether, startX + imageX, startZ + imageY);
                this.surfaceBlockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY));
                surfaceBlockStateID = BlockRepository.getStateId(this.surfaceBlockState);
                foliageHeight = surfaceHeight + 1;
                this.blockPos.setXYZ(startX + imageX, foliageHeight - 1, startZ + imageY);
                this.foliageBlockState = world.func_180495_p((BlockPos)this.blockPos);
                Material material = this.foliageBlockState.func_185904_a();
                if (material == Material.field_151597_y || material == Material.field_151579_a || material == Material.field_151587_i || material == Material.field_151586_h) {
                    foliageHeight = -1;
                } else {
                    foliageBlockStateID = BlockRepository.getStateId(this.foliageBlockState);
                }
            } else {
                boolean hasOpacity;
                Chunk chunk = world.func_175726_f((BlockPos)this.blockPos);
                transparentHeight = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, this.blockPos.func_177958_n() & 0xF, this.blockPos.func_177952_p() & 0xF) + 1;
                this.transparentBlockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(startX + imageX, transparentHeight - 1, startZ + imageY));
                IFluidState fluidState = this.transparentBlockState.func_204520_s();
                if (fluidState != Fluids.field_204541_a.func_207188_f()) {
                    this.transparentBlockState = fluidState.func_206883_i();
                }
                surfaceHeight = transparentHeight;
                this.surfaceBlockState = this.transparentBlockState;
                VoxelShape voxelShape = null;
                boolean bl = hasOpacity = this.surfaceBlockState.func_200016_a((IBlockReader)world, (BlockPos)this.blockPos) > 0;
                if (!hasOpacity && this.surfaceBlockState.func_200132_m() && this.surfaceBlockState.func_215691_g()) {
                    voxelShape = this.surfaceBlockState.func_215702_a((IBlockReader)world, (BlockPos)this.blockPos, Direction.DOWN);
                    hasOpacity = VoxelShapes.func_223416_b((VoxelShape)voxelShape, (VoxelShape)VoxelShapes.func_197880_a());
                    voxelShape = this.surfaceBlockState.func_215702_a((IBlockReader)world, (BlockPos)this.blockPos, Direction.UP);
                    boolean bl2 = hasOpacity = hasOpacity || VoxelShapes.func_223416_b((VoxelShape)VoxelShapes.func_197880_a(), (VoxelShape)voxelShape);
                }
                while (!hasOpacity && surfaceHeight > 0) {
                    this.foliageBlockState = this.surfaceBlockState;
                    this.surfaceBlockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(startX + imageX, --surfaceHeight - 1, startZ + imageY));
                    fluidState = this.surfaceBlockState.func_204520_s();
                    if (fluidState != Fluids.field_204541_a.func_207188_f()) {
                        this.surfaceBlockState = fluidState.func_206883_i();
                    }
                    if ((hasOpacity = this.surfaceBlockState.func_200016_a((IBlockReader)world, (BlockPos)this.blockPos) > 0) || !this.surfaceBlockState.func_200132_m() || !this.surfaceBlockState.func_215691_g()) continue;
                    voxelShape = this.surfaceBlockState.func_215702_a((IBlockReader)world, (BlockPos)this.blockPos, Direction.DOWN);
                    hasOpacity = VoxelShapes.func_223416_b((VoxelShape)voxelShape, (VoxelShape)VoxelShapes.func_197880_a());
                    voxelShape = this.surfaceBlockState.func_215702_a((IBlockReader)world, (BlockPos)this.blockPos, Direction.UP);
                    hasOpacity = hasOpacity || VoxelShapes.func_223416_b((VoxelShape)VoxelShapes.func_197880_a(), (VoxelShape)voxelShape);
                }
                if (surfaceHeight == transparentHeight) {
                    transparentHeight = -1;
                    this.transparentBlockState = BlockRepository.air.func_176223_P();
                    this.foliageBlockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(startX + imageX, surfaceHeight, startZ + imageY));
                }
                if (this.foliageBlockState.func_185904_a() == Material.field_151597_y) {
                    this.surfaceBlockState = this.foliageBlockState;
                    this.foliageBlockState = BlockRepository.air.func_176223_P();
                }
                if (this.foliageBlockState == this.transparentBlockState) {
                    this.foliageBlockState = BlockRepository.air.func_176223_P();
                }
                foliageHeight = this.foliageBlockState == null || this.foliageBlockState.func_185904_a() == Material.field_151579_a ? -1 : surfaceHeight + 1;
                Material material = this.surfaceBlockState.func_185904_a();
                if (material == Material.field_151586_h || material == Material.field_151588_w) {
                    seafloorHeight = surfaceHeight;
                    this.seafloorBlockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(startX + imageX, seafloorHeight - 1, startZ + imageY));
                    while (this.seafloorBlockState.func_200016_a((IBlockReader)world, (BlockPos)this.blockPos) < 5 && this.seafloorBlockState.func_185904_a() != Material.field_151584_j && seafloorHeight > 1) {
                        material = this.seafloorBlockState.func_185904_a();
                        if (transparentHeight == -1 && material != Material.field_151588_w && material != Material.field_151586_h && material.func_76230_c()) {
                            transparentHeight = seafloorHeight;
                            this.transparentBlockState = this.seafloorBlockState;
                        }
                        if (foliageHeight == -1 && seafloorHeight != transparentHeight && this.transparentBlockState != this.seafloorBlockState && material != Material.field_151588_w && material != Material.field_151586_h && material != Material.field_151579_a && material != Material.field_203244_i) {
                            foliageHeight = seafloorHeight;
                            this.foliageBlockState = this.seafloorBlockState;
                        }
                        this.seafloorBlockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(startX + imageX, --seafloorHeight - 1, startZ + imageY));
                    }
                    if (this.seafloorBlockState.func_185904_a() == Material.field_151586_h) {
                        this.seafloorBlockState = BlockRepository.air.func_176223_P();
                    }
                }
            }
            surfaceBlockStateID = BlockRepository.getStateId(this.surfaceBlockState);
            if (this.options.biomes && this.surfaceBlockState != this.mapData[this.zoom].getBlockstate(imageX, imageY)) {
                surfaceBlockChangeForcedTint = true;
            }
            this.mapData[this.zoom].setHeight(imageX, imageY, surfaceHeight);
            this.mapData[this.zoom].setBlockstateID(imageX, imageY, surfaceBlockStateID);
            if (this.options.biomes && this.transparentBlockState != this.mapData[this.zoom].getTransparentBlockstate(imageX, imageY)) {
                transparentBlockChangeForcedTint = true;
            }
            this.mapData[this.zoom].setTransparentHeight(imageX, imageY, transparentHeight);
            transparentBlockStateID = BlockRepository.getStateId(this.transparentBlockState);
            this.mapData[this.zoom].setTransparentBlockstateID(imageX, imageY, transparentBlockStateID);
            if (this.options.biomes && this.foliageBlockState != this.mapData[this.zoom].getFoliageBlockstate(imageX, imageY)) {
                foliageBlockChangeForcedTint = true;
            }
            this.mapData[this.zoom].setFoliageHeight(imageX, imageY, foliageHeight);
            foliageBlockStateID = BlockRepository.getStateId(this.foliageBlockState);
            this.mapData[this.zoom].setFoliageBlockstateID(imageX, imageY, foliageBlockStateID);
            if (this.options.biomes && this.seafloorBlockState != this.mapData[this.zoom].getOceanFloorBlockstate(imageX, imageY)) {
                seafloorBlockChangeForcedTint = true;
            }
            this.mapData[this.zoom].setOceanFloorHeight(imageX, imageY, seafloorHeight);
            seafloorBlockStateID = BlockRepository.getStateId(this.seafloorBlockState);
            this.mapData[this.zoom].setOceanFloorBlockstateID(imageX, imageY, seafloorBlockStateID);
        } else {
            surfaceHeight = this.mapData[this.zoom].getHeight(imageX, imageY);
            surfaceBlockStateID = this.mapData[this.zoom].getBlockstateID(imageX, imageY);
            this.surfaceBlockState = BlockRepository.getStateById(surfaceBlockStateID);
            transparentHeight = this.mapData[this.zoom].getTransparentHeight(imageX, imageY);
            transparentBlockStateID = this.mapData[this.zoom].getTransparentBlockstateID(imageX, imageY);
            this.transparentBlockState = BlockRepository.getStateById(transparentBlockStateID);
            foliageHeight = this.mapData[this.zoom].getFoliageHeight(imageX, imageY);
            foliageBlockStateID = this.mapData[this.zoom].getFoliageBlockstateID(imageX, imageY);
            this.foliageBlockState = BlockRepository.getStateById(foliageBlockStateID);
            seafloorHeight = this.mapData[this.zoom].getOceanFloorHeight(imageX, imageY);
            seafloorBlockStateID = this.mapData[this.zoom].getOceanFloorBlockstateID(imageX, imageY);
            this.seafloorBlockState = BlockRepository.getStateById(seafloorBlockStateID);
        }
        if (surfaceHeight == -1) {
            surfaceHeight = this.lastY + 1;
            solid = true;
        }
        if (this.surfaceBlockState.func_185904_a() == Material.field_151587_i) {
            solid = false;
        }
        if (this.options.biomes) {
            surfaceColor = this.colorManager.getBlockColor(this.blockPos, surfaceBlockStateID, biomeID);
            int tint = -1;
            if (needTint || surfaceBlockChangeForcedTint) {
                tint = this.colorManager.getBiomeTint(this.mapData[this.zoom], world, this.surfaceBlockState, surfaceBlockStateID, this.blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY), this.tempBlockPos, startX, startZ);
                this.mapData[this.zoom].setBiomeTint(imageX, imageY, tint);
            } else {
                tint = this.mapData[this.zoom].getBiomeTint(imageX, imageY);
            }
            if (tint != -1) {
                surfaceColor = this.colorManager.colorMultiplier(surfaceColor, tint);
            }
        } else {
            surfaceColor = this.colorManager.getBlockColorWithDefaultTint(this.blockPos, surfaceBlockStateID);
        }
        surfaceColor = this.applyHeight(surfaceColor, nether, caves, world, multi, startX, startZ, imageX, imageY, surfaceHeight, solid, 1);
        int n2 = light = solid ? 0 : 255;
        if (needLight) {
            light = this.getLight(surfaceColor, this.surfaceBlockState, world, startX + imageX, startZ + imageY, surfaceHeight, solid);
            this.mapData[this.zoom].setLight(imageX, imageY, light);
        } else {
            light = this.mapData[this.zoom].getLight(imageX, imageY);
        }
        if (light == 0) {
            surfaceColor = 0;
        } else if (light != 255) {
            surfaceColor = this.colorManager.colorMultiplier(surfaceColor, light);
        }
        if (this.options.waterTransparency && seafloorHeight != -1) {
            if (this.options.biomes) {
                seafloorColor = this.colorManager.getBlockColor(this.blockPos, seafloorBlockStateID, biomeID);
                int tint = -1;
                if (needTint || seafloorBlockChangeForcedTint) {
                    tint = this.colorManager.getBiomeTint(this.mapData[this.zoom], world, this.seafloorBlockState, seafloorBlockStateID, this.blockPos.withXYZ(startX + imageX, seafloorHeight - 1, startZ + imageY), this.tempBlockPos, startX, startZ);
                    this.mapData[this.zoom].setOceanFloorBiomeTint(imageX, imageY, tint);
                } else {
                    tint = this.mapData[this.zoom].getOceanFloorBiomeTint(imageX, imageY);
                }
                if (tint != -1) {
                    seafloorColor = this.colorManager.colorMultiplier(seafloorColor, tint);
                }
            } else {
                seafloorColor = this.colorManager.getBlockColorWithDefaultTint(this.blockPos, seafloorBlockStateID);
            }
            seafloorColor = this.applyHeight(seafloorColor, nether, caves, world, multi, startX, startZ, imageX, imageY, seafloorHeight, solid, 0);
            int seafloorLight = 255;
            if (needLight) {
                seafloorLight = this.getLight(seafloorColor, this.seafloorBlockState, world, startX + imageX, startZ + imageY, seafloorHeight, solid);
                this.blockPos.setXYZ(startX + imageX, seafloorHeight, startZ + imageY);
                BlockState blockStateAbove = world.func_180495_p((BlockPos)this.blockPos);
                Material materialAbove = blockStateAbove.func_185904_a();
                if (this.options.lightmap && materialAbove == Material.field_151588_w) {
                    int multiplier = 255;
                    if (this.game.field_71474_y.field_74348_k == AmbientOcclusionStatus.MIN) {
                        multiplier = 200;
                    } else if (this.game.field_71474_y.field_74348_k == AmbientOcclusionStatus.MAX) {
                        multiplier = 120;
                    }
                    seafloorLight = this.colorManager.colorMultiplier(seafloorLight, 0xFF000000 | multiplier << 16 | multiplier << 8 | multiplier);
                }
                this.mapData[this.zoom].setOceanFloorLight(imageX, imageY, seafloorLight);
            } else {
                seafloorLight = this.mapData[this.zoom].getOceanFloorLight(imageX, imageY);
            }
            if (seafloorLight == 0) {
                seafloorColor = 0;
            } else if (seafloorLight != 255) {
                seafloorColor = this.colorManager.colorMultiplier(seafloorColor, seafloorLight);
            }
        }
        if (this.options.blockTransparency) {
            if (transparentHeight != -1 && this.transparentBlockState != null && this.transparentBlockState != BlockRepository.air.func_176223_P()) {
                if (this.options.biomes) {
                    transparentColor = this.colorManager.getBlockColor(this.blockPos, transparentBlockStateID, biomeID);
                    int tint = -1;
                    if (needTint || transparentBlockChangeForcedTint) {
                        tint = this.colorManager.getBiomeTint(this.mapData[this.zoom], world, this.transparentBlockState, transparentBlockStateID, this.blockPos.withXYZ(startX + imageX, transparentHeight - 1, startZ + imageY), this.tempBlockPos, startX, startZ);
                        this.mapData[this.zoom].setTransparentBiomeTint(imageX, imageY, tint);
                    } else {
                        tint = this.mapData[this.zoom].getTransparentBiomeTint(imageX, imageY);
                    }
                    if (tint != -1) {
                        transparentColor = this.colorManager.colorMultiplier(transparentColor, tint);
                    }
                } else {
                    transparentColor = this.colorManager.getBlockColorWithDefaultTint(this.blockPos, transparentBlockStateID);
                }
                transparentColor = this.applyHeight(transparentColor, nether, caves, world, multi, startX, startZ, imageX, imageY, transparentHeight, solid, 3);
                int transparentLight = 255;
                if (needLight) {
                    transparentLight = this.getLight(transparentColor, this.transparentBlockState, world, startX + imageX, startZ + imageY, transparentHeight, solid);
                    this.mapData[this.zoom].setTransparentLight(imageX, imageY, transparentLight);
                } else {
                    transparentLight = this.mapData[this.zoom].getTransparentLight(imageX, imageY);
                }
                if (transparentLight == 0) {
                    transparentColor = 0;
                } else if (transparentLight != 255) {
                    transparentColor = this.colorManager.colorMultiplier(transparentColor, transparentLight);
                }
            }
            if (foliageHeight != -1 && this.foliageBlockState != null && this.foliageBlockState != BlockRepository.air.func_176223_P()) {
                if (this.options.biomes) {
                    foliageColor = this.colorManager.getBlockColor(this.blockPos, foliageBlockStateID, biomeID);
                    int tint = -1;
                    if (needTint || foliageBlockChangeForcedTint) {
                        tint = this.colorManager.getBiomeTint(this.mapData[this.zoom], world, this.foliageBlockState, foliageBlockStateID, this.blockPos.withXYZ(startX + imageX, foliageHeight - 1, startZ + imageY), this.tempBlockPos, startX, startZ);
                        this.mapData[this.zoom].setFoliageBiomeTint(imageX, imageY, tint);
                    } else {
                        tint = this.mapData[this.zoom].getFoliageBiomeTint(imageX, imageY);
                    }
                    if (tint != -1) {
                        foliageColor = this.colorManager.colorMultiplier(foliageColor, tint);
                    }
                } else {
                    foliageColor = this.colorManager.getBlockColorWithDefaultTint(this.blockPos, foliageBlockStateID);
                }
                foliageColor = this.applyHeight(foliageColor, nether, caves, world, multi, startX, startZ, imageX, imageY, foliageHeight, solid, 2);
                int foliageLight = 255;
                if (needLight) {
                    foliageLight = this.getLight(foliageColor, this.foliageBlockState, world, startX + imageX, startZ + imageY, foliageHeight, solid);
                    this.mapData[this.zoom].setFoliageLight(imageX, imageY, foliageLight);
                } else {
                    foliageLight = this.mapData[this.zoom].getFoliageLight(imageX, imageY);
                }
                if (foliageLight == 0) {
                    foliageColor = 0;
                } else if (foliageLight != 255) {
                    foliageColor = this.colorManager.colorMultiplier(foliageColor, foliageLight);
                }
            }
        }
        if (seafloorColor != 0 && seafloorHeight > 0) {
            color24 = seafloorColor;
            if (foliageColor != 0 && foliageHeight <= surfaceHeight) {
                color24 = this.colorManager.colorAdder(foliageColor, color24);
            }
            if (transparentColor != 0 && transparentHeight <= surfaceHeight) {
                color24 = this.colorManager.colorAdder(transparentColor, color24);
            }
            color24 = this.colorManager.colorAdder(surfaceColor, color24);
        } else {
            color24 = surfaceColor;
        }
        if (foliageColor != 0 && foliageHeight > surfaceHeight) {
            color24 = this.colorManager.colorAdder(foliageColor, color24);
        }
        if (transparentColor != 0 && transparentHeight > surfaceHeight) {
            color24 = this.colorManager.colorAdder(transparentColor, color24);
        }
        int n3 = this.options.biomeOverlay;
        this.options.getClass();
        if (n3 == 2) {
            int bc = 0;
            if (biomeID >= 0) {
                bc = BiomeRepository.getBiomeColor(biomeID);
            }
            bc = 0x7F000000 | bc;
            color24 = this.colorManager.colorAdder(bc, color24);
        }
        color24 = this.doSlimeAndGrid(color24, startX + imageX, startZ + imageY);
        return color24;
    }

    private int doSlimeAndGrid(int color24, int mcX, int mcZ) {
        if (this.options.slimeChunks && !this.master.getWorldSeed().equals("")) {
            int xPosition = mcX >> 4;
            int zPosition = mcZ >> 4;
            String seedString = this.master.getWorldSeed();
            long seed = 0L;
            try {
                seed = Long.parseLong(seedString);
            }
            catch (NumberFormatException e) {
                seed = seedString.hashCode();
            }
            Random random = new Random(seed + (long)(xPosition * xPosition * 4987142) + (long)(xPosition * 5947611) + (long)(zPosition * zPosition) * 4392871L + (long)(zPosition * 389711) ^ 0x3AD8025FL);
            if (random.nextInt(10) == 0) {
                color24 = this.colorManager.colorAdder(2097217280, color24);
            }
        }
        if (this.options.chunkGrid) {
            if (mcX % 512 == 0 || mcZ % 512 == 0) {
                color24 = this.colorManager.colorAdder(2113863680, color24);
            } else if (mcX % 16 == 0 || mcZ % 16 == 0) {
                color24 = this.colorManager.colorAdder(0x7D000000, color24);
            }
        }
        return color24;
    }

    private final int getBlockHeight(boolean nether, boolean caves, World world, int x, int z) {
        int playerHeight = GameVariableAccessShim.yCoord();
        this.blockPos.setXYZ(x, playerHeight, z);
        Chunk chunk = world.func_175726_f((BlockPos)this.blockPos);
        int height = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, this.blockPos.func_177958_n() & 0xF, this.blockPos.func_177952_p() & 0xF) + 1;
        BlockState blockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(x, height - 1, z));
        IFluidState fluidState = this.transparentBlockState.func_204520_s();
        if (fluidState != Fluids.field_204541_a.func_207188_f()) {
            blockState = fluidState.func_206883_i();
        }
        while (blockState.func_200016_a((IBlockReader)world, (BlockPos)this.blockPos) == 0 && height > 0) {
            blockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(x, --height - 1, z));
            fluidState = this.surfaceBlockState.func_204520_s();
            if (fluidState == Fluids.field_204541_a.func_207188_f()) continue;
            blockState = fluidState.func_206883_i();
        }
        if (!nether && !caves || height <= playerHeight) {
            return height;
        }
        return this.getNetherHeight(nether, x, z);
    }

    private int getNetherHeight(boolean nether, int x, int z) {
        int y = this.lastY;
        this.blockPos.setXYZ(x, y, z);
        BlockState blockState = this.world.func_180495_p((BlockPos)this.blockPos);
        if (blockState.func_200016_a((IBlockReader)this.world, (BlockPos)this.blockPos) == 0 && blockState.func_185904_a() != Material.field_151587_i) {
            while (y > 0) {
                this.blockPos.setXYZ(x, --y, z);
                blockState = this.world.func_180495_p((BlockPos)this.blockPos);
                if (blockState.func_200016_a((IBlockReader)this.world, (BlockPos)this.blockPos) <= 0 && blockState.func_185904_a() != Material.field_151587_i) continue;
                return y + 1;
            }
            return y;
        }
        while (y <= this.lastY + 10 && y < (nether ? 127 : 256)) {
            this.blockPos.setXYZ(x, ++y, z);
            blockState = this.world.func_180495_p((BlockPos)this.blockPos);
            if (blockState.func_200016_a((IBlockReader)this.world, (BlockPos)this.blockPos) != 0 || blockState.func_185904_a() == Material.field_151587_i) continue;
            return y;
        }
        return -1;
    }

    private final int getSeafloorHeight(World world, int x, int z, int height) {
        Chunk chunk = world.func_175726_f((BlockPos)this.blockPos);
        BlockState blockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(x, height - 1, z));
        while (blockState.func_200016_a((IBlockReader)world, (BlockPos)this.blockPos) < 5 && blockState.func_185904_a() != Material.field_151584_j && height > 1) {
            blockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(x, --height - 1, z));
        }
        return height;
    }

    private final int getTransparentHeight(boolean nether, boolean caves, World world, int x, int z, int height) {
        int transHeight = -1;
        if (caves || nether) {
            transHeight = -1;
        } else {
            transHeight = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)this.blockPos.withXYZ(x, height, z)).func_177956_o();
            if (transHeight <= height) {
                transHeight = -1;
            }
        }
        BlockState blockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(x, transHeight - 1, z));
        Material material = blockState.func_185904_a();
        if (transHeight == height + 1 && material == Material.field_151597_y) {
            transHeight = -1;
        }
        if (material == Material.field_175972_I && (material = (blockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(x, ++transHeight - 1, z))).func_185904_a()) == Material.field_151579_a) {
            transHeight = -1;
        }
        return transHeight;
    }

    private int applyHeight(int color24, boolean nether, boolean caves, World world, int multi, int startX, int startZ, int imageX, int imageY, int height, boolean solid, int layer) {
        if (color24 != this.colorManager.getAirColor() && color24 != 0 && (this.options.heightmap || this.options.slopemap) && !solid) {
            int heightComp = -1;
            int diff = 0;
            double sc = 0.0;
            if (this.options.slopemap) {
                if (imageX > 0 && imageY < 32 * multi - 1) {
                    Block block;
                    if (layer == 0) {
                        heightComp = this.mapData[this.zoom].getOceanFloorHeight(imageX - 1, imageY + 1);
                    }
                    if (layer == 1) {
                        heightComp = this.mapData[this.zoom].getHeight(imageX - 1, imageY + 1);
                    }
                    if (layer == 2) {
                        heightComp = height;
                    }
                    if (layer == 3 && (heightComp = this.mapData[this.zoom].getTransparentHeight(imageX - 1, imageY + 1)) == -1 && ((block = BlockRepository.getStateById(this.mapData[this.zoom].getTransparentBlockstateID(imageX, imageY)).func_177230_c()) instanceof GlassBlock || block instanceof StainedGlassBlock)) {
                        heightComp = this.mapData[this.zoom].getHeight(imageX - 1, imageY + 1);
                    }
                } else {
                    BlockState blockState;
                    Block block;
                    int baseHeight;
                    if (layer == 0) {
                        baseHeight = this.getBlockHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1);
                        heightComp = this.getSeafloorHeight(world, startX + imageX - 1, startZ + imageY + 1, baseHeight);
                    }
                    if (layer == 1) {
                        heightComp = this.getBlockHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1);
                    }
                    if (layer == 2) {
                        heightComp = height;
                    }
                    if (layer == 3 && (heightComp = this.getTransparentHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1, baseHeight = this.getBlockHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1))) == -1 && ((block = (blockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(startX + imageX, height - 1, startZ + imageY))).func_177230_c()) instanceof GlassBlock || block instanceof StainedGlassBlock)) {
                        heightComp = baseHeight;
                    }
                }
                if (heightComp == -1) {
                    heightComp = height;
                }
                if ((diff = heightComp - height) != 0) {
                    sc = diff > 0 ? 1.0 : (diff < 0 ? -1.0 : 0.0);
                    sc /= 8.0;
                }
                if (this.options.heightmap) {
                    diff = height - this.lastY;
                    double heightsc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 3.0;
                    sc = diff > 0 ? sc + heightsc : sc - heightsc;
                }
            } else if (this.options.heightmap) {
                diff = height - this.lastY;
                sc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 1.8;
                if (diff < 0) {
                    sc = 0.0 - sc;
                }
            }
            int alpha = color24 >> 24 & 0xFF;
            int r = color24 >> 16 & 0xFF;
            int g = color24 >> 8 & 0xFF;
            int b = color24 >> 0 & 0xFF;
            if (sc > 0.0) {
                r = (int)(sc * (double)(255 - r)) + r;
                g = (int)(sc * (double)(255 - g)) + g;
                b = (int)(sc * (double)(255 - b)) + b;
            } else if (sc < 0.0) {
                sc = Math.abs(sc);
                r -= (int)(sc * (double)r);
                g -= (int)(sc * (double)g);
                b -= (int)(sc * (double)b);
            }
            color24 = alpha * 0x1000000 + r * 65536 + g * 256 + b;
        }
        return color24;
    }

    private int getLight(int color24, BlockState blockState, World world, int x, int z, int height, boolean solid) {
        int i3 = 255;
        if (solid) {
            i3 = 0;
        } else if (color24 != this.colorManager.getAirColor() && color24 != 0 && this.options.lightmap) {
            this.blockPos.setXYZ(x, Math.max(Math.min(height, this.WORLD_HEIGHT - 1), 0), z);
            int blockLight = world.func_226658_a_(LightType.BLOCK, (BlockPos)this.blockPos);
            int skyLight = world.func_226658_a_(LightType.SKY, (BlockPos)this.blockPos);
            if (blockState.func_185904_a() == Material.field_151587_i || blockState.func_177230_c() == Blocks.field_196814_hQ) {
                blockLight = 14;
            }
            i3 = this.lightmapColors[blockLight + skyLight * 16];
        }
        return i3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMap(int x, int y, int scScale) {
        float multi22;
        float scale = 1.0f;
        if (this.options.squareMap && this.options.rotates) {
            scale = this.SQRT2;
        }
        if (GLUtils.hasAlphaBits) {
            GLShim.glColorMask(false, false, false, true);
            GLShim.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            GLShim.glClear(16384);
            GLShim.glBlendFunc(770, 771);
            GLShim.glColorMask(true, true, true, true);
            GLUtils.img(new ResourceLocation("voxelmap", this.options.squareMap ? "images/square.png" : "images/circle.png"));
            GLUtils.drawPre();
            GLUtils.setMap(x, y, 128);
            GLUtils.drawPost();
            GLShim.glBlendFunc(772, 773);
            Object object = this.coordinateLock;
            synchronized (object) {
                if (this.imageChanged) {
                    this.imageChanged = false;
                    this.mapImages[this.zoom].write();
                    this.lastImageX = this.lastX;
                    this.lastImageZ = this.lastZ;
                }
            }
            multi22 = (float)(1.0 / this.zoomScaleAdjusted);
            this.percentX = (float)(GameVariableAccessShim.xCoordDouble() - (double)this.lastImageX);
            this.percentY = (float)(GameVariableAccessShim.zCoordDouble() - (double)this.lastImageZ);
            this.percentX *= multi22;
            this.percentY *= multi22;
            GLUtils.disp(this.mapImages[this.zoom].getIndex());
            GLShim.glPushMatrix();
            GLShim.glTranslatef(x, y, 0.0f);
            GLShim.glRotatef(!this.options.rotates ? (float)this.northRotate : -this.direction, 0.0f, 0.0f, 1.0f);
            GLShim.glTranslatef(-x, -y, 0.0f);
            GLShim.glTranslatef(-this.percentX, -this.percentY, 0.0f);
            GLShim.glTexParameteri(3553, 10241, 9987);
            GLShim.glTexParameteri(3553, 10240, 9729);
        } else {
            GLShim.glBindTexture(3553, 0);
            GLShim.glPushAttrib(4096);
            GLShim.glViewport(0, 0, GLUtils.fboSize, GLUtils.fboSize);
            GLShim.glMatrixMode(5889);
            GLShim.glPushMatrix();
            GLShim.glLoadIdentity();
            GLShim.glOrtho(0.0, GLUtils.fboSize, GLUtils.fboSize, 0.0, 1000.0, 3000.0);
            GLShim.glMatrixMode(5888);
            GLShim.glPushMatrix();
            GLShim.glLoadIdentity();
            GLShim.glTranslatef(0.0f, 0.0f, -2000.0f);
            GLUtils.bindFrameBuffer();
            GLShim.glDepthMask(false);
            GLShim.glDisable(2929);
            GLShim.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            GLShim.glClear(16384);
            GLShim.glBlendFunc(770, 0);
            GLUtils.img(new ResourceLocation("voxelmap", this.options.squareMap ? "images/square.png" : "images/circle.png"));
            GLUtils.drawPre();
            GLUtils.ldrawthree((float)GLUtils.fboRad - (float)GLUtils.fboRad / scale, (float)GLUtils.fboRad + (float)GLUtils.fboRad / scale, 1.0, 0.0f, 0.0f);
            GLUtils.ldrawthree((float)GLUtils.fboRad + (float)GLUtils.fboRad / scale, (float)GLUtils.fboRad + (float)GLUtils.fboRad / scale, 1.0, 1.0f, 0.0f);
            GLUtils.ldrawthree((float)GLUtils.fboRad + (float)GLUtils.fboRad / scale, (float)GLUtils.fboRad - (float)GLUtils.fboRad / scale, 1.0, 1.0f, 1.0f);
            GLUtils.ldrawthree((float)GLUtils.fboRad - (float)GLUtils.fboRad / scale, (float)GLUtils.fboRad - (float)GLUtils.fboRad / scale, 1.0, 0.0f, 1.0f);
            GLUtils.drawPost();
            GLShim.glBlendFuncSeparate(1, 0, 774, 0);
            Object multi22 = this.coordinateLock;
            synchronized (multi22) {
                if (this.imageChanged) {
                    this.imageChanged = false;
                    this.mapImages[this.zoom].write();
                    this.lastImageX = this.lastX;
                    this.lastImageZ = this.lastZ;
                }
            }
            multi22 = (float)(1.0 / this.zoomScale);
            this.percentX = (float)(GameVariableAccessShim.xCoordDouble() - (double)this.lastImageX);
            this.percentY = (float)(GameVariableAccessShim.zCoordDouble() - (double)this.lastImageZ);
            this.percentX *= multi22;
            this.percentY *= multi22;
            GLUtils.disp(this.mapImages[this.zoom].getIndex());
            GLShim.glTexParameteri(3553, 10241, 9987);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLShim.glTranslatef(GLUtils.fboRad, GLUtils.fboRad, 0.0f);
            if (!this.options.rotates) {
                GLShim.glRotatef(-this.northRotate, 0.0f, 0.0f, 1.0f);
            } else {
                GLShim.glRotatef(this.direction, 0.0f, 0.0f, 1.0f);
            }
            GLShim.glTranslatef(-GLUtils.fboRad, -GLUtils.fboRad, 0.0f);
            GLShim.glTranslatef(-this.percentX * (float)GLUtils.fboSize / 64.0f, this.percentY * (float)GLUtils.fboSize / 64.0f, 0.0f);
            GLUtils.drawPre();
            GLUtils.ldrawthree(0.0, GLUtils.fboSize, 1.0, 0.0f, 0.0f);
            GLUtils.ldrawthree(GLUtils.fboSize, GLUtils.fboSize, 1.0, 1.0f, 0.0f);
            GLUtils.ldrawthree(GLUtils.fboSize, 0.0, 1.0, 1.0f, 1.0f);
            GLUtils.ldrawthree(0.0, 0.0, 1.0, 0.0f, 1.0f);
            GLUtils.drawPost();
            GLShim.glDepthMask(true);
            GLShim.glEnable(2929);
            GLUtils.unbindFrameBuffer();
            GLShim.glMatrixMode(5889);
            GLShim.glPopMatrix();
            GLShim.glMatrixMode(5888);
            GLShim.glPopMatrix();
            GLShim.glPopAttrib();
            GLShim.glViewport(0, 0, this.game.func_228018_at_().func_198109_k(), this.game.func_228018_at_().func_198091_l());
            GLShim.glPushMatrix();
            GLShim.glBlendFunc(770, 0);
            GLShim.glEnable(3008);
            GLUtils.disp(GLUtils.fboTextureID);
        }
        double guiScale = (double)this.game.func_228018_at_().func_198109_k() / (double)this.scWidth;
        GLShim.glEnable(3089);
        GLShim.glScissor((int)(guiScale * (double)(x - 32)), (int)(guiScale * ((double)(this.scHeight - y) - 32.0)), (int)(guiScale * 64.0), (int)(guiScale * 63.0));
        GLUtils.drawPre();
        GLUtils.setMapWithScale(x, y, scale);
        GLUtils.drawPost();
        GLShim.glDisable(3089);
        GLShim.glPopMatrix();
        GLShim.glBlendFunc(770, 771);
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.options.squareMap) {
            this.drawSquareMapFrame(x, y);
        } else {
            this.drawRoundMapFrame(x, y);
        }
        double lastXDouble = GameVariableAccessShim.xCoordDouble();
        double lastZDouble = GameVariableAccessShim.zCoordDouble();
        TextureAtlas textureAtlas = this.master.getWaypointManager().getTextureAtlas();
        GLUtils.disp(textureAtlas.func_110552_b());
        Waypoint highlightedPoint = this.waypointManager.getHighlightedWaypoint();
        for (Waypoint pt : this.waypointManager.getWaypoints()) {
            double distanceSq;
            if (!pt.isActive() && pt != highlightedPoint || !((distanceSq = pt.getDistanceSqToEntity(this.game.func_175606_aa())) < (double)(this.options.maxWaypointDisplayDistance * this.options.maxWaypointDisplayDistance)) && this.options.maxWaypointDisplayDistance >= 0 && pt != highlightedPoint) continue;
            this.drawWaypoint(pt, textureAtlas, x, y, scScale, lastXDouble, lastZDouble, null, null, null, null);
        }
        if (highlightedPoint != null) {
            this.drawWaypoint(highlightedPoint, textureAtlas, x, y, scScale, lastXDouble, lastZDouble, textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png"), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
        }
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawWaypoint(Waypoint pt, TextureAtlas textureAtlas, int x, int y, int scScale, double lastXDouble, double lastZDouble, Sprite icon, Float r, Float g, Float b) {
        boolean uprightIcon;
        boolean bl = uprightIcon = icon != null;
        if (r == null) {
            r = Float.valueOf(pt.red);
        }
        if (g == null) {
            g = Float.valueOf(pt.green);
        }
        if (b == null) {
            b = Float.valueOf(pt.blue);
        }
        double wayX = lastXDouble - (double)pt.getX() - 0.5;
        double wayY = lastZDouble - (double)pt.getZ() - 0.5;
        float locate = (float)Math.toDegrees(Math.atan2(wayX, wayY));
        double hypot = Math.sqrt(wayX * wayX + wayY * wayY);
        boolean far = false;
        locate = this.options.rotates ? (locate += this.direction) : (locate -= (float)this.northRotate);
        hypot /= this.zoomScaleAdjusted;
        if (this.options.squareMap) {
            double radLocate = Math.toRadians(locate);
            double dispX = hypot * Math.cos(radLocate);
            double dispY = hypot * Math.sin(radLocate);
            boolean bl2 = far = Math.abs(dispX) > 28.5 || Math.abs(dispY) > 28.5;
            if (far) {
                hypot = hypot / Math.max(Math.abs(dispX), Math.abs(dispY)) * 30.0;
            }
        } else {
            boolean bl3 = far = hypot >= 31.0;
            if (far) {
                hypot = 34.0;
            }
        }
        boolean target = false;
        if (far) {
            try {
                if (icon == null) {
                    icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/marker" + pt.imageSuffix + ".png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/marker" + pt.imageSuffix + "Small.png");
                    if (icon == textureAtlas.getMissingImage()) {
                        icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/marker.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/markerSmall.png");
                    }
                } else {
                    target = true;
                }
                GLShim.glPushMatrix();
                GLShim.glColor4f(r.floatValue(), g.floatValue(), b.floatValue(), pt.enabled || target ? 1.0f : 0.3f);
                GLShim.glTexParameteri(3553, 10241, 9729);
                GLShim.glTexParameteri(3553, 10240, 9729);
                GLShim.glTranslatef(x, y, 0.0f);
                GLShim.glRotatef(-locate, 0.0f, 0.0f, 1.0f);
                if (uprightIcon) {
                    GLShim.glTranslated(0.0, -hypot, 0.0);
                    GLShim.glRotatef(locate, 0.0f, 0.0f, 1.0f);
                    GLShim.glTranslatef(-x, -y, 0.0f);
                } else {
                    GLShim.glTranslatef(-x, -y, 0.0f);
                    GLShim.glTranslated(0.0, -hypot, 0.0);
                }
                GLUtils.drawPre();
                GLUtils.setMap(icon, x, y, 16.0f);
                GLUtils.drawPost();
            }
            catch (Exception localException) {
                this.error = "Error: marker overlay not found!";
            }
            finally {
                GLShim.glPopMatrix();
            }
        } else {
            try {
                if (icon == null) {
                    icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + "Small.png");
                    if (icon == textureAtlas.getMissingImage()) {
                        icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypointSmall.png");
                    }
                } else {
                    target = true;
                }
                GLShim.glPushMatrix();
                GLShim.glColor4f(r.floatValue(), g.floatValue(), b.floatValue(), pt.enabled || target ? 1.0f : 0.3f);
                GLShim.glTexParameteri(3553, 10241, 9729);
                GLShim.glTexParameteri(3553, 10240, 9729);
                GLShim.glRotatef(-locate, 0.0f, 0.0f, 1.0f);
                GLShim.glTranslated(0.0, -hypot, 0.0);
                GLShim.glRotatef(-(-locate), 0.0f, 0.0f, 1.0f);
                GLUtils.drawPre();
                GLUtils.setMap(icon, x, y, 16.0f);
                GLUtils.drawPost();
            }
            catch (Exception localException) {
                this.error = "Error: waypoint overlay not found!";
            }
            finally {
                GLShim.glPopMatrix();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawArrow(int x, int y) {
        try {
            GLShim.glPushMatrix();
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLShim.glBlendFunc(770, 771);
            GLUtils.img(new ResourceLocation("voxelmap", "images/mmarrow.png"));
            GLShim.glTexParameteri(3553, 10241, 9729);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLShim.glTranslatef(x, y, 0.0f);
            GLShim.glRotatef(!this.options.rotates || this.fullscreenMap ? this.direction + (float)this.northRotate : 0.0f, 0.0f, 0.0f, 1.0f);
            GLShim.glTranslatef(-x, -y, 0.0f);
            GLUtils.drawPre();
            GLUtils.setMap(x, y, 16);
            GLUtils.drawPost();
        }
        catch (Exception localException) {
            this.error = "Error: minimap arrow not found!";
        }
        finally {
            GLShim.glPopMatrix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMapFull(int scWidth, int scHeight) {
        Object object = this.coordinateLock;
        synchronized (object) {
            if (this.imageChanged) {
                this.imageChanged = false;
                this.mapImages[this.zoom].write();
                this.lastImageX = this.lastX;
                this.lastImageZ = this.lastZ;
            }
        }
        GLUtils.disp(this.mapImages[this.zoom].getIndex());
        GLShim.glTexParameteri(3553, 10241, 9987);
        GLShim.glTexParameteri(3553, 10240, 9729);
        GLShim.glPushMatrix();
        GLShim.glTranslatef((float)scWidth / 2.0f, (float)scHeight / 2.0f, 0.0f);
        GLShim.glRotatef(this.northRotate, 0.0f, 0.0f, 1.0f);
        GLShim.glTranslatef(-((float)scWidth / 2.0f), -((float)scHeight / 2.0f), 0.0f);
        GLShim.glDisable(2929);
        GLUtils.drawPre();
        int left = scWidth / 2 - 128;
        int top = scHeight / 2 - 128;
        GLUtils.ldrawone(left, top + 256, 160.0, 0.0f, 1.0f);
        GLUtils.ldrawone(left + 256, top + 256, 160.0, 1.0f, 1.0f);
        GLUtils.ldrawone(left + 256, top, 160.0, 1.0f, 0.0f);
        GLUtils.ldrawone(left, top, 160.0, 0.0f, 0.0f);
        GLUtils.drawPost();
        GLShim.glPopMatrix();
        int n = this.options.biomeOverlay;
        this.options.getClass();
        if (n != 0) {
            double factor = Math.pow(2.0, 3 - this.zoom);
            int minimumSize = (int)Math.pow(2.0, this.zoom);
            minimumSize *= minimumSize;
            ArrayList<AbstractMapData.BiomeLabel> labels = this.mapData[this.zoom].getBiomeLabels();
            GLShim.glDisable(2929);
            GLShim.glPushMatrix();
            GLShim.glTranslated(0.0, 0.0, 160.0);
            for (int t = 0; t < labels.size(); ++t) {
                AbstractMapData.BiomeLabel label = labels.get(t);
                if (label.segmentSize <= minimumSize) continue;
                String name = label.name;
                int nameWidth = this.chkLen(name);
                float x = (float)((double)label.x * factor);
                float z = (float)((double)label.z * factor);
                if (this.options.oldNorth) {
                    this.write(name, (float)(left + 256) - z - (float)(nameWidth / 2), (float)top + x - 3.0f, 0xFFFFFF);
                    continue;
                }
                this.write(name, (float)left + x - (float)(nameWidth / 2), (float)top + z - 3.0f, 0xFFFFFF);
            }
            GLShim.glPopMatrix();
            GLShim.glEnable(2929);
        }
    }

    private void drawSquareMapFrame(int x, int y) {
        try {
            GLUtils.disp(this.mapImageInt);
            GLShim.glTexParameteri(3553, 10241, 9729);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLShim.glTexParameteri(3553, 10242, 10496);
            GLShim.glTexParameteri(3553, 10243, 10496);
            GLUtils.drawPre();
            GLUtils.setMap(x, y, 128);
            GLUtils.drawPost();
        }
        catch (Exception localException) {
            this.error = "error: minimap overlay not found!";
        }
    }

    private void loadMapImage() {
        if (this.mapImageInt != -1) {
            GLUtils.glah(this.mapImageInt);
        }
        try {
            InputStream is = this.game.func_195551_G().func_199002_a(new ResourceLocation("voxelmap", "images/squaremap.png")).func_199027_b();
            BufferedImage mapImage = ImageIO.read(is);
            is.close();
            this.mapImageInt = GLUtils.tex(mapImage);
        }
        catch (Exception e) {
            try {
                InputStream is = this.game.func_195551_G().func_199002_a(new ResourceLocation("textures/map/map_background.png")).func_199027_b();
                BufferedImage tpMap = ImageIO.read(is);
                is.close();
                BufferedImage mapImage = new BufferedImage(((Image)tpMap).getWidth(null), ((Image)tpMap).getHeight(null), 2);
                Graphics2D gfx = mapImage.createGraphics();
                gfx.drawImage((Image)tpMap, 0, 0, null);
                int border = mapImage.getWidth() * 8 / 128;
                gfx.setComposite(AlphaComposite.Clear);
                gfx.fillRect(border, border, mapImage.getWidth() - border * 2, mapImage.getHeight() - border * 2);
                gfx.dispose();
                this.mapImageInt = GLUtils.tex(mapImage);
            }
            catch (Exception f) {
                System.err.println("Error loading texture pack's map image: " + f.getLocalizedMessage());
            }
        }
    }

    private void drawRoundMapFrame(int x, int y) {
        try {
            GLUtils.img(new ResourceLocation("voxelmap", "images/roundmap.png"));
            GLShim.glTexParameteri(3553, 10241, 9729);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLUtils.drawPre();
            GLUtils.setMap(x, y, 128);
            GLUtils.drawPost();
        }
        catch (Exception localException) {
            this.error = "Error: minimap overlay not found!";
        }
    }

    private void drawDirections(int x, int y) {
        float distance;
        boolean unicode = false;
        float scale = unicode ? 1.0f : 0.5f;
        float rotate = this.options.rotates ? -this.direction - 90.0f - (float)this.northRotate : -90.0f;
        if (this.options.squareMap) {
            if (this.options.rotates) {
                float tempdir = this.direction % 90.0f;
                tempdir = 45.0f - Math.abs(45.0f - tempdir);
                distance = (float)(33.5 / (double)scale / Math.cos(Math.toRadians(tempdir)));
            } else {
                distance = 33.5f / scale;
            }
        } else {
            distance = 32.0f / scale;
        }
        GLShim.glPushMatrix();
        GLShim.glScalef(scale, scale, 1.0f);
        GLShim.glTranslated((double)distance * Math.sin(Math.toRadians(-((double)rotate - 90.0))), (double)distance * Math.cos(Math.toRadians(-((double)rotate - 90.0))), 10.0);
        this.write("N", (float)x / scale - 2.0f, (float)y / scale - 4.0f, 0xFFFFFF);
        GLShim.glPopMatrix();
        GLShim.glPushMatrix();
        GLShim.glScalef(scale, scale, 1.0f);
        GLShim.glTranslated((double)distance * Math.sin(Math.toRadians(-rotate)), (double)distance * Math.cos(Math.toRadians(-rotate)), 10.0);
        this.write("E", (float)x / scale - 2.0f, (float)y / scale - 4.0f, 0xFFFFFF);
        GLShim.glPopMatrix();
        GLShim.glPushMatrix();
        GLShim.glScalef(scale, scale, 1.0f);
        GLShim.glTranslated((double)distance * Math.sin(Math.toRadians(-((double)rotate + 90.0))), (double)distance * Math.cos(Math.toRadians(-((double)rotate + 90.0))), 10.0);
        this.write("S", (float)x / scale - 2.0f, (float)y / scale - 4.0f, 0xFFFFFF);
        GLShim.glPopMatrix();
        GLShim.glPushMatrix();
        GLShim.glScalef(scale, scale, 1.0f);
        GLShim.glTranslated((double)distance * Math.sin(Math.toRadians(-((double)rotate + 180.0))), (double)distance * Math.cos(Math.toRadians(-((double)rotate + 180.0))), 10.0);
        this.write("W", (float)x / scale - 2.0f, (float)y / scale - 4.0f, 0xFFFFFF);
        GLShim.glPopMatrix();
    }

    private void showCoords(int x, int y) {
        int textStart = y > this.scHeight - 37 - 32 - 4 - 15 ? y - 32 - 4 - 9 : y + 32 + 4;
        if (!this.options.hide && !this.fullscreenMap) {
            boolean unicode = false;
            float scale = unicode ? 1.0f : 0.5f;
            GLShim.glPushMatrix();
            GLShim.glScalef(scale, scale, 1.0f);
            String xy = this.dCoord(GameVariableAccessShim.xCoord()) + ", " + this.dCoord(GameVariableAccessShim.zCoord());
            int m = this.chkLen(xy) / 2;
            this.write(xy, (float)x / scale - (float)m, (float)textStart / scale, 0xFFFFFF);
            xy = Integer.toString(GameVariableAccessShim.yCoord());
            m = this.chkLen(xy) / 2;
            this.write(xy, (float)x / scale - (float)m, (float)textStart / scale + 10.0f, 0xFFFFFF);
            if (this.ztimer > 0) {
                m = this.chkLen(this.error) / 2;
                this.write(this.error, (float)x / scale - (float)m, (float)textStart / scale + 19.0f, 0xFFFFFF);
            }
            GLShim.glPopMatrix();
        } else {
            int heading = (int)(this.direction + (float)this.northRotate);
            if (heading > 360) {
                heading -= 360;
            }
            String stats = "(" + this.dCoord(GameVariableAccessShim.xCoord()) + ", " + GameVariableAccessShim.yCoord() + ", " + this.dCoord(GameVariableAccessShim.zCoord()) + ") " + heading + "'";
            int m = this.chkLen(stats) / 2;
            this.write(stats, this.scWidth / 2 - m, 5.0f, 0xFFFFFF);
            if (this.ztimer > 0) {
                m = this.chkLen(this.error) / 2;
                this.write(this.error, this.scWidth / 2 - m, 15.0f, 0xFFFFFF);
            }
        }
    }

    private String dCoord(int paramInt1) {
        if (paramInt1 < 0) {
            return "-" + Math.abs(paramInt1);
        }
        if (paramInt1 > 0) {
            return "+" + paramInt1;
        }
        return " " + paramInt1;
    }

    private int chkLen(String paramStr) {
        return this.fontRenderer.func_78256_a(paramStr);
    }

    private void write(String text, float x, float y, int color) {
        this.fontRenderer.func_175063_a(text, x, y, color);
    }

    private void drawWelcomeScreen(int scWidth, int scHeight) {
        int height;
        if (this.welcomeString[1] == null || this.welcomeString[1].equals("minimap.ui.welcome2")) {
            this.welcomeString[0] = "\u00a74VoxelMap\u00a7F! " + this.zmodver + " " + I18nUtils.getString("minimap.ui.welcome1", new Object[0]);
            this.welcomeString[1] = I18nUtils.getString("minimap.ui.welcome2", new Object[0]);
            this.welcomeString[2] = I18nUtils.getString("minimap.ui.welcome3", new Object[0]);
            this.welcomeString[3] = I18nUtils.getString("minimap.ui.welcome4", new Object[0]);
            this.welcomeString[4] = "\u00a7B" + this.options.keyBindZoom.func_197978_k() + "\u00a7F: " + I18nUtils.getString("minimap.ui.welcome5a", new Object[0]) + ", \u00a7B" + this.options.keyBindMenu.func_197978_k() + "\u00a7F: " + I18nUtils.getString("minimap.ui.welcome5b", new Object[0]);
            this.welcomeString[5] = "\u00a7B" + this.options.keyBindFullscreen.func_197978_k() + "\u00a7F: " + I18nUtils.getString("minimap.ui.welcome6", new Object[0]);
            this.welcomeString[6] = "\u00a7B" + this.options.keyBindWaypoint.func_197978_k() + "\u00a7F: " + I18nUtils.getString("minimap.ui.welcome7", new Object[0]);
            this.welcomeString[7] = "\u00a7F" + this.options.keyBindZoom.func_197978_k() + "\u00a77: " + I18nUtils.getString("minimap.ui.welcome8", new Object[0]);
        }
        GLShim.glBlendFunc(770, 771);
        int maxSize = 0;
        int border = 2;
        String head = this.welcomeString[0];
        for (height = 1; height < this.welcomeString.length - 1; ++height) {
            if (this.chkLen(this.welcomeString[height]) <= maxSize) continue;
            maxSize = this.chkLen(this.welcomeString[height]);
        }
        int title = this.chkLen(head);
        int centerX = (int)((double)(scWidth + 5) / 2.0);
        int centerY = (int)((double)(scHeight + 5) / 2.0);
        String hide = this.welcomeString[this.welcomeString.length - 1];
        int footer = this.chkLen(hide);
        GLShim.glDisable(3553);
        GLShim.glColor4f(0.0f, 0.0f, 0.0f, 0.7f);
        double leftX = (double)centerX - (double)title / 2.0 - (double)border;
        double rightX = (double)centerX + (double)title / 2.0 + (double)border;
        double topY = (double)centerY - (double)(height - 1) / 2.0 * 10.0 - (double)border - 20.0;
        double botY = (double)centerY - (double)(height - 1) / 2.0 * 10.0 + (double)border - 10.0;
        this.drawBox(leftX, rightX, topY, botY);
        leftX = (double)centerX - (double)maxSize / 2.0 - (double)border;
        rightX = (double)centerX + (double)maxSize / 2.0 + (double)border;
        topY = (double)centerY - (double)(height - 1) / 2.0 * 10.0 - (double)border;
        botY = (double)centerY + (double)(height - 1) / 2.0 * 10.0 + (double)border;
        this.drawBox(leftX, rightX, topY, botY);
        leftX = (double)centerX - (double)footer / 2.0 - (double)border;
        rightX = (double)centerX + (double)footer / 2.0 + (double)border;
        topY = (double)centerY + (double)(height - 1) / 2.0 * 10.0 - (double)border + 10.0;
        botY = (double)centerY + (double)(height - 1) / 2.0 * 10.0 + (double)border + 20.0;
        this.drawBox(leftX, rightX, topY, botY);
        GLShim.glEnable(3553);
        this.write(head, centerX - title / 2, centerY - (height - 1) * 10 / 2 - 19, 0xFFFFFF);
        for (int n = 1; n < height; ++n) {
            this.write(this.welcomeString[n], centerX - maxSize / 2, centerY - (height - 1) * 10 / 2 + n * 10 - 9, 0xFFFFFF);
        }
        this.write(hide, centerX - footer / 2, (scHeight + 5) / 2 + (height - 1) * 10 / 2 + 11, 0xFFFFFF);
    }

    private void drawBox(double leftX, double rightX, double topY, double botY) {
        GLUtils.drawPre(DefaultVertexFormats.field_181705_e);
        GLUtils.ldrawtwo(leftX, botY, 0.0);
        GLUtils.ldrawtwo(rightX, botY, 0.0);
        GLUtils.ldrawtwo(rightX, topY, 0.0);
        GLUtils.ldrawtwo(leftX, topY, 0.0);
        GLUtils.drawPost();
    }
}

