/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiSelectPlayer;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiButtonRowListPlayers
extends ExtendedList {
    private final Minecraft client = Minecraft.func_71410_x();
    private ArrayList<NetworkPlayerInfo> players;
    private ArrayList<NetworkPlayerInfo> playersFiltered;
    final GuiSelectPlayer parentGui;
    Row everyoneRow;

    public GuiButtonRowListPlayers(GuiSelectPlayer par1GuiSelectPlayer) {
        super(Minecraft.func_71410_x(), par1GuiSelectPlayer.getWidth(), par1GuiSelectPlayer.getHeight(), 89, par1GuiSelectPlayer.getHeight() - 65 + 4, 25);
        this.parentGui = par1GuiSelectPlayer;
        ClientPlayNetHandler netHandlerPlayClient = Minecraft.func_71410_x().field_71439_g.field_71174_a;
        this.players = new ArrayList(netHandlerPlayClient.func_175106_d());
        this.sort();
        Button everyoneButton = new Button(this.parentGui.getWidth() / 2 - 75, 0, 150, 20, I18nUtils.getString("minimap.waypointshare.all", new Object[0]), null){

            public void onPress() {
            }
        };
        this.everyoneRow = new Row(everyoneButton, -1);
        this.updateFilter("");
    }

    public String getPlayerName(NetworkPlayerInfo ScoreboardEntryIn) {
        return ScoreboardEntryIn.func_178854_k() != null ? ScoreboardEntryIn.func_178854_k().getString() : TextUtils.scrubCodes(ScoreboardEntryIn.func_178845_a().getName());
    }

    private Button createButtonFor(Minecraft mcIn, int x, int y, NetworkPlayerInfo ScoreboardEntry) {
        if (ScoreboardEntry == null) {
            return null;
        }
        String name = this.getPlayerName(ScoreboardEntry);
        return new Button(x, y, 150, 20, name, null){

            public void onPress() {
            }
        };
    }

    public Row getListEntry(int index) {
        return this.getListEntry(index);
    }

    public int getRowWidth() {
        return 400;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 32;
    }

    protected void sort() {
        final Collator collator = I18nUtils.getLocaleAwareCollator();
        Collections.sort(this.players, new Comparator<NetworkPlayerInfo>(){

            @Override
            public int compare(NetworkPlayerInfo player1, NetworkPlayerInfo player2) {
                String name1 = GuiButtonRowListPlayers.this.getPlayerName(player1);
                String name2 = GuiButtonRowListPlayers.this.getPlayerName(player2);
                return collator.compare(name1, name2);
            }
        });
    }

    protected void updateFilter(String filterString) {
        this.playersFiltered = new ArrayList<NetworkPlayerInfo>(this.players);
        Iterator<NetworkPlayerInfo> iterator = this.playersFiltered.iterator();
        while (iterator.hasNext()) {
            NetworkPlayerInfo ScoreboardEntry = iterator.next();
            String name = this.getPlayerName(ScoreboardEntry);
            if (name.toLowerCase().contains(filterString)) continue;
            iterator.remove();
        }
        this.clearEntries();
        this.addEntry((AbstractList.AbstractListEntry)this.everyoneRow);
        for (int i = 0; i < this.playersFiltered.size(); i += 2) {
            NetworkPlayerInfo ScoreboardEntry1 = this.playersFiltered.get(i);
            NetworkPlayerInfo ScoreboardEntry2 = i < this.playersFiltered.size() - 1 ? this.playersFiltered.get(i + 1) : null;
            Button guibutton1 = this.createButtonFor(this.client, this.parentGui.getWidth() / 2 - 155, 0, ScoreboardEntry1);
            Button guibutton2 = this.createButtonFor(this.client, this.parentGui.getWidth() / 2 - 155 + 160, 0, ScoreboardEntry2);
            this.addEntry((AbstractList.AbstractListEntry)new Row(guibutton1, i, guibutton2, i + 1));
        }
    }

    public void buttonClicked(int id) {
        if (id == -1) {
            this.parentGui.allClicked = true;
            StringTextComponent title = new StringTextComponent(I18nUtils.getString("minimap.waypointshare.sharewitheveryone", new Object[0]));
            StringTextComponent explanation = new StringTextComponent(I18nUtils.getString("minimap.waypointshare.sharewitheveryone2", new Object[0]));
            String affirm = I18nUtils.getString("gui.yes", new Object[0]);
            String deny = I18nUtils.getString("gui.cancel", new Object[0]);
            ConfirmScreen confirmScreen = new ConfirmScreen((BooleanConsumer)this.parentGui, (ITextComponent)title, (ITextComponent)explanation, affirm, deny);
            this.client.func_147108_a((Screen)confirmScreen);
        } else {
            NetworkPlayerInfo ScoreboardEntry = this.playersFiltered.get(id);
            String name = this.getPlayerName(ScoreboardEntry);
            this.parentGui.sendMessageToPlayer(name);
        }
    }

    public class Row
    extends ExtendedList.AbstractListEntry {
        private final Minecraft client = Minecraft.func_71410_x();
        private Button button = null;
        private Button button1 = null;
        private Button button2 = null;
        private int id = 0;
        private int id1 = 0;
        private int id2 = 0;

        public Row(Button button, int id) {
            this.button = button;
            this.id = id;
        }

        public Row(Button button1, int id1, Button button2, int id2) {
            this.button1 = button1;
            this.id1 = id1;
            this.button2 = button2;
            this.id2 = id2;
        }

        public void render(int slotIndex, int y, int x, int listWidth, int itemHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            this.drawButton(this.button, this.id, slotIndex, x, y, listWidth, itemHeight, mouseX, mouseY, isSelected, partialTicks);
            this.drawButton(this.button1, this.id1, slotIndex, x, y, listWidth, itemHeight, mouseX, mouseY, isSelected, partialTicks);
            this.drawButton(this.button2, this.id2, slotIndex, x, y, listWidth, itemHeight, mouseX, mouseY, isSelected, partialTicks);
        }

        private void drawButton(Button button, int id, int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            if (button != null) {
                button.y = y;
                button.render(mouseX, mouseY, partialTicks);
                if (id != -1) {
                    this.drawIconForButton(button, id);
                }
                if (button.isHovered() && mouseY >= GuiButtonRowListPlayers.this.y0 && mouseY <= GuiButtonRowListPlayers.this.y1) {
                    String tooltip = I18nUtils.getString("minimap.waypointshare.sharewithname", button.getMessage());
                    GuiSelectPlayer.setTooltip(GuiButtonRowListPlayers.this.parentGui, tooltip);
                }
            }
        }

        private void drawIconForButton(Button button, int id) {
            NetworkPlayerInfo networkPlayerInfo = (NetworkPlayerInfo)GuiButtonRowListPlayers.this.playersFiltered.get(id);
            GameProfile gameProfile = networkPlayerInfo.func_178845_a();
            PlayerEntity entityPlayer = this.client.field_71441_e.func_217371_b(gameProfile.getId());
            this.client.func_110434_K().func_110577_a(networkPlayerInfo.func_178837_g());
            Screen.blit((int)(button.x + 6), (int)(button.y + 6), (int)8, (int)8, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            if (entityPlayer != null && entityPlayer.func_175148_a(PlayerModelPart.HAT)) {
                Screen.blit((int)(button.x + 6), (int)(button.y + 6), (int)8, (int)8, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseEvent) {
            if (this.button != null && this.button.mouseClicked(mouseX, mouseY, mouseEvent)) {
                GuiButtonRowListPlayers.this.buttonClicked(this.id);
                return true;
            }
            if (this.button1 != null && this.button1.mouseClicked(mouseX, mouseY, mouseEvent)) {
                GuiButtonRowListPlayers.this.buttonClicked(this.id1);
                return true;
            }
            if (this.button2 != null && this.button2.mouseClicked(mouseX, mouseY, mouseEvent)) {
                GuiButtonRowListPlayers.this.buttonClicked(this.id2);
                return true;
            }
            return false;
        }

        public boolean mouseReleased(double mouseX, double mouseY, int mouseEvent) {
            if (this.button != null) {
                this.button.mouseReleased(mouseX, mouseY, mouseEvent);
                return true;
            }
            if (this.button1 != null) {
                this.button1.mouseReleased(mouseX, mouseY, mouseEvent);
                return true;
            }
            if (this.button2 != null) {
                this.button2.mouseReleased(mouseX, mouseY, mouseEvent);
                return true;
            }
            return false;
        }
    }
}

