/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiButtonRowListPlayers;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;

public class GuiSelectPlayer
extends GuiScreenMinimap
implements BooleanConsumer {
    private final Screen parentScreen;
    protected String screenTitle = "Players";
    private boolean sharingWaypoint = true;
    private GuiButtonRowListPlayers playerList;
    protected boolean allClicked = false;
    protected TextFieldWidget message;
    protected TextFieldWidget filter;
    private String tooltip = null;
    private String locInfo;
    private final int maxMessageLength = 78;

    public GuiSelectPlayer(Screen parentScreen, IVoxelMap master, String locInfo, boolean sharingWaypoint) {
        this.parentScreen = parentScreen;
        this.locInfo = locInfo;
        this.sharingWaypoint = sharingWaypoint;
    }

    public void tick() {
        this.message.func_146178_a();
        this.filter.func_146178_a();
    }

    public void init() {
        this.screenTitle = I18nUtils.getString(this.sharingWaypoint ? "minimap.waypointshare.title" : "minimap.waypointshare.titlecoordinate", new Object[0]);
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.playerList = new GuiButtonRowListPlayers(this);
        int messageStringWidth = this.getFontRenderer().func_78256_a(I18nUtils.getString("minimap.waypointshare.sharemessage", new Object[0]) + ":");
        this.message = new TextFieldWidget(this.getFontRenderer(), this.getWidth() / 2 - 153 + messageStringWidth + 5, 34, 305 - messageStringWidth - 5, 20, "");
        this.message.func_146203_f(78);
        this.addButton((Widget)this.message);
        int filterStringWidth = this.getFontRenderer().func_78256_a(I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":");
        this.filter = new TextFieldWidget(this.getFontRenderer(), this.getWidth() / 2 - 153 + filterStringWidth + 5, this.getHeight() - 55, 305 - filterStringWidth - 5, 20, "");
        this.filter.func_146203_f(35);
        this.addButton((Widget)this.filter);
        this.addButton((Widget)new Button(this.width / 2 - 100, this.height - 27, 150, 20, I18nUtils.getString("gui.cancel", new Object[0]), null){

            public void onPress() {
                GuiSelectPlayer.this.actionPerformed(this, -200);
            }
        });
        this.setFocused((IGuiEventListener)this.filter);
        this.filter.func_146195_b(true);
    }

    protected void actionPerformed(Button par1GuiButton, int id) {
        if (par1GuiButton.active && id == -200) {
            this.getMinecraft().func_147108_a(this.parentScreen);
        }
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        boolean OK = super.keyPressed(keysm, scancode, b);
        if (this.filter.isFocused()) {
            this.playerList.updateFilter(this.filter.func_146179_b().toLowerCase());
        }
        return OK;
    }

    public boolean charTyped(char character, int keycode) {
        boolean OK = super.charTyped(character, keycode);
        if (this.filter.isFocused()) {
            this.playerList.updateFilter(this.filter.func_146179_b().toLowerCase());
        }
        return OK;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.playerList.mouseClicked(mouseX, mouseY, mouseButton);
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.playerList.mouseReleased(mouseX, mouseY, mouseButton);
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseEvent, double deltaX, double deltaY) {
        return this.playerList.mouseDragged(mouseX, mouseY, mouseEvent, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        return this.playerList.mouseScrolled(mouseX, mouseY, amount);
    }

    public void accept(boolean par1) {
        if (this.allClicked) {
            this.allClicked = false;
            if (par1) {
                String combined = this.message.func_146179_b() + " " + this.locInfo;
                if (combined.length() > 100) {
                    this.minecraft.field_71439_g.func_71165_d(this.message.func_146179_b());
                    this.minecraft.field_71439_g.func_71165_d(this.locInfo);
                } else {
                    this.minecraft.field_71439_g.func_71165_d(combined);
                }
                this.getMinecraft().func_147108_a(this.parentScreen);
            } else {
                this.getMinecraft().func_147108_a((Screen)this);
            }
        }
    }

    protected void sendMessageToPlayer(String name) {
        String combined = "/msg " + name + " " + this.message.func_146179_b() + " " + this.locInfo;
        if (combined.length() > 100) {
            this.getMinecraft().field_71439_g.func_71165_d("/msg " + name + " " + this.message.func_146179_b());
            this.getMinecraft().field_71439_g.func_71165_d("/msg " + name + " " + this.locInfo);
        } else {
            this.getMinecraft().field_71439_g.func_71165_d(combined);
        }
        this.getMinecraft().func_147108_a(this.parentScreen);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.drawMap();
        this.tooltip = null;
        this.playerList.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
        this.drawString(this.getFontRenderer(), I18nUtils.getString("minimap.waypointshare.sharemessage", new Object[0]) + ":", this.getWidth() / 2 - 153, 39, 0xA0A0A0);
        this.message.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.getFontRenderer(), I18nUtils.getString("minimap.waypointshare.sharewith", new Object[0]), this.getWidth() / 2, 75, 0xFFFFFF);
        this.drawString(this.getFontRenderer(), I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":", this.getWidth() / 2 - 153, this.getHeight() - 50, 0xA0A0A0);
        this.filter.render(mouseX, mouseY, partialTicks);
        if (this.tooltip != null) {
            this.renderTooltip(this.tooltip, mouseX, mouseY);
        }
    }

    public void renderTooltip(String par1Str, int par2, int par3) {
        if (par1Str != null) {
            int var4 = par2 + 12;
            int var5 = par3 - 12;
            int var6 = this.getFontRenderer().func_78256_a(par1Str);
            this.fillGradient(var4 - 3, var5 - 3, var4 + var6 + 3, var5 + 8 + 3, -1073741824, -1073741824);
            this.getFontRenderer().func_175063_a(par1Str, (float)var4, (float)var5, -1);
        }
    }

    static String setTooltip(GuiSelectPlayer par0GuiWaypoints, String par1Str) {
        par0GuiWaypoints.tooltip = par1Str;
        return par0GuiWaypoints.tooltip;
    }

    @Override
    public void removed() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }
}

