/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public class BiomeRepository {
    private static IdentityHashMap<Biome, Integer> biomeToInt = new IdentityHashMap(256);
    private static int count = 1;
    private static Biome[] biomes = new Biome[65536];
    private static Random generator;
    private static HashMap<Integer, Integer> IDtoColor;
    private static TreeMap<String, Integer> nameToColor;
    private static boolean dirty;

    public static int getBiomeId(Biome biome) {
        Integer id = biomeToInt.get(biome);
        if (id == null) {
            id = count;
            BiomeRepository.biomes[id.intValue()] = biome;
            biomeToInt.put(biome, id);
            ++count;
        }
        return id;
    }

    public static Biome betBiomeByID(int id) {
        return biomes[id];
    }

    public static void loadBiomeColors() {
        File saveDir = new File(Minecraft.func_71410_x().field_71412_D, "/voxelmap/");
        File settingsFile = new File(saveDir, "biomecolors.txt");
        if (settingsFile.exists()) {
            try {
                String sCurrentLine;
                BufferedReader br = new BufferedReader(new FileReader(settingsFile));
                while ((sCurrentLine = br.readLine()) != null) {
                    String[] curLine = sCurrentLine.split("=");
                    if (curLine.length != 2) continue;
                    String name = curLine[0];
                    int color = 0;
                    try {
                        color = Integer.decode(curLine[1]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error decoding integer string for biome colors; " + curLine[1]);
                        color = 0;
                    }
                    if (nameToColor.put(name, color) == null) continue;
                    dirty = true;
                }
                br.close();
            }
            catch (Exception e) {
                System.err.println("biome load error: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        try {
            String sCurrentLine;
            InputStream is = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation("voxelmap", "conf/biomecolors.txt")).func_199027_b();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((sCurrentLine = br.readLine()) != null) {
                String[] curLine = sCurrentLine.split("=");
                if (curLine.length != 2) continue;
                String name = curLine[0];
                int color = 0;
                try {
                    color = Integer.decode(curLine[1]);
                }
                catch (NumberFormatException e) {
                    System.out.println("Error decoding integer string for biome colors; " + curLine[1]);
                    color = 0;
                }
                if (nameToColor.get(name) != null) continue;
                nameToColor.put(name, color);
                dirty = true;
            }
            br.close();
            is.close();
        }
        catch (IOException e) {
            System.out.println("Error loading biome color config file from litemod!");
            e.printStackTrace();
        }
    }

    public static void saveBiomeColors() {
        if (dirty) {
            File saveDir = new File(Minecraft.func_71410_x().field_71412_D, "/voxelmap/");
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File settingsFile = new File(saveDir, "biomecolors.txt");
            try {
                PrintWriter out = new PrintWriter(new FileWriter(settingsFile));
                for (Map.Entry<String, Integer> entry : nameToColor.entrySet()) {
                    String name = entry.getKey();
                    Integer color = entry.getValue();
                    String hexColor = Integer.toHexString(color);
                    while (hexColor.length() < 6) {
                        hexColor = "0" + hexColor;
                    }
                    hexColor = "0x" + hexColor;
                    out.println(name + "=" + hexColor);
                }
                out.close();
            }
            catch (Exception e) {
                System.err.println("biome save error: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        dirty = false;
    }

    public static int getBiomeColor(int biomeID) {
        Integer color = IDtoColor.get(biomeID);
        if (color == null) {
            Biome biome = (Biome)Registry.field_212624_m.func_148745_a(biomeID);
            if (biome != null) {
                String name = Registry.field_212624_m.func_177774_c((Object)biome).toString();
                color = nameToColor.get(name);
                if (color == null && (color = nameToColor.get(biome.func_205403_k().func_150261_e())) != null) {
                    nameToColor.remove(biome.func_205403_k().func_150261_e());
                    nameToColor.put(name, color);
                    dirty = true;
                }
                if (color == null) {
                    int r = generator.nextInt(255);
                    int g = generator.nextInt(255);
                    int b = generator.nextInt(255);
                    color = r << 16 | g << 8 | b;
                    nameToColor.put(name, color);
                    dirty = true;
                }
            } else {
                System.out.println("non biome");
                color = 0;
            }
            IDtoColor.put(biomeID, color);
        }
        return color;
    }

    static {
        biomeToInt.put(Biomes.field_180279_ad, 0);
        Arrays.fill(biomes, Biomes.field_180279_ad);
        generator = new Random();
        IDtoColor = new HashMap(256);
        nameToColor = new TreeMap();
        dirty = false;
    }
}

