/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;

public class BlockRepository {
    public static Block air;
    public static Block voidAir;
    public static int airID;
    public static int voidAirID;
    public static MovingPistonBlock pistonTechBlock;
    public static Block water;
    public static Block lava;
    public static Block ice;
    public static Block grassBlock;
    public static Block oakLeaves;
    public static Block spruceLeaves;
    public static Block birchLeaves;
    public static Block jungleLeaves;
    public static Block acaciaLeaves;
    public static Block darkOakLeaves;
    public static Block grass;
    public static Block fern;
    public static Block tallGrass;
    public static Block largeFern;
    public static Block reeds;
    public static Block vine;
    public static Block lilypad;
    public static Block tallFlower;
    public static Block cobweb;
    public static Block stickyPiston;
    public static Block piston;
    public static Block redstone;
    public static Block sign;
    public static Block ladder;
    public static Block wallSign;
    public static Block oakDoor;
    public static Block ironDoor;
    public static Block spruceDoor;
    public static Block birchDoor;
    public static Block jungleDoor;
    public static Block darkOakDoor;
    public static Block acaciaDoor;
    public static Block barrier;
    public static Block chorusPlant;
    public static Block chorusFlower;
    public static IFluidState dry;
    public static HashSet<Block> biomeBlocks;
    public static Block[] biomeBlocksArray;
    public static HashSet<Block> shapedBlocks;
    public static Block[] doorsArray;
    public static Block[] shapedBlocksArray;
    private static Reference2IntOpenHashMap<BlockState> stateToInt;
    private static ReferenceArrayList<BlockState> blockStates;
    private static int count;
    private static ReadWriteLock incrementLock;

    public static void getBlocks() {
        air = Blocks.field_150350_a;
        airID = BlockRepository.getStateId(air.func_176223_P());
        voidAir = Blocks.field_201940_ji;
        voidAirID = BlockRepository.getStateId(voidAir.func_176223_P());
        pistonTechBlock = (MovingPistonBlock)Blocks.field_196603_bb;
        water = Blocks.field_150355_j;
        lava = Blocks.field_150353_l;
        ice = Blocks.field_150432_aD;
        grassBlock = Blocks.field_196658_i;
        oakLeaves = Blocks.field_196642_W;
        spruceLeaves = Blocks.field_196645_X;
        birchLeaves = Blocks.field_196647_Y;
        jungleLeaves = Blocks.field_196648_Z;
        acaciaLeaves = Blocks.field_196572_aa;
        darkOakLeaves = Blocks.field_196574_ab;
        grass = Blocks.field_150349_c;
        fern = Blocks.field_196554_aH;
        tallGrass = Blocks.field_196804_gh;
        largeFern = Blocks.field_196805_gi;
        reeds = Blocks.field_196608_cF;
        vine = Blocks.field_150395_bd;
        lilypad = Blocks.field_196651_dG;
        cobweb = Blocks.field_196553_aF;
        stickyPiston = Blocks.field_150320_F;
        piston = Blocks.field_150331_J;
        redstone = Blocks.field_150488_af;
        sign = Blocks.field_222384_bX;
        wallSign = Blocks.field_222392_ch;
        ladder = Blocks.field_150468_ap;
        oakDoor = Blocks.field_180413_ao;
        ironDoor = Blocks.field_150454_av;
        spruceDoor = Blocks.field_180414_ap;
        birchDoor = Blocks.field_180412_aq;
        jungleDoor = Blocks.field_180411_ar;
        darkOakDoor = Blocks.field_180409_at;
        acaciaDoor = Blocks.field_180410_as;
        barrier = Blocks.field_180401_cv;
        chorusPlant = Blocks.field_185765_cR;
        chorusFlower = Blocks.field_185766_cS;
        biomeBlocksArray = new Block[]{grassBlock, oakLeaves, spruceLeaves, birchLeaves, jungleLeaves, acaciaLeaves, darkOakLeaves, grass, fern, tallGrass, largeFern, reeds, vine, lilypad, tallFlower, water};
        biomeBlocks = new HashSet<Block>(Arrays.asList(biomeBlocksArray));
        doorsArray = new Block[]{oakDoor, ironDoor, spruceDoor, birchDoor, jungleDoor, darkOakDoor, acaciaDoor};
        shapedBlocksArray = new Block[]{sign, ladder, wallSign, vine};
        shapedBlocks = new HashSet<Block>(Arrays.asList(shapedBlocksArray));
        shapedBlocks.addAll(Arrays.asList(doorsArray));
    }

    public static int getStateId(BlockState blockState) {
        incrementLock.readLock().lock();
        int id = stateToInt.getInt((Object)blockState);
        incrementLock.readLock().unlock();
        if (id == -1) {
            incrementLock.writeLock().lock();
            id = stateToInt.getInt((Object)blockState);
            if (id == -1) {
                id = count++;
                blockStates.add((Object)blockState);
                stateToInt.put((Object)blockState, id);
            }
            incrementLock.writeLock().unlock();
        }
        return id;
    }

    public static BlockState getStateById(int id) {
        return (BlockState)blockStates.get(id);
    }

    static {
        airID = 0;
        voidAirID = 0;
        dry = Fluids.field_204541_a.func_207188_f();
        biomeBlocksArray = new Block[]{grassBlock, oakLeaves, spruceLeaves, birchLeaves, jungleLeaves, acaciaLeaves, darkOakLeaves, grass, fern, tallGrass, largeFern, reeds, vine, lilypad, tallFlower, water};
        doorsArray = new Block[]{oakDoor, ironDoor, spruceDoor, birchDoor, jungleDoor, darkOakDoor, acaciaDoor};
        shapedBlocksArray = new Block[]{sign, oakDoor, ladder, wallSign, ironDoor, vine};
        stateToInt = new Reference2IntOpenHashMap(1024);
        blockStates = new ReferenceArrayList(16384);
        count = 1;
        incrementLock = new ReentrantReadWriteLock();
        stateToInt.defaultReturnValue(-1);
        BlockState airBlockState = Blocks.field_150350_a.func_176223_P();
        stateToInt.put((Object)airBlockState, 0);
        blockStates.add((Object)airBlockState);
    }
}

