/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class GLUtils {
    private static Tessellator tessellator = Tessellator.func_178181_a();
    private static BufferBuilder vertexBuffer = tessellator.func_178180_c();
    public static TextureManager textureManager;
    public static int fboID;
    public static int rboID;
    private static final boolean fboEnabledArb;
    private static final boolean fboEnabledBase;
    public static int fboTextureID;
    private static int previousFBOID;
    private static int previousRBOID;
    public static boolean hasAlphaBits;
    public static int fboSize;
    public static int fboRad;
    private static final IntBuffer dataBuffer;

    public static void setupFrameBuffer() {
        if (fboEnabledBase) {
            GLUtils.setupFrameBufferBASE();
        } else if (fboEnabledArb) {
            GLUtils.setupFrameBufferARB();
        } else {
            GLUtils.setupFrameBufferEXT();
        }
    }

    private static void setupFrameBufferBASE() {
        previousFBOID = GL11.glGetInteger((int)36006);
        fboID = GL30.glGenFramebuffers();
        fboTextureID = GL11.glGenTextures();
        int width = fboSize;
        int height = fboSize;
        GL30.glBindFramebuffer((int)36160, (int)fboID);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(4 * width * height));
        GLShim.glBindTexture(3553, fboTextureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5120, (ByteBuffer)byteBuffer);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)fboTextureID, (int)0);
        rboID = GL30.glGenRenderbuffers();
        GL30.glBindRenderbuffer((int)36161, (int)rboID);
        GL30.glRenderbufferStorage((int)36161, (int)33190, (int)width, (int)height);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)rboID);
        GL30.glBindRenderbuffer((int)36161, (int)0);
        GL30.glBindFramebuffer((int)36160, (int)previousFBOID);
    }

    private static void setupFrameBufferARB() {
        previousFBOID = GL11.glGetInteger((int)36006);
        fboID = ARBFramebufferObject.glGenFramebuffers();
        fboTextureID = GL11.glGenTextures();
        int width = fboSize;
        int height = fboSize;
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)fboID);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(4 * width * height));
        GLShim.glBindTexture(3553, fboTextureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5120, (ByteBuffer)byteBuffer);
        ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)fboTextureID, (int)0);
        rboID = ARBFramebufferObject.glGenRenderbuffers();
        ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)rboID);
        ARBFramebufferObject.glRenderbufferStorage((int)36161, (int)33190, (int)width, (int)height);
        ARBFramebufferObject.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)rboID);
        ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)0);
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)previousFBOID);
    }

    private static void setupFrameBufferEXT() {
        previousFBOID = GL11.glGetInteger((int)36006);
        fboID = EXTFramebufferObject.glGenFramebuffersEXT();
        fboTextureID = GL11.glGenTextures();
        int width = fboSize;
        int height = fboSize;
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)fboID);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(4 * width * height));
        GLShim.glBindTexture(3553, fboTextureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5120, (ByteBuffer)byteBuffer);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)fboTextureID, (int)0);
        rboID = EXTFramebufferObject.glGenRenderbuffersEXT();
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)rboID);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)33190, (int)width, (int)height);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)rboID);
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)0);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)previousFBOID);
    }

    public static void bindFrameBuffer() {
        if (fboEnabledBase) {
            GLUtils.bindFrameBufferBASE();
        } else if (fboEnabledArb) {
            GLUtils.bindFrameBufferARB();
        } else {
            GLUtils.bindFrameBufferEXT();
        }
    }

    private static void bindFrameBufferBASE() {
        previousFBOID = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)36160, (int)fboID);
    }

    private static void bindFrameBufferARB() {
        previousFBOID = GL11.glGetInteger((int)36006);
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)fboID);
    }

    private static void bindFrameBufferEXT() {
        previousFBOID = GL11.glGetInteger((int)36006);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)fboID);
    }

    public static void unbindFrameBuffer() {
        if (fboEnabledBase) {
            GLUtils.unbindFrameBufferBASE();
        } else if (fboEnabledArb) {
            GLUtils.unbindFrameBufferARB();
        } else {
            GLUtils.unbindFrameBufferEXT();
        }
    }

    private static void unbindFrameBufferBASE() {
        GL30.glBindFramebuffer((int)36160, (int)previousFBOID);
    }

    private static void unbindFrameBufferARB() {
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)previousFBOID);
    }

    private static void unbindFrameBufferEXT() {
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)previousFBOID);
    }

    public static void setMap(int x, int y) {
        GLUtils.setMap(x, y, 128);
    }

    public static void setMapWithScale(int x, int y, float scale) {
        GLUtils.setMap(x, y, (int)(128.0f * scale));
    }

    public static void setMap(int x, float y, int imageSize) {
        float scale = (float)imageSize / 4.0f;
        GLUtils.ldrawthree((float)x - scale, y + scale, 1.0, 0.0f, 1.0f);
        GLUtils.ldrawthree((float)x + scale, y + scale, 1.0, 1.0f, 1.0f);
        GLUtils.ldrawthree((float)x + scale, y - scale, 1.0, 1.0f, 0.0f);
        GLUtils.ldrawthree((float)x - scale, y - scale, 1.0, 0.0f, 0.0f);
    }

    public static void setMap(Sprite icon, int x, float y, float imageSize) {
        float scale = imageSize / 4.0f;
        GLUtils.ldrawthree((float)x - scale, y + scale, 1.0, icon.getMinU(), icon.getMaxV());
        GLUtils.ldrawthree((float)x + scale, y + scale, 1.0, icon.getMaxU(), icon.getMaxV());
        GLUtils.ldrawthree((float)x + scale, y - scale, 1.0, icon.getMaxU(), icon.getMinV());
        GLUtils.ldrawthree((float)x - scale, y - scale, 1.0, icon.getMinU(), icon.getMinV());
    }

    public static int tex(BufferedImage paramImg) {
        int glid = GLShim.glGenTextures();
        int width = paramImg.getWidth();
        int height = paramImg.getHeight();
        int[] imageData = new int[width * height];
        paramImg.getRGB(0, 0, width, height, imageData, 0, width);
        GLShim.glBindTexture(3553, glid);
        dataBuffer.clear();
        dataBuffer.put(imageData, 0, width * height);
        dataBuffer.position(0).limit(width * height);
        GlStateManager.func_227748_o_((int)3314, (int)0);
        GlStateManager.func_227748_o_((int)3316, (int)0);
        GlStateManager.func_227748_o_((int)3315, (int)0);
        GLShim.glTexImage2D(3553, 0, 6408, width, height, 0, 32993, 33639, dataBuffer);
        return glid;
    }

    public static void img(String paramStr) {
        textureManager.func_110577_a(new ResourceLocation(paramStr));
    }

    public static void img(ResourceLocation paramResourceLocation) {
        textureManager.func_110577_a(paramResourceLocation);
    }

    public static void disp(int paramInt) {
        GlStateManager.func_227760_t_((int)paramInt);
    }

    public static void register(ResourceLocation resourceLocation, Texture image) {
        textureManager.func_229263_a_(resourceLocation, image);
    }

    public static NativeImage nativeImageFromBufferedImage(BufferedImage base) {
        int glid = GLUtils.tex(base);
        NativeImage nativeImage = new NativeImage(base.getWidth(), base.getHeight(), false);
        RenderSystem.bindTexture((int)glid);
        nativeImage.func_195717_a(0, false);
        return nativeImage;
    }

    public static void drawPre() {
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
    }

    public static void drawPre(VertexFormat vertexFormat) {
        vertexBuffer.func_181668_a(7, vertexFormat);
    }

    public static void drawPost() {
        tessellator.func_78381_a();
    }

    public static void glah(int g) {
        GLShim.glDeleteTextures(g);
    }

    public static void ldrawone(int x, int y, double z, float u, float v) {
        vertexBuffer.func_225582_a_((double)x, (double)y, z).func_225583_a_(u, v).func_181675_d();
    }

    public static void ldrawtwo(double x, double y, double z) {
        vertexBuffer.func_225582_a_(x, y, z).func_181675_d();
    }

    public static void ldrawthree(double x, double y, double z, float u, float v) {
        vertexBuffer.func_225582_a_(x, y, z).func_225583_a_(u, v).func_181675_d();
    }

    static {
        fboID = 0;
        rboID = 0;
        fboEnabledArb = GL.getCapabilities().GL_ARB_framebuffer_object;
        fboEnabledBase = GL.getCapabilities().OpenGL30;
        fboTextureID = 0;
        previousFBOID = 0;
        previousRBOID = 0;
        hasAlphaBits = GL11.glGetInteger((int)3413) > 0;
        fboSize = 512;
        fboRad = 256;
        dataBuffer = GLAllocation.func_74524_c((int)0x1000000).asIntBuffer();
    }
}

