/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.function.Supplier;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class RemoveWaystoneMessage {
    private final IWaystone waystone;

    public RemoveWaystoneMessage(IWaystone waystone) {
        this.waystone = waystone;
    }

    public static void encode(RemoveWaystoneMessage message, PacketBuffer buf) {
        buf.func_179252_a(message.waystone.getWaystoneUid());
    }

    public static RemoveWaystoneMessage decode(PacketBuffer buf) {
        WaystoneProxy waystone = new WaystoneProxy(buf.func_179253_g());
        return new RemoveWaystoneMessage(waystone);
    }

    public static void handle(RemoveWaystoneMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            PlayerWaystoneManager.deactivateWaystone((PlayerEntity)player, message.waystone);
        });
        context.setPacketHandled(true);
    }
}

