/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.config.WaystoneConfig;
import net.blay09.mods.waystones.config.WorldGenStyle;
import net.blay09.mods.waystones.worldgen.WaystoneFeature;
import net.blay09.mods.waystones.worldgen.WaystonePlacement;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModWorldGen {
    private static final ResourceLocation villageWaystoneStructure = new ResourceLocation("waystones", "village/common/waystone");
    private static final ResourceLocation desertVillageWaystoneStructure = new ResourceLocation("waystones", "village/desert/waystone");
    private static final ResourceLocation emptyStructure = new ResourceLocation("empty");
    private static WaystoneFeature waystoneFeature;
    private static WaystoneFeature mossyWaystoneFeature;
    private static WaystoneFeature sandyWaystoneFeature;
    private static WaystonePlacement waystonePlacement;

    public static void registerFeatures(IForgeRegistry<Feature<?>> registry) {
        Feature[] featureArray = new Feature[3];
        waystoneFeature = (WaystoneFeature)new WaystoneFeature(NoFeatureConfig::func_214639_a, ModBlocks.waystone.func_176223_P()).setRegistryName("waystone");
        featureArray[0] = waystoneFeature;
        mossyWaystoneFeature = (WaystoneFeature)new WaystoneFeature(NoFeatureConfig::func_214639_a, ModBlocks.mossyWaystone.func_176223_P()).setRegistryName("mossy_waystone");
        featureArray[1] = mossyWaystoneFeature;
        sandyWaystoneFeature = (WaystoneFeature)new WaystoneFeature(NoFeatureConfig::func_214639_a, ModBlocks.sandyWaystone.func_176223_P()).setRegistryName("sandy_waystone");
        featureArray[2] = sandyWaystoneFeature;
        registry.registerAll((IForgeRegistryEntry[])featureArray);
    }

    public static void registerPlacements(IForgeRegistry<Placement<?>> registry) {
        Placement[] placementArray = new Placement[1];
        waystonePlacement = (WaystonePlacement)new WaystonePlacement(NoPlacementConfig::func_214735_a).setRegistryName("waystone");
        placementArray[0] = waystonePlacement;
        registry.registerAll((IForgeRegistryEntry[])placementArray);
    }

    public static void setupRandomWorldGen() {
        if ((Integer)WaystoneConfig.COMMON.worldGenFrequency.get() > 0) {
            ForgeRegistries.BIOMES.forEach(biome -> {
                WaystoneFeature feature = ModWorldGen.getWaystoneFeature(biome);
                ConfiguredFeature configuredFeature = feature.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(waystonePlacement.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_202468_e));
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, configuredFeature);
            });
        }
    }

    private static WaystoneFeature getWaystoneFeature(Biome biome) {
        WorldGenStyle worldGenStyle = (WorldGenStyle)((Object)WaystoneConfig.COMMON.worldGenStyle.get());
        switch (worldGenStyle) {
            case MOSSY: {
                return mossyWaystoneFeature;
            }
            case SANDY: {
                return sandyWaystoneFeature;
            }
            case BIOME: {
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
                    return sandyWaystoneFeature;
                }
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET)) {
                    return mossyWaystoneFeature;
                }
                return waystoneFeature;
            }
        }
        return waystoneFeature;
    }

    public static void setupVillageWorldGen() {
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(villageWaystoneStructure, emptyStructure, Collections.emptyList(), JigsawPattern.PlacementBehaviour.RIGID));
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(desertVillageWaystoneStructure, emptyStructure, Collections.emptyList(), JigsawPattern.PlacementBehaviour.RIGID));
        if (((Boolean)WaystoneConfig.COMMON.addVillageStructure.get()).booleanValue()) {
            PlainsVillagePools.func_214744_a();
            SnowyVillagePools.func_214746_a();
            SavannaVillagePools.func_214745_a();
            DesertVillagePools.func_222739_a();
            TaigaVillagePools.func_214806_a();
            ModWorldGen.addWaystoneStructureToVillageConfig("village/plains/houses", villageWaystoneStructure);
            ModWorldGen.addWaystoneStructureToVillageConfig("village/snowy/houses", villageWaystoneStructure);
            ModWorldGen.addWaystoneStructureToVillageConfig("village/savanna/houses", villageWaystoneStructure);
            ModWorldGen.addWaystoneStructureToVillageConfig("village/desert/houses", desertVillageWaystoneStructure);
            ModWorldGen.addWaystoneStructureToVillageConfig("village/taiga/houses", villageWaystoneStructure);
        }
    }

    private static void addWaystoneStructureToVillageConfig(String villagePiece, ResourceLocation waystoneStructure) {
        JigsawPattern houses = JigsawManager.field_214891_a.func_214933_a(new ResourceLocation(villagePiece));
        SingleJigsawPiece piece = new SingleJigsawPiece(waystoneStructure.toString(), Collections.emptyList(), JigsawPattern.PlacementBehaviour.RIGID);
        houses.field_214952_d = ImmutableList.builder().addAll((Iterable)houses.field_214952_d).add((Object)Pair.of((Object)piece, (Object)1)).build();
        houses.field_214953_e.add(piece);
    }
}

