/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.Dungeon;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.util.ResourceReloadHandler;
import xiroc.dungeoncrawl.util.tools.Tools;

@Mod(value="dungeoncrawl")
public class DungeonCrawl {
    public static final String MOD_ID = "dungeoncrawl";
    public static final String NAME = "Dungeon Crawl";
    public static final String VERSION = "2.3.0-a";
    public static final Logger LOGGER = LogManager.getLogger((String)"Dungeon Crawl");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final JsonParser JSON_PARSER = new JsonParser();

    public DungeonCrawl() {
        LOGGER.info("Here we go! Launching Dungeon Crawl {}...", (Object)VERSION);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ForgeRegistries.FEATURES.register(Dungeon.DUNGEON.setRegistryName(new ResourceLocation("dungeoncrawl:dungeon".toLowerCase())));
        Treasure.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common Setup");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.CONFIG);
        Config.load(FMLPaths.CONFIGDIR.get().resolve("dungeon_crawl.toml"));
        if ((Integer)Config.SPACING.get() <= (Integer)Config.SEPARATION.get()) {
            throw new IllegalArgumentException("Invalid spacing/separation setting in the config.");
        }
        Dungeon.spacing = (Integer)Config.SPACING.get();
        Dungeon.separation = (Integer)Config.SEPARATION.get();
        StructurePieceTypes.register();
        if (((Boolean)Config.ENABLE_TOOLS.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)new Tools());
        }
        LOGGER.info("Adding features and structures");
        LOGGER.info("Dungeons will generate in the following biomes:");
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (!Dungeon.OVERWORLD_CATEGORIES.contains(biome.func_201856_r())) continue;
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new ConfiguredFeature((Feature)Dungeon.DUNGEON, (IFeatureConfig)NoFeatureConfig.field_202429_e));
            if (biome.getRegistryName() != null && !Dungeon.ALLOWED_CATEGORIES.contains(biome.func_201856_r())) continue;
            LOGGER.info((Object)biome.getRegistryName());
            biome.func_226711_a_(Dungeon.CONFIGURED_DUNGEON);
        }
    }

    @SubscribeEvent
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new ResourceReloadHandler());
    }

    public static ResourceLocation locate(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation key(ResourceLocation resourceLocation, String baseDirectory, String fileEnding) {
        String path = resourceLocation.func_110623_a();
        return new ResourceLocation(resourceLocation.func_110624_b(), path.substring(baseDirectory.length() + 1, path.length() - fileEnding.length()));
    }
}

