/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;

public class Dungeon
extends Structure<NoFeatureConfig> {
    public static final Set<Biome.Category> ALLOWED_CATEGORIES = ImmutableSet.builder().add((Object)Biome.Category.BEACH).add((Object)Biome.Category.DESERT).add((Object)Biome.Category.EXTREME_HILLS).add((Object)Biome.Category.FOREST).add((Object)Biome.Category.ICY).add((Object)Biome.Category.JUNGLE).add((Object)Biome.Category.MESA).add((Object)Biome.Category.PLAINS).add((Object)Biome.Category.RIVER).add((Object)Biome.Category.SAVANNA).add((Object)Biome.Category.SWAMP).add((Object)Biome.Category.TAIGA).add((Object)Biome.Category.RIVER).build();
    public static final Set<Biome.Category> OVERWORLD_CATEGORIES = ImmutableSet.builder().addAll(ALLOWED_CATEGORIES).add((Object)Biome.Category.MUSHROOM).add((Object)Biome.Category.OCEAN).build();
    public static final String NAME = "dungeoncrawl:dungeon";
    public static final Dungeon DUNGEON = new Dungeon(NoFeatureConfig::func_214639_a);
    public static final ConfiguredFeature<NoFeatureConfig, Structure<NoFeatureConfig>> CONFIGURED_DUNGEON = new ConfiguredFeature((Feature)DUNGEON, (IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final int SIZE = 15;
    public static int spacing;
    public static int separation;

    public Dungeon(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51427_1_) {
        super(p_i51427_1_);
    }

    public ChunkPos getStartPositionForPosition(ChunkGenerator<?> chunkGenerator, Random random, int x, int z) {
        int i = spacing;
        int j = separation;
        int i1 = x < 0 ? x - i + 1 : x;
        int j1 = z < 0 ? z - i + 1 : z;
        int k1 = i1 / i;
        int l1 = j1 / i;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, 10387319);
        k1 *= i;
        l1 *= i;
        return new ChunkPos(k1 += (random.nextInt(i - j) + random.nextInt(i - j)) / 2, l1 += (random.nextInt(i - j) + random.nextInt(i - j)) / 2);
    }

    public boolean func_225558_a_(BiomeManager p_225558_1_, ChunkGenerator<?> chunkGen, Random rand, int chunkX, int chunkZ, Biome p_225558_6_) {
        ChunkPos chunkpos = this.getStartPositionForPosition(chunkGen, rand, chunkX, chunkZ);
        if (chunkX == chunkpos.field_77276_a && chunkZ == chunkpos.field_77275_b && p_225558_6_.func_201858_a((Structure)DUNGEON)) {
            for (Biome biome : chunkGen.func_202090_b().func_225530_a_((chunkX << 4) + 9, chunkGen.func_222530_f(), (chunkZ << 4) + 9, 64)) {
                if (biome.func_201858_a((Structure)this)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return NAME;
    }

    public int func_202367_b() {
        return 0;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> p_i51341_1_, int chunkX, int chunkZ, MutableBoundingBox boundsIn, int referenceIn, long seed) {
            super(p_i51341_1_, chunkX, chunkZ, boundsIn, referenceIn, seed);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            if (DungeonBuilder.isWorldEligible(generator)) {
                ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
                DungeonBuilder builder = new DungeonBuilder(generator, chunkpos, (Random)this.field_214631_d);
                this.field_75075_a.addAll(builder.build());
                this.func_202500_a();
                DungeonCrawl.LOGGER.debug("Created the dungeon layout for [{}, {}] with a total of {} pieces.", (Object)chunkX, (Object)chunkZ, (Object)this.field_75075_a.size());
            } else {
                DungeonCrawl.LOGGER.warn("The current world seems to have biomes of overworld-like categories, but is not eligible for dungeon generation.");
            }
        }

        public void func_225565_a_(IWorld worldIn, ChunkGenerator<?> chunkGen, Random rand, MutableBoundingBox structurebb, ChunkPos pos) {
            if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
                DungeonCrawl.LOGGER.debug("Starting dungeon generation in chunk [{},{}]", (Object)pos.field_77276_a, (Object)pos.field_77275_b);
            }
            super.func_225565_a_(worldIn, chunkGen, rand, structurebb, pos);
            if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
                DungeonCrawl.LOGGER.debug("Finished dungeon generation in chunk [{},{}]", (Object)pos.field_77276_a, (Object)pos.field_77275_b);
            }
        }
    }
}

