/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.block;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.SmokerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.storage.loot.RandomValueRange;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.PlacementContext;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;

public class Furnace
implements IBlockPlacementHandler {
    private static final Item[] FOOD = new Item[]{Items.field_151083_be, Items.field_151077_bg, Items.field_179557_bn, Items.field_196102_ba, Items.field_151157_am, Items.field_179559_bp, Items.field_196104_bb, Items.field_151168_bH};
    public static final RandomValueRange COAL_AMOUNT = new RandomValueRange(4.0f, 16.0f);

    @Override
    public void place(IWorld world, BlockState state, BlockPos pos, Random rand, PlacementContext context, Theme theme, Theme.SecondaryTheme secondaryTheme, int lootLevel) {
        world.func_180501_a(pos, state, 2);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof FurnaceTileEntity) {
            FurnaceTileEntity furnace = (FurnaceTileEntity)tile;
            furnace.func_70299_a(1, new ItemStack((IItemProvider)Items.field_151044_h, COAL_AMOUNT.func_186511_a(rand)));
        } else {
            DungeonCrawl.LOGGER.warn("Failed to fetch a furnace entity at {}", (Object)pos.toString());
        }
    }

    public static class Smoker
    implements IBlockPlacementHandler {
        @Override
        public void place(IWorld world, BlockState state, BlockPos pos, Random rand, PlacementContext context, Theme theme, Theme.SecondaryTheme secondaryTheme, int lootLevel) {
            world.func_180501_a(pos, state, 2);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof SmokerTileEntity) {
                SmokerTileEntity smoker = (SmokerTileEntity)tile;
                smoker.func_70299_a(1, new ItemStack((IItemProvider)Items.field_196155_l, COAL_AMOUNT.func_186511_a(rand)));
                smoker.func_70299_a(2, new ItemStack((IItemProvider)FOOD[rand.nextInt(FOOD.length)], 1 + rand.nextInt(16)));
            } else {
                DungeonCrawl.LOGGER.warn("Failed to fetch a smoker entity at {}", (Object)pos.toString());
            }
        }
    }
}

