/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.generator.layer;

import com.google.gson.JsonObject;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.RandomValueRange;
import xiroc.dungeoncrawl.exception.DatapackLoadException;

public class LayerGeneratorSettings {
    public final int minRooms;
    public final int maxRooms;
    public final RandomValueRange rooms;
    public final int minNodes;
    public final int maxNodes;
    public final RandomValueRange nodes;
    public final int minDistance;
    public final int maxDistance;
    public final int maxDepth;
    public final int minNodeDepth;
    public final int maxNodeDepth;
    public final int minRoomDepth;
    public final int maxRoomDepth;
    public final int minStairsDepth;

    public LayerGeneratorSettings(int minRooms, int maxRooms, int minNodes, int maxNodes, int minRoomDepth, int maxRoomDepth, int minNodeDepth, int maxNodeDepth, int minStairsDepth, int maxDepth, int minDistance, int maxDistance) {
        this.minRooms = minRooms;
        this.maxRooms = maxRooms;
        this.rooms = new RandomValueRange((float)minRooms, (float)maxRooms);
        this.minNodes = minNodes;
        this.maxNodes = maxNodes;
        this.nodes = new RandomValueRange((float)minNodes, (float)maxNodes);
        this.minRoomDepth = minRoomDepth;
        this.maxRoomDepth = maxRoomDepth;
        this.minNodeDepth = minNodeDepth;
        this.maxNodeDepth = maxNodeDepth;
        this.minStairsDepth = minStairsDepth;
        this.maxDepth = maxDepth;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
    }

    public static LayerGeneratorSettings fromJson(JsonObject settings, ResourceLocation resource) {
        return new LayerGeneratorSettings(LayerGeneratorSettings.getValue("min_rooms", settings, resource), LayerGeneratorSettings.getValue("max_rooms", settings, resource), LayerGeneratorSettings.getValue("min_nodes", settings, resource), LayerGeneratorSettings.getValue("max_nodes", settings, resource), LayerGeneratorSettings.getValue("min_room_depth", settings, resource), LayerGeneratorSettings.getValue("max_room_depth", settings, resource), LayerGeneratorSettings.getValue("min_node_depth", settings, resource), LayerGeneratorSettings.getValue("max_node_depth", settings, resource), LayerGeneratorSettings.getValue("min_stairs_depth", settings, resource), LayerGeneratorSettings.getValue("max_depth", settings, resource), LayerGeneratorSettings.getValue("min_distance", settings, resource), LayerGeneratorSettings.getValue("max_distance", settings, resource));
    }

    private static int getValue(String name, JsonObject object, ResourceLocation resource) {
        if (object.has(name)) {
            return object.getAsJsonPrimitive(name).getAsInt();
        }
        throw new DatapackLoadException("Missing layer settings field " + name + " in " + resource);
    }
}

