/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import org.jline.utils.InputStreamReader;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.ModelHandler;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class DungeonModels {
    public static final Hashtable<ResourceLocation, DungeonModel> KEY_TO_MODEL = new Hashtable();
    public static final Hashtable<Integer, DungeonModel> ID_TO_MODEL = new Hashtable();
    public static final Hashtable<Integer, WeightedRandom<DungeonModel>> WEIGHTED_MODELS = new Hashtable();
    public static final Vec3i NO_OFFSET = new Vec3i(0, 0, 0);
    public static final ResourceLocation SECRET_ROOM_ENTRANCE = DungeonCrawl.locate("default/corridor/secret_room_entrance");
    public static final ResourceLocation STARTER_ROOM = DungeonCrawl.locate("default/room/starter_room");
    public static final ResourceLocation ROGUELIKE_TOWER = DungeonCrawl.locate("default/entrance/roguelike/rogue_tower");
    public static final ResourceLocation STAIRCASE = DungeonCrawl.locate("default/staircase");
    public static final ResourceLocation BOTTOM_STAIRS = DungeonCrawl.locate("default/stairs_bottom");
    public static final ResourceLocation BOTTOM_STAIRS_2 = DungeonCrawl.locate("default/stairs_bottom_2");
    public static final ResourceLocation TOP_STAIRS = DungeonCrawl.locate("default/stairs_top");
    public static final ResourceLocation LOOT_ROOM = DungeonCrawl.locate("default/loot_room");
    public static final ResourceLocation SECRET_ROOM = DungeonCrawl.locate("default/room/secret_room");
    private static ImmutableSet<ResourceLocation> KEYS;
    private static ImmutableSet.Builder<ResourceLocation> keySetBuilder;
    private static final String DIRECTORY = "models";

    public static synchronized void load(IResourceManager resourceManager) {
        ID_TO_MODEL.clear();
        KEY_TO_MODEL.clear();
        WEIGHTED_MODELS.clear();
        keySetBuilder = new ImmutableSet.Builder();
        resourceManager.func_199003_a(DIRECTORY, s -> s.endsWith(".nbt")).forEach(resource -> DungeonModels.load(resource, resourceManager));
        KEYS = keySetBuilder.build();
    }

    private static void load(ResourceLocation resource, IResourceManager resourceManager) {
        DungeonModel model = DungeonModels.loadModel(resource, resourceManager);
        ResourceLocation metadata = new ResourceLocation(resource.func_110624_b(), resource.func_110623_a().substring(0, resource.func_110623_a().indexOf(".nbt")) + ".json");
        if (resourceManager.func_219533_b(metadata)) {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)metadata);
            try {
                model.loadMetadata(DungeonCrawl.JSON_PARSER.parse((Reader)new InputStreamReader(resourceManager.func_199002_a(metadata).func_199027_b())).getAsJsonObject(), metadata);
            }
            catch (Exception e) {
                DungeonCrawl.LOGGER.error("Failed to load metadata for {}", (Object)resource.func_110623_a());
                e.printStackTrace();
            }
        }
    }

    private static DungeonModel loadModel(ResourceLocation resource, IResourceManager resourceManager) {
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)resource);
        try {
            CompoundNBT nbt = CompressedStreamTools.func_74796_a((InputStream)resourceManager.func_199002_a(resource).func_199027_b());
            ResourceLocation key = DungeonCrawl.key(resource, DIRECTORY, ".nbt");
            DungeonModel model = ModelHandler.loadModelFromNBT(nbt, resource, key);
            KEY_TO_MODEL.put(key, model);
            keySetBuilder.add((Object)key);
            if (model.hasId()) {
                ID_TO_MODEL.put(model.getId(), model);
            }
            return model;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DatapackLoadException("Failed to load " + resource);
        }
    }

    public static ImmutableSet<ResourceLocation> getKeys() {
        return KEYS;
    }
}

