/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.model.ModelBlockDefinition;
import xiroc.dungeoncrawl.dungeon.model.ModelLoader;

public class ModelHandler {
    public static final byte LATEST_MODEL_FORMAT = 1;

    public static void readAndSaveModelToFile(String name, ModelBlockDefinition definition, World world, BlockPos pos, int width, int height, int length) {
        DungeonCrawl.LOGGER.info("Reading and saving {} to disk. Size: {}, {}, {}", (Object)name, (Object)width, (Object)height, (Object)length);
        ArrayList<DungeonModelBlock> blocks = new ArrayList<DungeonModelBlock>();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    BlockPos position = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    BlockState state = world.func_180495_p(position);
                    Block block = state.func_177230_c();
                    if (block == Blocks.field_180401_cv) continue;
                    blocks.add(DungeonModelBlock.fromBlockState(state, DungeonModelBlockType.get(block, definition), new Vec3i(x, y, z)));
                }
            }
        }
        ModelHandler.writeToFile(ModelHandler.toNbt(blocks, width, height, length), ((ServerWorld)world).func_73046_m().func_71238_n().getAbsolutePath() + "/models/" + name + ".nbt");
        DungeonCrawl.LOGGER.info("Done.");
    }

    public static void writeToFile(CompoundNBT nbt, String path) {
        try {
            DungeonCrawl.LOGGER.info("Writing a model to disk at {}. ", (Object)path);
            File file = new File(path);
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            Files.deleteIfExists(file.toPath());
            Files.createFile(file.toPath(), new FileAttribute[0]);
            CompressedStreamTools.func_74799_a((CompoundNBT)nbt, (OutputStream)new FileOutputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static CompoundNBT toNbt(DungeonModel model) {
        return ModelHandler.toNbt(model.blocks, model.width, model.height, model.length);
    }

    public static CompoundNBT toNbt(List<DungeonModelBlock> blocks, int width, int height, int length) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74774_a("format", (byte)1);
        nbt.func_74774_a("width", (byte)width);
        nbt.func_74774_a("height", (byte)height);
        nbt.func_74774_a("length", (byte)length);
        ListNBT _blocks = new ListNBT();
        blocks.forEach(block -> _blocks.add((Object)block.toNBT()));
        nbt.func_218657_a("blocks", (INBT)_blocks);
        return nbt;
    }

    public static DungeonModel loadModelFromNBT(CompoundNBT nbt, ResourceLocation file, ResourceLocation key) {
        int format = nbt.func_74762_e("format");
        if (format == 1) {
            return ModelLoader.VERSION_1.load(nbt, file, key);
        }
        return ModelLoader.LEGACY.load(nbt, file, key);
    }

    public static DungeonModel getModelFromJigsawNBT(CompoundNBT nbt) {
        return null;
    }
}

