/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.util.IRandom;

public class WeightedRandomPotionEffect
implements IRandom<WeightedEntry> {
    public static final WeightedRandomPotionEffect EMPTY = new WeightedRandomPotionEffect(new Builder.Entry[0]);
    private final WeightedEntry[] entries;

    private WeightedRandomPotionEffect(Builder.Entry[] entries) {
        int weight = 0;
        for (Builder.Entry entry : entries) {
            weight += entry.weight;
        }
        this.entries = new WeightedEntry[entries.length];
        this.assign(entries, weight);
    }

    private void assign(Builder.Entry[] entries, int totalWeight) {
        float f = 0.0f;
        int i = 0;
        for (Builder.Entry entry : entries) {
            float weight = (float)entry.weight / (float)totalWeight;
            this.entries[i] = new WeightedEntry((Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(entry.effect)), entry.duration, entry.amplifier, Float.valueOf(weight + f));
            f += weight;
            ++i;
        }
    }

    @Override
    public WeightedEntry roll(Random rand) {
        float f = rand.nextFloat();
        for (WeightedEntry entry : this.entries) {
            if (!(entry.weight >= f)) continue;
            return entry;
        }
        return null;
    }

    public static WeightedRandomPotionEffect fromJson(JsonArray array) {
        if (array.size() == 0) {
            return EMPTY;
        }
        Builder builder = new Builder();
        array.forEach(element -> {
            JsonObject object = element.getAsJsonObject();
            int weight = object.has("weight") ? object.get("weight").getAsInt() : 1;
            int duration = object.get("duration").getAsInt();
            RandomValueRange level = object.has("amplifier") ? new RandomValueRange((float)object.getAsJsonObject("amplifier").get("min").getAsInt(), (float)object.getAsJsonObject("amplifier").get("max").getAsInt()) : new RandomValueRange(0.0f);
            builder.add(object.get("effect").getAsString(), duration, level, weight);
        });
        return builder.build();
    }

    public static class Builder {
        private final ArrayList<Entry> list = new ArrayList();

        public Builder add(String effect, int duration, RandomValueRange level, int weight) {
            this.list.add(new Entry(effect, duration, level, weight));
            return this;
        }

        public WeightedRandomPotionEffect build() {
            if (this.list.isEmpty()) {
                return EMPTY;
            }
            return new WeightedRandomPotionEffect(this.list.toArray(new Entry[0]));
        }

        private static class Entry {
            public final String effect;
            public final int duration;
            public final RandomValueRange amplifier;
            public final int weight;

            public Entry(String effect, int duration, RandomValueRange amplifier, Integer weight) {
                this.effect = effect;
                this.duration = duration;
                this.amplifier = amplifier;
                this.weight = weight;
            }
        }
    }

    public static class WeightedEntry {
        public final Effect effect;
        public final int duration;
        public final RandomValueRange amplifier;
        public final float weight;

        public WeightedEntry(Effect effect, int duration, RandomValueRange amplifier, Float weight) {
            this.effect = effect;
            this.duration = duration;
            this.amplifier = amplifier;
            this.weight = weight.floatValue();
        }
    }
}

