/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.PlacementContext;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public class DungeonStairs
extends DungeonPiece {
    private static final BlockState IRON_BARS = Blocks.field_150411_aY.func_176223_P();
    public int stairType;

    public DungeonStairs() {
        this((TemplateManager)null, DEFAULT_NBT);
    }

    public DungeonStairs(TemplateManager manager, CompoundNBT p_i51343_2_) {
        super(StructurePieceTypes.STAIRS, p_i51343_2_);
        this.stairType = p_i51343_2_.func_74762_e("stairType");
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, Random rand) {
        switch (this.stairType) {
            case 0: {
                this.model = this.stage > 0 ? DungeonModels.KEY_TO_MODEL.get(DungeonModels.BOTTOM_STAIRS_2) : DungeonModels.KEY_TO_MODEL.get(DungeonModels.BOTTOM_STAIRS);
                return;
            }
            case 1: {
                this.model = DungeonModels.KEY_TO_MODEL.get(DungeonModels.TOP_STAIRS);
            }
        }
    }

    public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> chunkGenerator, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
        if (this.model == null) {
            DungeonCrawl.LOGGER.warn("Missing model for {}", (Object)this);
            return true;
        }
        BlockPos pos = new BlockPos(this.x, this.y, this.z).func_177971_a(this.model.getOffset(this.field_186169_c));
        switch (this.stairType) {
            case 0: {
                this.build(this.model, worldIn, structureBoundingBoxIn, pos, this.theme, this.secondaryTheme, this.stage, this.context, false);
                this.ironBars(worldIn, structureBoundingBoxIn, this.model, this.context);
                this.placeFeatures(worldIn, this.context, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage);
                this.decorate(worldIn, pos, this.context, this.model.width, this.model.height, this.model.length, this.theme, structureBoundingBoxIn, this.field_74887_e, this.model);
                return true;
            }
            case 1: {
                this.build(this.model, worldIn, structureBoundingBoxIn, pos, this.theme, this.secondaryTheme, this.stage, this.context, false);
                this.entrances(worldIn, structureBoundingBoxIn, this.model);
                this.placeFeatures(worldIn, this.context, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage);
                this.decorate(worldIn, pos, this.context, this.model.width, this.model.height, this.model.length, this.theme, structureBoundingBoxIn, this.field_74887_e, this.model);
                return true;
            }
        }
        return true;
    }

    public void ironBars(IWorld world, MutableBoundingBox bounds, DungeonModel model, PlacementContext context) {
        int z0;
        int y0;
        int x0;
        int pathStartX = (model.width - 3) / 2;
        int pathStartZ = (model.length - 3) / 2;
        if (this.sides[0]) {
            for (x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.replaceBlockState(world, this.theme.fencing.get(new BlockPos(this.x + x0, this.y + y0, this.z)), this.x + x0, this.y + y0, this.z, bounds, context);
                }
            }
        }
        if (this.sides[1]) {
            for (z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.replaceBlockState(world, this.theme.fencing.get(new BlockPos(this.x + model.width, this.y + y0, this.z + z0)), this.x + model.width - 1, this.y + y0, this.z + z0, bounds, context);
                }
            }
        }
        if (this.sides[2]) {
            for (x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.replaceBlockState(world, this.theme.fencing.get(new BlockPos(this.x + x0, this.y + y0, this.z + model.length)), this.x + x0, this.y + y0, this.z + model.length - 1, bounds, context);
                }
            }
        }
        if (this.sides[3]) {
            for (z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.replaceBlockState(world, this.theme.fencing.get(new BlockPos(this.x, this.y + y0, this.z + z0)), this.x, this.y + y0, this.z + z0, bounds, context);
                }
            }
        }
    }

    @Override
    public void setupBoundingBox() {
        if (this.model != null) {
            this.field_74887_e = this.model.createBoundingBoxWithOffset(this.x, this.y, this.z, this.field_186169_c);
        }
    }

    @Override
    public boolean canConnect(Direction side, int x, int z) {
        return true;
    }

    public DungeonStairs bottom() {
        this.stairType = 0;
        return this;
    }

    public DungeonStairs top() {
        this.stairType = 1;
        return this;
    }

    @Override
    public void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74768_a("stairType", this.stairType);
    }

    @Override
    public int getType() {
        return 1;
    }
}

