/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.theme;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import org.jline.utils.InputStreamReader;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.decoration.IDungeonDecoration;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.theme.JsonTheming;
import xiroc.dungeoncrawl.util.IBlockStateProvider;
import xiroc.dungeoncrawl.util.IRandom;
import xiroc.dungeoncrawl.util.JSONUtils;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class Theme {
    public static final Theme BUILTIN_DEFAULT_THEME = new Theme((pos, rotation) -> Blocks.field_196696_di.func_176223_P(), (pos, rotation) -> Blocks.field_196696_di.func_176223_P(), (pos, rotation) -> Blocks.field_150347_e.func_176223_P(), (pos, rotation) -> Blocks.field_150351_n.func_176223_P(), (pos, rotation) -> Blocks.field_150390_bg.func_176223_P(), (pos, rotation) -> Blocks.field_196659_cl.func_176223_P(), (pos, rotation) -> Blocks.field_150347_e.func_176223_P(), (pos, rotation) -> Blocks.field_150463_bK.func_176223_P(), (pos, rotation) -> Blocks.field_196646_bz.func_176223_P(), (pos, rotation) -> Blocks.field_196573_bB.func_176223_P(), (pos, rotation) -> Blocks.field_150411_aY.func_176223_P(), (pos, rotation) -> Blocks.field_150355_j.func_176223_P());
    public static final SecondaryTheme BUILTIN_DEFAULT_SECONDARY_THEME = new SecondaryTheme((pos, rotation) -> Blocks.field_196617_K.func_176223_P(), (pos, rotation) -> Blocks.field_196636_cW.func_176223_P(), (pos, rotation) -> Blocks.field_180413_ao.func_176223_P(), (pos, rotation) -> Blocks.field_196662_n.func_176223_P(), (pos, rotation) -> Blocks.field_150476_ad.func_176223_P(), (pos, rotation) -> Blocks.field_196622_bq.func_176223_P(), (pos, rotation) -> Blocks.field_180407_aO.func_176223_P(), (pos, rotation) -> Blocks.field_180390_bo.func_176223_P(), (pos, rotation) -> Blocks.field_196689_eF.func_176223_P(), (pos, rotation) -> Blocks.field_196663_cq.func_176223_P());
    protected static final Hashtable<String, IRandom<Theme>> BIOME_TO_THEME = new Hashtable();
    protected static final Hashtable<String, IRandom<SecondaryTheme>> BIOME_TO_SECONDARY_THEME = new Hashtable();
    public static final Hashtable<ResourceLocation, Theme> KEY_TO_THEME = new Hashtable();
    public static final Hashtable<ResourceLocation, SecondaryTheme> KEY_TO_SECONDARY_THEME = new Hashtable();
    private static WeightedRandom<Theme> DEFAULT_TOP_THEME = null;
    private static WeightedRandom<SecondaryTheme> DEFAULT_SECONDARY_TOP_THEME = null;
    private static IRandom<Theme> CATACOMBS_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<Theme> LOWER_CATACOMBS_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<Theme> HELL_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<SecondaryTheme> CATACOMBS_SECONDARY_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<SecondaryTheme> LOWER_CATACOMBS_SECONDARY_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<SecondaryTheme> HELL_SECONDARY_THEME = rand -> {
        throw new IllegalStateException();
    };
    public static final Hashtable<Integer, Theme> ID_TO_THEME = new Hashtable();
    public static final Hashtable<Integer, SecondaryTheme> ID_TO_SECONDARY_THEME = new Hashtable();
    private static final ResourceLocation PRIMARY_THEME_FALLBACK = DungeonCrawl.locate("vanilla/default");
    private static final ResourceLocation SECONDARY_THEME_FALLBACK = DungeonCrawl.locate("vanilla/oak");
    public static final ResourceLocation PRIMARY_HELL_MOSSY = DungeonCrawl.locate("vanilla/hell/mossy");
    private static final String PRIMARY_THEME_DIRECTORY = "theming/primary_themes";
    private static final String SECONDARY_THEME_DIRECTORY = "theming/secondary_themes";
    private static final String PRIMARY_THEME_MAPPINGS_DIRECTORY = "theming/mappings/primary";
    private static final String SECONDARY_THEME_MAPPINGS_DIRECTORY = "theming/mappings/secondary";
    private static final String UPPER_CATACOMBS_THEMES_DIRECTORY = "theming/lower_layers/upper_catacombs";
    private static final String CATACOMBS_THEMES_DIRECTORY = "theming/lower_layers/catacombs";
    private static final String HELL_THEMES_DIRECTORY = "theming/lower_layers/hell";
    private static ImmutableSet<ResourceLocation> THEME_KEYS;
    private static ImmutableSet<ResourceLocation> SECONDARY_THEME_KEYS;
    public final IBlockStateProvider pillar;
    public final IBlockStateProvider solid;
    public final IBlockStateProvider generic;
    public final IBlockStateProvider floor;
    public final IBlockStateProvider solidStairs;
    public final IBlockStateProvider stairs;
    public final IBlockStateProvider material;
    public final IBlockStateProvider wall;
    public final IBlockStateProvider slab;
    public final IBlockStateProvider solidSlab;
    public final IBlockStateProvider fencing;
    public final IBlockStateProvider fluid;
    public IRandom<SecondaryTheme> subTheme;
    private ResourceLocation key;
    private IDungeonDecoration[] decorations;

    public Theme(IBlockStateProvider pillar, IBlockStateProvider solid, IBlockStateProvider generic, IBlockStateProvider floor, IBlockStateProvider solidStairs, IBlockStateProvider stairs, IBlockStateProvider material, IBlockStateProvider wall, IBlockStateProvider slab, IBlockStateProvider solidSlab, IBlockStateProvider fencing, IBlockStateProvider fluid) {
        this.solid = solid;
        this.material = material;
        this.generic = generic;
        this.pillar = pillar;
        this.floor = floor;
        this.stairs = stairs;
        this.solidStairs = solidStairs;
        this.slab = slab;
        this.solidSlab = solidSlab;
        this.wall = wall;
        this.fencing = fencing;
        this.fluid = fluid;
    }

    public void setDecorations(IDungeonDecoration[] decorations) {
        this.decorations = decorations;
    }

    public boolean hasDecorations() {
        return this.decorations != null;
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public IDungeonDecoration[] getDecorations() {
        return this.decorations;
    }

    public IBlockStateProvider getPillar() {
        return this.pillar;
    }

    public IBlockStateProvider getSolid() {
        return this.solid;
    }

    public IBlockStateProvider getGeneric() {
        return this.generic;
    }

    public IBlockStateProvider getFencing() {
        return this.fencing;
    }

    public IBlockStateProvider getFloor() {
        return this.floor;
    }

    public IBlockStateProvider getFluid() {
        return this.fluid;
    }

    public IBlockStateProvider getSolidStairs() {
        return this.solidStairs;
    }

    public IBlockStateProvider getStairs() {
        return this.stairs;
    }

    public IBlockStateProvider getMaterial() {
        return this.material;
    }

    public IBlockStateProvider getWall() {
        return this.wall;
    }

    public IBlockStateProvider getSlab() {
        return this.slab;
    }

    public IBlockStateProvider getSolidSlab() {
        return this.solidSlab;
    }

    public static void loadJson(IResourceManager resourceManager) {
        JsonReader reader;
        Object theme;
        Object json;
        ResourceLocation key;
        JsonReader reader2;
        ID_TO_THEME.clear();
        ID_TO_SECONDARY_THEME.clear();
        KEY_TO_THEME.clear();
        KEY_TO_SECONDARY_THEME.clear();
        BIOME_TO_THEME.clear();
        BIOME_TO_SECONDARY_THEME.clear();
        ImmutableSet.Builder themeKeySetBuilder = new ImmutableSet.Builder();
        ImmutableSet.Builder secondaryThemeKeySetBuilder = new ImmutableSet.Builder();
        for (ResourceLocation resource : resourceManager.func_199003_a(DungeonCrawl.locate(SECONDARY_THEME_DIRECTORY).func_110623_a(), s -> s.endsWith(".json"))) {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)resource.toString());
            try {
                reader2 = new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(resource).func_199027_b()));
                key = DungeonCrawl.key(resource, SECONDARY_THEME_DIRECTORY, ".json");
                json = DungeonCrawl.JSON_PARSER.parse(reader2).getAsJsonObject();
                if (!JSONUtils.areRequirementsMet((JsonObject)json)) continue;
                theme = JsonTheming.deserializeSecondaryTheme((JsonObject)json, resource);
                ((SecondaryTheme)theme).key = key;
                secondaryThemeKeySetBuilder.add((Object)key);
                KEY_TO_SECONDARY_THEME.put(key, (SecondaryTheme)theme);
            }
            catch (Exception e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", (Object)resource.toString());
                e.printStackTrace();
            }
        }
        for (ResourceLocation resource : resourceManager.func_199003_a(DungeonCrawl.locate(PRIMARY_THEME_DIRECTORY).func_110623_a(), s -> s.endsWith(".json"))) {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)resource.toString());
            try {
                reader2 = new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(resource).func_199027_b()));
                key = DungeonCrawl.key(resource, PRIMARY_THEME_DIRECTORY, ".json");
                json = DungeonCrawl.JSON_PARSER.parse(reader2).getAsJsonObject();
                if (!JSONUtils.areRequirementsMet((JsonObject)json)) continue;
                theme = JsonTheming.deserializeTheme((JsonObject)json, resource);
                ((Theme)theme).key = key;
                themeKeySetBuilder.add((Object)key);
                KEY_TO_THEME.put(key, (Theme)theme);
            }
            catch (Exception e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", (Object)resource.toString());
                e.printStackTrace();
            }
        }
        Hashtable<String, WeightedRandom.Builder<Theme>> themeMappingBuilders = new Hashtable<String, WeightedRandom.Builder<Theme>>();
        Hashtable<String, WeightedRandom.Builder<SecondaryTheme>> secondaryThemeMappingBuilders = new Hashtable<String, WeightedRandom.Builder<SecondaryTheme>>();
        WeightedRandom.Builder<Theme> primaryDefaultBuilder = new WeightedRandom.Builder<Theme>();
        WeightedRandom.Builder<SecondaryTheme> secondaryDefaultBuilder = new WeightedRandom.Builder<SecondaryTheme>();
        for (ResourceLocation resource : resourceManager.func_199003_a(PRIMARY_THEME_MAPPINGS_DIRECTORY, s -> s.endsWith(".json"))) {
            try {
                reader = new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(resource).func_199027_b()));
                JsonTheming.deserializeThemeMapping(DungeonCrawl.JSON_PARSER.parse(reader).getAsJsonObject(), themeMappingBuilders, primaryDefaultBuilder, resource);
            }
            catch (IOException e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", (Object)resource);
                e.printStackTrace();
            }
        }
        for (ResourceLocation resource : resourceManager.func_199003_a(SECONDARY_THEME_MAPPINGS_DIRECTORY, s -> s.endsWith(".json"))) {
            try {
                reader = new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(resource).func_199027_b()));
                JsonTheming.deserializeSecondaryThemeMapping(DungeonCrawl.JSON_PARSER.parse(reader).getAsJsonObject(), secondaryThemeMappingBuilders, secondaryDefaultBuilder, resource);
            }
            catch (IOException e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", (Object)resource);
                e.printStackTrace();
            }
        }
        themeMappingBuilders.forEach((biome, builder) -> {
            IRandom cfr_ignored_0 = BIOME_TO_THEME.put((String)biome, builder.build());
        });
        secondaryThemeMappingBuilders.forEach((biome, builder) -> {
            IRandom cfr_ignored_0 = BIOME_TO_SECONDARY_THEME.put((String)biome, builder.build());
        });
        DEFAULT_TOP_THEME = primaryDefaultBuilder.build();
        DEFAULT_SECONDARY_TOP_THEME = secondaryDefaultBuilder.build();
        if (DEFAULT_TOP_THEME.isEmpty()) {
            throw new DatapackLoadException("No default primary themes are specified in the mappings.");
        }
        if (DEFAULT_SECONDARY_TOP_THEME.isEmpty()) {
            throw new DatapackLoadException("No default secondary themes are specified in the mappings.");
        }
        THEME_KEYS = themeKeySetBuilder.build();
        SECONDARY_THEME_KEYS = secondaryThemeKeySetBuilder.build();
        Tuple<WeightedRandom<Theme>, WeightedRandom<SecondaryTheme>> catacombs = Theme.loadRandomThemeFiles(UPPER_CATACOMBS_THEMES_DIRECTORY, resourceManager);
        Tuple<WeightedRandom<Theme>, WeightedRandom<SecondaryTheme>> lowerCatacombs = Theme.loadRandomThemeFiles(CATACOMBS_THEMES_DIRECTORY, resourceManager);
        Tuple<WeightedRandom<Theme>, WeightedRandom<SecondaryTheme>> hell = Theme.loadRandomThemeFiles(HELL_THEMES_DIRECTORY, resourceManager);
        CATACOMBS_THEME = (IRandom)catacombs.func_76341_a();
        CATACOMBS_SECONDARY_THEME = (IRandom)catacombs.func_76340_b();
        LOWER_CATACOMBS_THEME = (IRandom)lowerCatacombs.func_76341_a();
        LOWER_CATACOMBS_SECONDARY_THEME = (IRandom)lowerCatacombs.func_76340_b();
        HELL_THEME = (IRandom)hell.func_76341_a();
        HELL_SECONDARY_THEME = (IRandom)hell.func_76340_b();
    }

    private static Tuple<WeightedRandom<Theme>, WeightedRandom<SecondaryTheme>> loadRandomThemeFiles(String directory, IResourceManager resourceManager) {
        WeightedRandom.Builder<Theme> primary = new WeightedRandom.Builder<Theme>();
        WeightedRandom.Builder<SecondaryTheme> secondary = new WeightedRandom.Builder<SecondaryTheme>();
        for (ResourceLocation resource : resourceManager.func_199003_a(directory, s -> s.endsWith(".json"))) {
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(resource).func_199027_b()));
                JsonTheming.deserializeRandomThemeFile(DungeonCrawl.JSON_PARSER.parse(reader).getAsJsonObject(), primary, secondary, resource);
            }
            catch (IOException e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", (Object)resource);
                e.printStackTrace();
            }
        }
        if (primary.entries.isEmpty()) {
            throw new DatapackLoadException("No primary themes were present after loading " + directory);
        }
        if (secondary.entries.isEmpty()) {
            throw new DatapackLoadException("No secondary themes were present after loading " + directory);
        }
        return new Tuple(primary.build(), secondary.build());
    }

    public static Theme getBuiltinDefaultTheme() {
        return KEY_TO_THEME.getOrDefault(PRIMARY_THEME_FALLBACK, BUILTIN_DEFAULT_THEME);
    }

    public static SecondaryTheme getBuiltinDefaultSecondaryTheme() {
        return KEY_TO_SECONDARY_THEME.getOrDefault(SECONDARY_THEME_FALLBACK, BUILTIN_DEFAULT_SECONDARY_THEME);
    }

    public static Theme randomTheme(String biome, Random rand) {
        return (Theme)((IRandom)BIOME_TO_THEME.getOrDefault(biome, DEFAULT_TOP_THEME)).roll(rand);
    }

    public static SecondaryTheme randomSecondaryTheme(String biome, Random rand) {
        return (SecondaryTheme)((IRandom)BIOME_TO_SECONDARY_THEME.getOrDefault(biome, DEFAULT_SECONDARY_TOP_THEME)).roll(rand);
    }

    public static Theme randomCatacombsTheme(Random rand) {
        return CATACOMBS_THEME.roll(rand);
    }

    public static SecondaryTheme randomCatacombsSecondaryTheme(Random rand) {
        return CATACOMBS_SECONDARY_THEME.roll(rand);
    }

    public static Theme randomLowerCatacombsTheme(Random rand) {
        return LOWER_CATACOMBS_THEME.roll(rand);
    }

    public static SecondaryTheme randomLowerCatacombsSecondaryTheme(Random rand) {
        return LOWER_CATACOMBS_SECONDARY_THEME.roll(rand);
    }

    public static Theme randomHellTheme(Random rand) {
        return HELL_THEME.roll(rand);
    }

    public static SecondaryTheme randomHellSecondaryTheme(Random rand) {
        return HELL_SECONDARY_THEME.roll(rand);
    }

    public static Theme getTheme(ResourceLocation key) {
        return KEY_TO_THEME.getOrDefault(key, KEY_TO_THEME.getOrDefault(PRIMARY_THEME_FALLBACK, BUILTIN_DEFAULT_THEME));
    }

    public static SecondaryTheme getSecondaryTheme(ResourceLocation key) {
        return KEY_TO_SECONDARY_THEME.getOrDefault(key, KEY_TO_SECONDARY_THEME.getOrDefault(SECONDARY_THEME_FALLBACK, BUILTIN_DEFAULT_SECONDARY_THEME));
    }

    public static Theme getThemeByID(int theme) {
        return ID_TO_THEME.getOrDefault(theme, ID_TO_THEME.getOrDefault(0, BUILTIN_DEFAULT_THEME));
    }

    public static SecondaryTheme getSubThemeByID(int id) {
        return ID_TO_SECONDARY_THEME.getOrDefault(id, ID_TO_SECONDARY_THEME.getOrDefault(0, BUILTIN_DEFAULT_SECONDARY_THEME));
    }

    public static ImmutableSet<ResourceLocation> getThemeKeys() {
        return THEME_KEYS;
    }

    public static ImmutableSet<ResourceLocation> getSecondaryThemeKeys() {
        return SECONDARY_THEME_KEYS;
    }

    static {
        Theme.BUILTIN_DEFAULT_THEME.key = new ResourceLocation("builtin:default");
        BUILTIN_DEFAULT_SECONDARY_THEME.key = new ResourceLocation("builtin:default");
        KEY_TO_THEME.put(Theme.BUILTIN_DEFAULT_THEME.key, BUILTIN_DEFAULT_THEME);
        KEY_TO_SECONDARY_THEME.put(BUILTIN_DEFAULT_SECONDARY_THEME.key, BUILTIN_DEFAULT_SECONDARY_THEME);
    }

    public static class SecondaryTheme {
        public final IBlockStateProvider pillar;
        public final IBlockStateProvider trapDoor;
        public final IBlockStateProvider door;
        public final IBlockStateProvider material;
        public final IBlockStateProvider stairs;
        public final IBlockStateProvider slab;
        public final IBlockStateProvider fence;
        public final IBlockStateProvider fenceGate;
        public final IBlockStateProvider button;
        public final IBlockStateProvider pressurePlate;
        private ResourceLocation key;

        public SecondaryTheme(IBlockStateProvider pillar, IBlockStateProvider trapDoor, IBlockStateProvider door, IBlockStateProvider material, IBlockStateProvider stairs, IBlockStateProvider slab, IBlockStateProvider fence, IBlockStateProvider fenceGate, IBlockStateProvider button, IBlockStateProvider pressurePlate) {
            this.pillar = pillar;
            this.trapDoor = trapDoor;
            this.door = door;
            this.material = material;
            this.stairs = stairs;
            this.slab = slab;
            this.fence = fence;
            this.fenceGate = fenceGate;
            this.button = button;
            this.pressurePlate = pressurePlate;
        }

        public ResourceLocation getKey() {
            return this.key;
        }

        public IBlockStateProvider getPillar() {
            return this.pillar;
        }

        public IBlockStateProvider getTrapDoor() {
            return this.trapDoor;
        }

        public IBlockStateProvider getDoor() {
            return this.door;
        }

        public IBlockStateProvider getMaterial() {
            return this.material;
        }

        public IBlockStateProvider getStairs() {
            return this.stairs;
        }

        public IBlockStateProvider getSlab() {
            return this.slab;
        }

        public IBlockStateProvider getFence() {
            return this.fence;
        }

        public IBlockStateProvider getFenceGate() {
            return this.fenceGate;
        }

        public IBlockStateProvider getButton() {
            return this.button;
        }

        public IBlockStateProvider getPressurePlate() {
            return this.pressurePlate;
        }
    }
}

