/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util.tools;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Hashtable;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.command.argument.DungeonModelArgument;
import xiroc.dungeoncrawl.command.argument.ModelBlockDefinitionArgument;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.ModelBlockDefinition;
import xiroc.dungeoncrawl.dungeon.model.ModelHandler;
import xiroc.dungeoncrawl.util.tools.ModelEditContext;

public class Tools {
    private static final Hashtable<UUID, ModelEditContext> CONTEXT_TABLE = new Hashtable();

    @SubscribeEvent
    public void onServerStart(FMLServerStartingEvent event) {
        DungeonCrawl.LOGGER.debug("Registering Commands...");
        event.getCommandDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"savemodel").requires(a -> {
            try {
                return a.func_197035_h().func_184812_l_();
            }
            catch (CommandSyntaxException e) {
                a.func_197021_a((ITextComponent)new StringTextComponent("You must be a player!"));
                return false;
            }
        })).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(command -> {
            UUID uuid = ((CommandSource)command.getSource()).func_197035_h().func_110124_au();
            if (!CONTEXT_TABLE.containsKey(uuid)) {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Please select two positions."), true);
                return 1;
            }
            ModelEditContext context = CONTEXT_TABLE.get(uuid);
            if (context.arePositionsSet()) {
                String name = StringArgumentType.getString((CommandContext)command, (String)"name");
                BlockPos pos1 = new BlockPos(Math.min(context.pos1.func_177958_n(), context.pos2.func_177958_n()), Math.min(context.pos1.func_177956_o(), context.pos2.func_177956_o()), Math.min(context.pos1.func_177952_p(), context.pos2.func_177952_p()));
                BlockPos pos2 = new BlockPos(Math.max(context.pos1.func_177958_n(), context.pos2.func_177958_n()), Math.max(context.pos1.func_177956_o(), context.pos2.func_177956_o()), Math.max(context.pos1.func_177952_p(), context.pos2.func_177952_p()));
                ModelHandler.readAndSaveModelToFile(name, ModelBlockDefinition.getDefaultDefinition(), ((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos1, pos2.func_177958_n() - pos1.func_177958_n() + 1, pos2.func_177956_o() - pos1.func_177956_o() + 1, pos2.func_177952_p() - pos1.func_177952_p() + 1);
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Saved as " + TextFormatting.GREEN + name + ".nbt"), true);
                return 0;
            }
            ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Please select two positions."), true);
            return 1;
        })).then(Commands.func_197056_a((String)"block definition", (ArgumentType)ModelBlockDefinitionArgument.modelBlockDefinitionArgument()).executes(command -> {
            ModelBlockDefinition blockDefinition = ModelBlockDefinitionArgument.getDefinition((CommandContext<CommandSource>)command, "block definition");
            UUID uuid = ((CommandSource)command.getSource()).func_197035_h().func_110124_au();
            if (!CONTEXT_TABLE.containsKey(uuid)) {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Please select two positions."), true);
                return 1;
            }
            ModelEditContext context = CONTEXT_TABLE.get(uuid);
            if (context.arePositionsSet()) {
                BlockPos pos1 = new BlockPos(Math.min(context.pos1.func_177958_n(), context.pos2.func_177958_n()), Math.min(context.pos1.func_177956_o(), context.pos2.func_177956_o()), Math.min(context.pos1.func_177952_p(), context.pos2.func_177952_p()));
                BlockPos pos2 = new BlockPos(Math.max(context.pos1.func_177958_n(), context.pos2.func_177958_n()), Math.max(context.pos1.func_177956_o(), context.pos2.func_177956_o()), Math.max(context.pos1.func_177952_p(), context.pos2.func_177952_p()));
                String name = StringArgumentType.getString((CommandContext)command, (String)"name");
                ModelHandler.readAndSaveModelToFile(name, blockDefinition, ((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos1, pos2.func_177958_n() - pos1.func_177958_n() + 1, pos2.func_177956_o() - pos1.func_177956_o() + 1, pos2.func_177952_p() - pos1.func_177952_p() + 1);
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Saved as " + TextFormatting.GREEN + name + ".nbt"), true);
                return 0;
            }
            ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Please select two positions."), true);
            return 1;
        }))));
        event.getCommandDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"buildmodel").requires(a -> a.func_197034_c(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"model", (ArgumentType)DungeonModelArgument.modelArgument()).executes(command -> {
            DungeonModel model = DungeonModelArgument.getModel((CommandContext<CommandSource>)command, "model");
            BlockPos pos = ((CommandSource)command.getSource()).func_197035_h().func_180425_c();
            Tools.buildModel(model, (IWorld)((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos, ModelBlockDefinition.getDefaultDefinition());
            Tools.setOrigin((CommandSource)command.getSource(), pos);
            return 0;
        })).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(command -> {
            DungeonModel model = DungeonModelArgument.getModel((CommandContext<CommandSource>)command, "model");
            BlockPos pos = Vec3Argument.func_200385_b((CommandContext)command, (String)"location").func_197280_c((CommandSource)command.getSource());
            Tools.buildModel(model, (IWorld)((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos, ModelBlockDefinition.getDefaultDefinition());
            Tools.setOrigin((CommandSource)command.getSource(), pos);
            return 0;
        }))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"block definition", (ArgumentType)ModelBlockDefinitionArgument.modelBlockDefinitionArgument()).executes(command -> {
            ModelBlockDefinition blockDefinition = ModelBlockDefinitionArgument.getDefinition((CommandContext<CommandSource>)command, "block definition");
            DungeonModel model = DungeonModelArgument.getModel((CommandContext<CommandSource>)command, "model");
            BlockPos pos = ((CommandSource)command.getSource()).func_197035_h().func_180425_c();
            Tools.buildModel(model, (IWorld)((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos, blockDefinition);
            Tools.setOrigin((CommandSource)command.getSource(), pos);
            return 0;
        })).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(command -> {
            ModelBlockDefinition blockDefinition = ModelBlockDefinitionArgument.getDefinition((CommandContext<CommandSource>)command, "block definition");
            DungeonModel model = DungeonModelArgument.getModel((CommandContext<CommandSource>)command, "model");
            BlockPos pos = Vec3Argument.func_200385_b((CommandContext)command, (String)"location").func_197280_c((CommandSource)command.getSource());
            Tools.buildModel(model, (IWorld)((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos, blockDefinition);
            Tools.setOrigin((CommandSource)command.getSource(), pos);
            return 0;
        })))));
        event.getCommandDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"origin").requires(source -> source.func_197034_c(2))).executes(command -> {
            UUID uuid = ((CommandSource)command.getSource()).func_197035_h().func_110124_au();
            if (!CONTEXT_TABLE.containsKey(uuid)) {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Please set your origin with " + TextFormatting.BOLD + "/origin ~ ~ ~" + TextFormatting.RED + " first."), true);
                return 1;
            }
            ModelEditContext context = CONTEXT_TABLE.get(uuid);
            BlockPos pos = new BlockPos((Entity)((CommandSource)command.getSource()).func_197035_h());
            ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent("The origin is (x: " + context.origin.func_177958_n() + " y: " + context.origin.func_177956_o() + " z: " + context.origin.func_177952_p() + ")."), true);
            ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Your coordinates relative to the origin are (x: " + (pos.func_177958_n() - context.origin.func_177958_n()) + " y: " + (pos.func_177956_o() - context.origin.func_177956_o()) + " z: " + (pos.func_177952_p() - context.origin.func_177952_p()) + ")."), true);
            return 0;
        })).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(command -> {
            BlockPos location = Vec3Argument.func_200385_b((CommandContext)command, (String)"location").func_197280_c((CommandSource)command.getSource());
            Tools.setOrigin((CommandSource)command.getSource(), location);
            return 0;
        }))).then(Commands.func_197057_a((String)"reset").executes(command -> {
            UUID uuid = ((CommandSource)command.getSource()).func_197035_h().func_110124_au();
            if (CONTEXT_TABLE.containsKey(uuid)) {
                Tools.CONTEXT_TABLE.get((Object)uuid).origin = null;
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Origin reset."), true);
            } else {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Nothing to reset."), true);
            }
            return 0;
        })));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getWorld().func_201670_d() && event.getPlayer().func_184812_l_()) {
            Item item = event.getPlayer().func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b();
            if (item == Items.field_151056_x) {
                event.setCanceled(true);
                BlockPos pos = event.getPos();
                UUID uuid = event.getPlayer().func_146103_bH().getId();
                Tools.CONTEXT_TABLE.computeIfAbsent((UUID)uuid, (Function<UUID, ModelEditContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onBlockBreak$12(java.util.UUID ), (Ljava/util/UUID;)Lxiroc/dungeoncrawl/util/tools/ModelEditContext;)()).pos1 = pos;
                event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Position 1 set to (" + pos.func_177958_n() + " | " + pos.func_177956_o() + " | " + pos.func_177952_p() + ") "));
            } else if (item == Items.field_151006_E) {
                event.setCanceled(true);
                Tools.CONTEXT_TABLE.computeIfAbsent((UUID)event.getPlayer().func_110124_au(), (Function<UUID, ModelEditContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onBlockBreak$13(java.util.UUID ), (Ljava/util/UUID;)Lxiroc/dungeoncrawl/util/tools/ModelEditContext;)()).origin = event.getPos();
                event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent("Origin set to (x: " + event.getPos().func_177958_n() + " y: " + event.getPos().func_177956_o() + " z: " + event.getPos().func_177952_p() + ")."));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getPlayer().field_70170_p.func_201670_d() && event.getPlayer().func_184812_l_()) {
            if (event.getItemStack().func_77973_b() == Items.field_151056_x) {
                event.setCanceled(true);
                BlockPos pos = event.getPos();
                UUID uuid = event.getPlayer().func_146103_bH().getId();
                Tools.CONTEXT_TABLE.computeIfAbsent((UUID)uuid, (Function<UUID, ModelEditContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onItemUse$14(java.util.UUID ), (Ljava/util/UUID;)Lxiroc/dungeoncrawl/util/tools/ModelEditContext;)()).pos2 = pos;
                event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Position 2 set to (" + pos.func_177958_n() + " | " + pos.func_177956_o() + " | " + pos.func_177952_p() + ") "));
            } else if (event.getItemStack().func_77973_b() == Items.field_151006_E && CONTEXT_TABLE.containsKey(event.getPlayer().func_110124_au())) {
                event.setCanceled(true);
                ModelEditContext context = CONTEXT_TABLE.get(event.getPlayer().func_110124_au());
                if (context.origin != null) {
                    event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent("The coordinates of the block you clicked relative to the origin are (x: " + (event.getPos().func_177958_n() - context.origin.func_177958_n()) + " y: " + (event.getPos().func_177956_o() - context.origin.func_177956_o()) + " z: " + (event.getPos().func_177952_p() - context.origin.func_177952_p()) + ")."));
                }
            }
        }
    }

    private static void setOrigin(CommandSource source, BlockPos pos) throws CommandSyntaxException {
        ModelEditContext context = CONTEXT_TABLE.computeIfAbsent(source.func_197035_h().func_110124_au(), id -> new ModelEditContext());
        context.origin = pos;
        source.func_197030_a((ITextComponent)new StringTextComponent("Origin set to (x: " + context.origin.func_177958_n() + " y: " + context.origin.func_177956_o() + " z: " + context.origin.func_177952_p() + ")."), true);
    }

    public static void buildModel(DungeonModel model, IWorld world, BlockPos pos, ModelBlockDefinition definition) {
        for (int y = 0; y < model.height; ++y) {
            for (int x = 0; x < model.width; ++x) {
                for (int z = 0; z < model.length; ++z) {
                    world.func_180501_a(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z), Blocks.field_180401_cv.func_176223_P(), 2);
                }
            }
        }
        model.blocks.forEach(modelBlock -> {
            BlockPos placePos = pos.func_177971_a(modelBlock.position);
            Block block = definition.getBlock((DungeonModelBlock)modelBlock);
            if (block == null) {
                block = Blocks.field_150350_a;
            }
            world.func_180501_a(placePos, modelBlock.create(block.func_176223_P(), Rotation.NONE), 3);
            world.func_195592_c(placePos, world.func_180495_p(placePos).func_177230_c());
        });
    }

    private static /* synthetic */ ModelEditContext lambda$onItemUse$14(UUID id) {
        return new ModelEditContext();
    }

    private static /* synthetic */ ModelEditContext lambda$onBlockBreak$13(UUID key) {
        return new ModelEditContext();
    }

    private static /* synthetic */ ModelEditContext lambda$onBlockBreak$12(UUID id) {
        return new ModelEditContext();
    }
}

