/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.client;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.File;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import oreexcavation.client.GuiNumberField;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.shapes.ShapeRegistry;

public class GuiEditShapes
extends Screen {
    private static final ResourceLocation GUI_TEX = new ResourceLocation("oreexcavation", "textures/gui/edit_shapes.png");
    private static final ResourceLocation GUI_ICO = new ResourceLocation("minecraft:textures/gui/icons.png");
    private static final ResourceLocation SPRITE_STONE = new ResourceLocation("minecraft:block/stone");
    private int guiLeft = 0;
    private int guiTop = 0;
    private int idx = 0;
    private ExcavateShape curShape = null;
    private TextFieldWidget txtField = null;
    private GuiNumberField nmbField = null;
    private Button btnLeft = null;
    private Button btnRight = null;
    private Button btnAdd = null;
    private Button btnRemove = null;

    public GuiEditShapes() {
        super((ITextComponent)new StringTextComponent("Edit Shapes"));
    }

    public void tick() {
        this.txtField.func_146178_a();
        this.nmbField.func_146178_a();
    }

    public void init() {
        this.guiLeft = this.width / 2 - 128;
        this.guiTop = this.height / 2 - 128;
        this.minecraft.field_195559_v.func_197967_a(true);
        this.btnLeft = new Button(this.guiLeft + 14, this.guiTop + 118, 20, 20, "<", btn -> this.actionPerformed(0));
        this.btnLeft.active = this.idx > 0;
        this.btnRight = new Button(this.guiLeft + 222, this.guiTop + 118, 20, 20, ">", btn -> this.actionPerformed(1));
        this.btnRight.active = this.idx + 1 < ShapeRegistry.INSTANCE.getShapeList().size();
        this.btnAdd = new Button(this.guiLeft + 150, this.guiTop + 222, 20, 20, "+", btn -> this.actionPerformed(2));
        this.btnRemove = new Button(this.guiLeft + 86, this.guiTop + 222, 20, 20, "-", btn -> this.actionPerformed(3));
        this.txtField = new TextFieldWidget(this.minecraft.field_71466_p, this.guiLeft + 48, this.guiTop + 16, 112, 16, "");
        this.nmbField = new GuiNumberField(this.minecraft.field_71466_p, this.guiLeft + 176, this.guiTop + 16, 32, 16);
        this.children.add(this.txtField);
        this.children.add(this.nmbField);
        this.addButton((Widget)this.btnLeft);
        this.addButton((Widget)this.btnRight);
        this.addButton((Widget)this.btnAdd);
        this.addButton((Widget)this.btnRemove);
        this.refreshShape();
    }

    public void render(int mx, int my, float partialTick) {
        this.renderBackground();
        this.minecraft.func_110434_K().func_110577_a(GUI_TEX);
        this.blit(this.guiLeft, this.guiTop, 0, 0, 256, 256);
        this.txtField.render(mx, my, partialTick);
        this.nmbField.render(mx, my, partialTick);
        super.render(mx, my, partialTick);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.curShape != null) {
            int mask = this.curShape.getShapeMask();
            int off = this.curShape.getReticle();
            TextureAtlasSprite spr = (TextureAtlasSprite)this.minecraft.func_228015_a_(AtlasTexture.field_110575_b).apply(SPRITE_STONE);
            for (int x = 0; x < 5; ++x) {
                for (int y = 0; y < 5; ++y) {
                    int flag = ExcavateShape.posToMask(x, y);
                    if ((mask & flag) != flag) {
                        this.minecraft.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                        GlStateManager.func_227626_N_();
                        GlStateManager.func_227688_c_((float)(this.guiLeft + 176 - x * 32), (float)(this.guiTop + 176 - y * 32), (float)0.0f);
                        GlStateManager.func_227672_b_((float)2.0f, (float)2.0f, (float)1.0f);
                        GuiEditShapes.blit((int)0, (int)0, (int)0, (int)16, (int)16, (TextureAtlasSprite)spr);
                        GlStateManager.func_227627_O_();
                    }
                    if (off != y * 5 + x) continue;
                    this.minecraft.func_110434_K().func_110577_a(GUI_ICO);
                    GlStateManager.func_227626_N_();
                    GlStateManager.func_227688_c_((float)(this.guiLeft + 176 - x * 32), (float)(this.guiTop + 176 - y * 32), (float)0.0f);
                    GlStateManager.func_227672_b_((float)2.0f, (float)2.0f, (float)1.0f);
                    this.blit(0, 0, 0, 0, 16, 16);
                    GlStateManager.func_227627_O_();
                }
            }
        }
    }

    public void onClose() {
        ShapeRegistry.INSTANCE.saveShapes(new File("config/oreexcavation_shapes.json"));
        this.minecraft.field_195559_v.func_197967_a(false);
        super.onClose();
    }

    public void refreshShape() {
        if (ShapeRegistry.INSTANCE.getShapeList().size() <= 0) {
            this.curShape = null;
            this.idx = 0;
        } else {
            this.idx = MathHelper.func_76125_a((int)this.idx, (int)0, (int)(ShapeRegistry.INSTANCE.getShapeList().size() - 1));
            this.curShape = ShapeRegistry.INSTANCE.getShapeAt(this.idx + 1);
        }
        if (this.curShape != null) {
            this.txtField.func_146180_a(this.curShape.getName());
            this.nmbField.func_146180_a("" + this.curShape.getMaxDepth());
            this.btnRemove.active = true;
        } else {
            this.txtField.func_146180_a("");
            this.nmbField.func_146180_a("-1");
            this.btnRemove.active = false;
        }
        this.btnLeft.active = this.idx > 0;
        this.btnRight.active = this.idx + 1 < ShapeRegistry.INSTANCE.getShapeList().size();
    }

    private void actionPerformed(int id) {
        if (id == 0 && this.idx > 0) {
            --this.idx;
            this.refreshShape();
        } else if (id == 1 && this.idx + 1 < ShapeRegistry.INSTANCE.getShapeList().size()) {
            ++this.idx;
            this.refreshShape();
        } else if (id == 2) {
            this.idx = ShapeRegistry.INSTANCE.getShapeList().size();
            ExcavateShape nes = new ExcavateShape();
            for (int i = 1; i < 4; ++i) {
                for (int j = 1; j < 4; ++j) {
                    nes.setMask(i, j, true);
                }
            }
            ShapeRegistry.INSTANCE.getShapeList().add(nes);
            this.refreshShape();
        } else if (id == 3 && this.curShape != null) {
            ShapeRegistry.INSTANCE.getShapeList().remove(this.curShape);
            this.refreshShape();
        }
    }

    public boolean keyPressed(int k1, int k2, int k3) {
        boolean flag = super.keyPressed(k1, k2, k3);
        if (this.curShape != null) {
            this.curShape.setName(this.txtField.func_146179_b());
            this.curShape.setMaxDepth(this.nmbField.getNumber().intValue());
        }
        return flag;
    }

    public boolean mouseClicked(double mx, double my, int click) {
        boolean used = super.mouseClicked(mx, my, click);
        int x = (int)Math.floor((mx - (double)this.guiLeft - 48.0) / 32.0);
        int y = (int)Math.floor((my - (double)this.guiTop - 48.0) / 32.0);
        if (this.curShape != null && mx - (double)this.guiLeft >= 48.0 && x < 5 && my - (double)this.guiTop >= 48.0 && y < 5) {
            if (click == 0) {
                int flag = ExcavateShape.posToMask(4 - x, 4 - y);
                int mask = this.curShape.getShapeMask();
                this.curShape.setMask(4 - x, 4 - y, (mask & flag) != flag);
            } else if (click == 1) {
                this.curShape.setReticle(4 - x, 4 - y);
            }
        }
        return used;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

