/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bubbly;

import java.util.function.Supplier;
import net.mcreator.bubbly.BubblyMod;
import net.mcreator.bubbly.BubblyModElements;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class BubblyModVariables {
    @CapabilityInject(value=PlayerVariables.class)
    public static Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = null;

    public BubblyModVariables(BubblyModElements elements) {
        elements.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
    }

    private void init(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(PlayerVariables.class, (Capability.IStorage)new PlayerVariablesStorage(), PlayerVariables::new);
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity && !(event.getObject() instanceof FakePlayer)) {
            event.addCapability(new ResourceLocation("bubbly", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
        PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
        clone.armour_1 = original.armour_1;
        clone.armour_2 = original.armour_2;
        clone.armour_3 = original.armour_3;
        clone.armour_0 = original.armour_0;
        clone.item_1 = original.item_1;
        clone.item_2 = original.item_2;
        clone.item_3 = original.item_3;
        clone.item_4 = original.item_4;
        clone.item_5 = original.item_5;
        clone.item_6 = original.item_6;
        clone.item_7 = original.item_7;
        clone.item_8 = original.item_8;
        clone.item_9 = original.item_9;
        if (!event.isWasDeath()) {
            // empty if block
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(PacketBuffer buffer) {
            this.data = new PlayerVariables();
            new PlayerVariablesStorage().readNBT(null, this.data, null, (INBT)buffer.func_150793_b());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, PacketBuffer buffer) {
            buffer.func_150786_a((CompoundNBT)new PlayerVariablesStorage().writeNBT(null, message.data, null));
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.func_71410_x().field_71439_g.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.armour_1 = message.data.armour_1;
                    variables.armour_2 = message.data.armour_2;
                    variables.armour_3 = message.data.armour_3;
                    variables.armour_0 = message.data.armour_0;
                    variables.item_1 = message.data.item_1;
                    variables.item_2 = message.data.item_2;
                    variables.item_3 = message.data.item_3;
                    variables.item_4 = message.data.item_4;
                    variables.item_5 = message.data.item_5;
                    variables.item_6 = message.data.item_6;
                    variables.item_7 = message.data.item_7;
                    variables.item_8 = message.data.item_8;
                    variables.item_9 = message.data.item_9;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public ItemStack armour_1 = ItemStack.field_190927_a;
        public ItemStack armour_2 = ItemStack.field_190927_a;
        public ItemStack armour_3 = ItemStack.field_190927_a;
        public ItemStack armour_0 = ItemStack.field_190927_a;
        public ItemStack item_1 = ItemStack.field_190927_a;
        public ItemStack item_2 = ItemStack.field_190927_a;
        public ItemStack item_3 = ItemStack.field_190927_a;
        public ItemStack item_4 = ItemStack.field_190927_a;
        public ItemStack item_5 = ItemStack.field_190927_a;
        public ItemStack item_6 = ItemStack.field_190927_a;
        public ItemStack item_7 = ItemStack.field_190927_a;
        public ItemStack item_8 = ItemStack.field_190927_a;
        public ItemStack item_9 = ItemStack.field_190927_a;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayerEntity) {
                BubblyMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entity), (Object)new PlayerVariablesSyncMessage(this));
            }
        }
    }

    private static class PlayerVariablesStorage
    implements Capability.IStorage<PlayerVariables> {
        private PlayerVariablesStorage() {
        }

        public INBT writeNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("armour_1", (INBT)instance.armour_1.func_77955_b(new CompoundNBT()));
            nbt.func_218657_a("armour_2", (INBT)instance.armour_2.func_77955_b(new CompoundNBT()));
            nbt.func_218657_a("armour_3", (INBT)instance.armour_3.func_77955_b(new CompoundNBT()));
            nbt.func_218657_a("armour_0", (INBT)instance.armour_0.func_77955_b(new CompoundNBT()));
            nbt.func_218657_a("item_1", (INBT)instance.item_1.func_77955_b(new CompoundNBT()));
            nbt.func_218657_a("item_2", (INBT)instance.item_2.func_77955_b(new CompoundNBT()));
            nbt.func_218657_a("item_3", (INBT)instance.item_3.func_77955_b(new CompoundNBT()));
            nbt.func_218657_a("item_4", (INBT)instance.item_4.func_77955_b(new CompoundNBT()));
            nbt.func_218657_a("item_5", (INBT)instance.item_5.func_77955_b(new CompoundNBT()));
            nbt.func_218657_a("item_6", (INBT)instance.item_6.func_77955_b(new CompoundNBT()));
            nbt.func_218657_a("item_7", (INBT)instance.item_7.func_77955_b(new CompoundNBT()));
            nbt.func_218657_a("item_8", (INBT)instance.item_8.func_77955_b(new CompoundNBT()));
            nbt.func_218657_a("item_9", (INBT)instance.item_9.func_77955_b(new CompoundNBT()));
            return nbt;
        }

        public void readNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side, INBT inbt) {
            CompoundNBT nbt = (CompoundNBT)inbt;
            instance.armour_1 = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("armour_1"));
            instance.armour_2 = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("armour_2"));
            instance.armour_3 = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("armour_3"));
            instance.armour_0 = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("armour_0"));
            instance.item_1 = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item_1"));
            instance.item_2 = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item_2"));
            instance.item_3 = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item_3"));
            instance.item_4 = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item_4"));
            instance.item_5 = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item_5"));
            instance.item_6 = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item_6"));
            instance.item_7 = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item_7"));
            instance.item_8 = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item_8"));
            instance.item_9 = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item_9"));
        }
    }

    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<INBT> {
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> PLAYER_VARIABLES_CAPABILITY.getDefaultInstance());

        private PlayerVariablesProvider() {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return PLAYER_VARIABLES_CAPABILITY.getStorage().writeNBT(PLAYER_VARIABLES_CAPABILITY, (Object)((PlayerVariables)this.instance.orElseThrow(RuntimeException::new)), null);
        }

        public void deserializeNBT(INBT nbt) {
            PLAYER_VARIABLES_CAPABILITY.getStorage().readNBT(PLAYER_VARIABLES_CAPABILITY, (Object)((PlayerVariables)this.instance.orElseThrow(RuntimeException::new)), null, nbt);
        }
    }
}

