/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.TracedEditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.util.eventbus.EventBus;
import com.sk89q.worldedit.world.World;

public class EditSessionFactory {
    public EditSession getEditSession(World world, int maxBlocks) {
        throw new RuntimeException("Method needs to be implemented");
    }

    public EditSession getEditSession(World world, int maxBlocks, Actor actor) {
        throw new RuntimeException("Method needs to be implemented");
    }

    public EditSession getEditSession(World world, int maxBlocks, BlockBag blockBag) {
        throw new RuntimeException("Method needs to be implemented");
    }

    public EditSession getEditSession(World world, int maxBlocks, BlockBag blockBag, Actor actor) {
        throw new RuntimeException("Method needs to be implemented");
    }

    static final class EditSessionFactoryImpl
    extends EditSessionFactory {
        private final EventBus eventBus;

        EditSessionFactoryImpl(EventBus eventBus) {
            Preconditions.checkNotNull((Object)eventBus);
            this.eventBus = eventBus;
        }

        @Override
        public EditSession getEditSession(World world, int maxBlocks) {
            return this.getEditSession(world, maxBlocks, null, null);
        }

        @Override
        public EditSession getEditSession(World world, int maxBlocks, Actor actor) {
            return this.getEditSession(world, maxBlocks, null, actor);
        }

        @Override
        public EditSession getEditSession(World world, int maxBlocks, BlockBag blockBag) {
            return this.getEditSession(world, maxBlocks, blockBag, null);
        }

        @Override
        public EditSession getEditSession(World world, int maxBlocks, BlockBag blockBag, Actor actor) {
            if (WorldEdit.getInstance().getConfiguration().traceUnflushedSessions) {
                return new TracedEditSession(this.eventBus, world, maxBlocks, blockBag, new EditSessionEvent(world, actor, maxBlocks, null));
            }
            return new EditSession(this.eventBus, world, maxBlocks, blockBag, new EditSessionEvent(world, actor, maxBlocks, null));
        }
    }
}

