/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.buffer;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.function.pattern.BiomePattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.AbstractFlatRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ForgetfulExtentBuffer
extends AbstractDelegateExtent
implements Pattern,
BiomePattern {
    private final Map<BlockVector3, BaseBlock> buffer = new LinkedHashMap<BlockVector3, BaseBlock>();
    private final Map<BlockVector2, BiomeType> biomeBuffer = new LinkedHashMap<BlockVector2, BiomeType>();
    private final Mask mask;
    private final Mask2D biomeMask;
    private BlockVector3 min = null;
    private BlockVector2 min2d = null;
    private BlockVector3 max = null;
    private BlockVector2 max2d = null;

    public ForgetfulExtentBuffer(Extent delegate) {
        this(delegate, Masks.alwaysTrue());
    }

    public ForgetfulExtentBuffer(Extent delegate, Mask mask) {
        super(delegate);
        Preconditions.checkNotNull((Object)mask);
        this.mask = mask;
        Mask2D bmask = mask.toMask2D();
        this.biomeMask = bmask == null ? Masks.alwaysTrue2D() : bmask;
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        this.min = this.min == null ? location : this.min.getMinimum(location);
        this.max = this.max == null ? location : this.max.getMaximum(location);
        if (this.mask.test(location)) {
            this.buffer.put(location, block.toBaseBlock());
            return true;
        }
        return this.getExtent().setBlock(location, block);
    }

    @Override
    public boolean setBiome(BlockVector2 position, BiomeType biome) {
        this.min2d = this.min2d == null ? position : this.min2d.getMinimum(position);
        this.max2d = this.max2d == null ? position : this.max2d.getMaximum(position);
        if (this.biomeMask.test(position)) {
            this.biomeBuffer.put(position, biome);
            return true;
        }
        return this.getExtent().setBiome(position, biome);
    }

    @Override
    public BaseBlock apply(BlockVector3 pos) {
        BaseBlock block = this.buffer.get(pos);
        if (block != null) {
            return block;
        }
        return BlockTypes.AIR.getDefaultState().toBaseBlock();
    }

    @Override
    public BiomeType apply(BlockVector2 pos) {
        BiomeType biome = this.biomeBuffer.get(pos);
        if (biome != null) {
            return biome;
        }
        return BiomeTypes.OCEAN;
    }

    public Region asRegion() {
        return new AbstractFlatRegion(null){

            @Override
            public BlockVector3 getMinimumPoint() {
                return ForgetfulExtentBuffer.this.min != null ? ForgetfulExtentBuffer.this.min : BlockVector3.ZERO;
            }

            @Override
            public BlockVector3 getMaximumPoint() {
                return ForgetfulExtentBuffer.this.max != null ? ForgetfulExtentBuffer.this.max : BlockVector3.ZERO;
            }

            @Override
            public void expand(BlockVector3 ... changes) throws RegionOperationException {
                throw new UnsupportedOperationException("Cannot change the size of this region");
            }

            @Override
            public void contract(BlockVector3 ... changes) throws RegionOperationException {
                throw new UnsupportedOperationException("Cannot change the size of this region");
            }

            @Override
            public boolean contains(BlockVector3 position) {
                return ForgetfulExtentBuffer.this.buffer.containsKey(position);
            }

            @Override
            public Iterator<BlockVector3> iterator() {
                return ForgetfulExtentBuffer.this.buffer.keySet().iterator();
            }

            @Override
            public Iterable<BlockVector2> asFlatRegion() {
                return ForgetfulExtentBuffer.this.biomeBuffer.keySet();
            }
        };
    }
}

