/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.transform;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;

public class BlockTransformExtent
extends AbstractDelegateExtent {
    private final Transform transform;
    private static final Set<String> directionNames = Sets.newHashSet((Object[])new String[]{"north", "south", "east", "west"});

    public BlockTransformExtent(Extent extent, Transform transform) {
        super(extent);
        Preconditions.checkNotNull((Object)transform);
        this.transform = transform;
    }

    public Transform getTransform() {
        return this.transform;
    }

    private <T extends BlockStateHolder<T>> T transformBlock(T block, boolean reverse) {
        return BlockTransformExtent.transform(block, reverse ? this.transform.inverse() : this.transform);
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        return this.transformBlock(super.getBlock(position), false);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        return this.transformBlock(super.getFullBlock(position), false);
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        return super.setBlock(location, this.transformBlock(block, true));
    }

    public static <B extends BlockStateHolder<B>> B transform(B block, Transform transform) {
        Preconditions.checkNotNull(block);
        Preconditions.checkNotNull((Object)transform);
        B result = block;
        List<Property<?>> properties = block.getBlockType().getProperties();
        for (Property<?> property : properties) {
            OptionalInt newRotation;
            Vector3 vec;
            Object value;
            if (property instanceof DirectionalProperty) {
                Vector3 newValue;
                DirectionalProperty dirProp = (DirectionalProperty)property;
                value = (Direction)((Object)block.getState(property));
                if (value == null || (newValue = BlockTransformExtent.getNewStateValue(dirProp.getValues(), transform, value.toVector())) == null) continue;
                result = result.with(dirProp, (Direction)Direction.findClosest(newValue, Direction.Flag.ALL));
                continue;
            }
            if (property instanceof EnumProperty) {
                EnumProperty enumProp = (EnumProperty)property;
                if (property.getName().equals("axis")) {
                    Object newValue;
                    value = null;
                    switch ((String)block.getState(property)) {
                        case "x": {
                            value = Direction.EAST;
                            break;
                        }
                        case "y": {
                            value = Direction.UP;
                            break;
                        }
                        case "z": {
                            value = Direction.NORTH;
                        }
                    }
                    if (value == null || (newValue = BlockTransformExtent.getNewStateValue(Direction.valuesOf(Direction.Flag.UPRIGHT | Direction.Flag.CARDINAL), transform, value.toVector())) == null) continue;
                    String axis = null;
                    Direction newDir = Direction.findClosest((Vector3)newValue, Direction.Flag.UPRIGHT | Direction.Flag.CARDINAL);
                    if (newDir == Direction.NORTH || newDir == Direction.SOUTH) {
                        axis = "z";
                    } else if (newDir == Direction.EAST || newDir == Direction.WEST) {
                        axis = "x";
                    } else if (newDir == Direction.UP || newDir == Direction.DOWN) {
                        axis = "y";
                    }
                    if (axis == null) continue;
                    result = result.with(enumProp, (String)axis);
                    continue;
                }
                if (property.getName().equals("type") && transform instanceof AffineTransform) {
                    if (!((AffineTransform)transform).isHorizontalFlip()) continue;
                    value = (String)block.getState(property);
                    String newValue = null;
                    if ("left".equals(value)) {
                        newValue = "right";
                    } else if ("right".equals(value)) {
                        newValue = "left";
                    }
                    if (newValue == null || !enumProp.getValues().contains(newValue)) continue;
                    result = result.with(enumProp, (String)newValue);
                    continue;
                }
                if (!property.getName().equals("shape") || !(transform instanceof AffineTransform) || !((AffineTransform)transform).isHorizontalFlip()) continue;
                value = (String)block.getState(property);
                String newValue = null;
                if ("outer_left".equals(value)) {
                    newValue = "outer_right";
                } else if ("outer_right".equals(value)) {
                    newValue = "outer_left";
                } else if ("inner_left".equals(value)) {
                    newValue = "inner_right";
                } else if ("inner_right".equals(value)) {
                    newValue = "inner_left";
                }
                if (newValue == null || !enumProp.getValues().contains(newValue)) continue;
                result = result.with(enumProp, (String)newValue);
                continue;
            }
            if (!(property instanceof IntegerProperty)) continue;
            IntegerProperty intProp = (IntegerProperty)property;
            if (!property.getName().equals("rotation") || intProp.getValues().size() != 16) continue;
            Optional<Direction> direction = Direction.fromRotationIndex(block.getState(intProp));
            int horizontalFlags = Direction.Flag.CARDINAL | Direction.Flag.ORDINAL | Direction.Flag.SECONDARY_ORDINAL;
            if (!direction.isPresent() || (vec = BlockTransformExtent.getNewStateValue(Direction.valuesOf(horizontalFlags), transform, direction.get().toVector())) == null || !(newRotation = Direction.findClosest(vec, horizontalFlags).toRotationIndex()).isPresent()) continue;
            result = result.with(intProp, newRotation.getAsInt());
        }
        HashMap<String, Boolean> directionalProperties = new HashMap<String, Boolean>();
        for (Property<?> prop : properties) {
            String origProp;
            Direction dir;
            Direction closest;
            if (!directionNames.contains(prop.getName()) || (!(prop instanceof BooleanProperty) || !((Boolean)block.getState(prop)).booleanValue()) && (!(prop instanceof EnumProperty) || block.getState(prop).toString().equals("none")) || (closest = Direction.findClosest(transform.apply((dir = Direction.valueOf(origProp = prop.getName().toUpperCase(Locale.ROOT))).toVector()), Direction.Flag.CARDINAL)) == null) continue;
            String closestProp = closest.name().toLowerCase(Locale.ROOT);
            if (prop instanceof BooleanProperty) {
                result = result.with((BooleanProperty)prop, (Boolean)Boolean.FALSE);
                directionalProperties.put(closestProp, Boolean.TRUE);
                continue;
            }
            if (prop.getValues().contains("none")) {
                result = result.with(prop, (String)"none");
            }
            directionalProperties.put(closestProp, (Boolean)block.getState(prop));
        }
        if (!directionalProperties.isEmpty()) {
            for (String directionName : directionNames) {
                Property dirProp = block.getBlockType().getProperty(directionName);
                result = result.with(dirProp, directionalProperties.get(directionName));
            }
        }
        return result;
    }

    @Nullable
    private static Vector3 getNewStateValue(List<Direction> allowedStates, Transform transform, Vector3 oldDirection) {
        Vector3 newDirection = transform.apply(oldDirection).subtract(transform.apply(Vector3.ZERO)).normalize();
        Vector3 newValue = null;
        double closest = -2.0;
        boolean found = false;
        for (Direction v : allowedStates) {
            double dot = v.toVector().normalize().dot(newDirection);
            if (!(dot >= closest)) continue;
            closest = dot;
            newValue = v.toVector();
            found = true;
        }
        if (found) {
            return newValue;
        }
        return null;
    }
}

