/*
 * Decompiled with CFR 0.152.
 */
package com.saajitaro.silence;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="silence")
public class Silence {
    File silence_config_path = new File(FMLPaths.GAMEDIR.get().toString() + "/config/silence/");
    File silence_config_file = new File(FMLPaths.GAMEDIR.get().toString() + "/config/silence/players.json");

    public Silence() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void serverLoad(FMLServerStartingEvent event) {
        event.getCommandDispatcher().register(this.customCommand());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onLogin(ClientPlayerNetworkEvent.LoggedInEvent event) throws IOException {
        this.makeJSON();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onChatSend(ClientChatEvent event) throws IOException {
        String message_sent = event.getOriginalMessage();
        String[] split_message = message_sent.split("\\s+");
        int num_of_words_in_msg = split_message.length;
        if ((message_sent.startsWith("/block add player") || message_sent.startsWith("/block add word")) && num_of_words_in_msg >= 4) {
            this.addWordOrPlayerToJSON(split_message[2] + "s", split_message[3]);
        } else if ((message_sent.startsWith("/block remove player") || message_sent.startsWith("/block remove word")) && num_of_words_in_msg >= 4) {
            this.removeWordOrPlayerFromJSON(split_message[2] + "s", split_message[3]);
        } else if (message_sent.startsWith("/block show_placeholders")) {
            this.changePlaceholderState();
        } else if (message_sent.startsWith("/block get_words")) {
            this.getBlockedWordsAsString();
        } else if (message_sent.startsWith("/block get_players")) {
            this.getMutedPlayersAsString();
        } else if (message_sent.startsWith("/block show_me_cmds")) {
            this.changeMeMessagesState();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent event) throws IOException {
        JsonArray muted_players = this.getMutedPlayers();
        Collection players = Minecraft.func_71410_x().func_147114_u().func_175106_d();
        String formatted_message = event.getMessage().func_150254_d();
        if (formatted_message.startsWith("* ")) {
            if (this.showMeMessages()) {
                for (JsonElement muted_player : muted_players) {
                    if (!formatted_message.toString().startsWith("* " + muted_player.getAsString())) continue;
                    if (this.showPlaceholder()) {
                        event.setMessage((ITextComponent)new StringTextComponent("User Blocked: " + muted_player.getAsString()));
                        continue;
                    }
                    event.setCanceled(true);
                }
            } else if (this.showPlaceholder()) {
                event.setMessage((ITextComponent)new StringTextComponent("/me message blocked"));
            } else {
                event.setCanceled(true);
            }
        }
        ITextComponent unformatted_message = event.getMessage();
        for (NetworkPlayerInfo player : players) {
            for (JsonElement muted_player : muted_players) {
                String player_id = player.func_178845_a().getId().toString();
                String player_name = player.func_178845_a().getName();
                if (!unformatted_message.toString().contains(player_id) || !player_name.toLowerCase().equals(muted_player.getAsString().toLowerCase())) continue;
                if (this.showPlaceholder()) {
                    event.setMessage((ITextComponent)new StringTextComponent("User Blocked: " + player_name));
                    continue;
                }
                event.setCanceled(true);
            }
        }
        if (!event.isCanceled() && event.getMessage().func_150254_d().equals(formatted_message)) {
            for (JsonElement word : this.getBlockedWords()) {
                if (!event.getMessage().func_150254_d().toLowerCase().contains(word.getAsString().toLowerCase())) continue;
                if (this.showPlaceholder()) {
                    event.setMessage((ITextComponent)new StringTextComponent("Word blocked: " + word.getAsString()));
                    continue;
                }
                event.setCanceled(true);
            }
        }
    }

    private LiteralArgumentBuilder<CommandSource> customCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"block").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").then(Commands.func_197057_a((String)"player").then(Commands.func_197056_a((String)"player username", (ArgumentType)StringArgumentType.word()).executes(this::dummy)))).then(Commands.func_197057_a((String)"word").then(Commands.func_197056_a((String)"word", (ArgumentType)StringArgumentType.word()).executes(this::dummy))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").then(Commands.func_197057_a((String)"player").then(Commands.func_197056_a((String)"player username", (ArgumentType)StringArgumentType.word()).executes(this::dummy)))).then(Commands.func_197057_a((String)"word").then(Commands.func_197056_a((String)"word", (ArgumentType)StringArgumentType.word()).executes(this::dummy))))).then(Commands.func_197057_a((String)"show_placeholders").executes(this::dummy))).then(Commands.func_197057_a((String)"get_words").executes(this::dummy))).then(Commands.func_197057_a((String)"get_players").executes(this::dummy))).then(Commands.func_197057_a((String)"show_me_cmds").executes(this::dummy));
    }

    private int dummy(CommandContext<CommandSource> ctx) {
        return 0;
    }

    public JsonObject getJSON() throws IOException {
        List<String> players_json_list = Files.readAllLines(this.silence_config_file.toPath());
        String players_json_text = "";
        for (String line : players_json_list) {
            players_json_text = players_json_text + line + "\n";
        }
        JsonParser parser = new JsonParser();
        JsonObject players_json = parser.parse(players_json_text).getAsJsonObject();
        return players_json;
    }

    public void makeJSON() throws IOException {
        if (!this.silence_config_file.exists()) {
            this.silence_config_path.mkdirs();
            this.silence_config_file.createNewFile();
            FileWriter writer = new FileWriter(this.silence_config_file);
            writer.write("{\"players\":[],\"words\":[],\"show_placeholder\":true,\"show_me_messages\":true}");
            writer.close();
        }
    }

    public void writeToJSON(JsonObject players_json) {
        if (this.silence_config_file.exists()) {
            this.silence_config_path.mkdirs();
            try {
                this.silence_config_file.createNewFile();
                FileWriter writer = new FileWriter(this.silence_config_file);
                writer.write(players_json.toString());
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addWordOrPlayerToJSON(String arg1, String arg2) throws IOException {
        JsonObject players_json = this.getJSON();
        players_json.get(arg1).getAsJsonArray().add(arg2);
        this.writeToJSON(players_json);
        this.sendPlayerAMessage("\u00a7d\u00a7lAdded: \u00a7r" + arg2);
    }

    public void removeWordOrPlayerFromJSON(String arg1, String arg2) throws IOException {
        JsonObject players_json = this.getJSON();
        for (int j = 0; j < players_json.get(arg1).getAsJsonArray().size(); ++j) {
            if (!players_json.get(arg1).getAsJsonArray().get(j).getAsString().equals(arg2)) continue;
            players_json.get(arg1).getAsJsonArray().remove(j);
        }
        this.writeToJSON(players_json);
        this.sendPlayerAMessage("\u00a7d\u00a7lRemoved: \u00a7r" + arg2);
    }

    public void sendPlayerAMessage(String message) {
        Minecraft.func_71410_x().field_71439_g.getEntity().func_145747_a((ITextComponent)new StringTextComponent(message.trim()));
    }

    public void getMutedPlayersAsString() throws IOException {
        JsonArray players_array = this.getMutedPlayers();
        String arrayAsString = "\u00a7b\u00a7lBlocked Players: \u00a7r";
        for (int i = 0; i < players_array.size(); ++i) {
            String player = players_array.get(i).getAsString();
            arrayAsString = arrayAsString + player + " ";
        }
        this.sendPlayerAMessage(arrayAsString);
    }

    public JsonArray getMutedPlayers() throws IOException {
        return this.getJSON().get("players").getAsJsonArray();
    }

    public void getBlockedWordsAsString() throws IOException {
        JsonArray words_array = this.getBlockedWords();
        String jsonObjectAsString = "\u00a7b\u00a7lBlocked Words: \u00a7r";
        for (int i = 0; i < words_array.size(); ++i) {
            JsonElement jsonObject = words_array.get(i);
            jsonObjectAsString = jsonObjectAsString + jsonObject.getAsString() + " ";
        }
        this.sendPlayerAMessage(jsonObjectAsString);
    }

    public JsonArray getBlockedWords() throws IOException {
        return this.getJSON().get("words").getAsJsonArray();
    }

    public void changePlaceholderState() throws IOException {
        JsonObject players_json;
        players_json.addProperty("show_placeholder", Boolean.valueOf(!(players_json = this.getJSON()).get("show_placeholder").getAsBoolean()));
        this.writeToJSON(players_json);
        this.sendPlayerAMessage("\u00a7b\u00a7lShow placeholders: \u00a7r" + players_json.get("show_placeholder").getAsString());
    }

    public boolean showPlaceholder() throws IOException {
        return this.getJSON().get("show_placeholder").getAsBoolean();
    }

    public void changeMeMessagesState() throws IOException {
        JsonObject players_json;
        players_json.addProperty("show_me_messages", Boolean.valueOf(!(players_json = this.getJSON()).get("show_me_messages").getAsBoolean()));
        this.writeToJSON(players_json);
        this.sendPlayerAMessage("\u00a7b\u00a7lShow /me messages: \u00a7r" + players_json.get("show_me_messages").getAsString());
    }

    public boolean showMeMessages() throws IOException {
        return this.getJSON().get("show_me_messages").getAsBoolean();
    }
}

