/*
 * Decompiled with CFR 0.152.
 */
package fr.mosca421.worldprotector.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.management.OpEntry;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class Region
implements INBTSerializable<CompoundNBT> {
    private AxisAlignedBB area;
    private Set<String> flags = new HashSet<String>();
    private String name;
    private int priority = 2;
    private int dimension;
    private String enterMessage = "";
    private String exitMessage = "";
    private String enterMessageSmall = "";
    private String exitMessageSmall = "";
    private List<String> playerList = new ArrayList<String>();

    public Region() {
    }

    public Region(String name, AxisAlignedBB area, int dimension) {
        this.name = name;
        this.area = area;
        this.dimension = dimension;
    }

    public AxisAlignedBB getArea() {
        return this.area;
    }

    public void setArea(AxisAlignedBB area) {
        this.area = area;
    }

    public Set<String> getFlags() {
        return this.flags;
    }

    public void addFlag(String flag) {
        this.flags.add(flag);
    }

    public boolean removeFlag(String flag) {
        return this.flags.remove(flag);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getEnterMessage() {
        return this.enterMessage;
    }

    public void setEnterMessage(String enterMessage) {
        this.enterMessage = enterMessage;
    }

    public String getExitMessage() {
        return this.exitMessage;
    }

    public void setExitMessage(String exitMessage) {
        this.exitMessage = exitMessage;
    }

    public String getEnterMessageSmall() {
        return this.enterMessageSmall;
    }

    public void setEnterMessageSmall(String enterMessageSmall) {
        this.enterMessageSmall = enterMessageSmall;
    }

    public String getExitMessageSmall() {
        return this.exitMessageSmall;
    }

    public void setExitMessageSmall(String exitMessageSmall) {
        this.exitMessageSmall = exitMessageSmall;
    }

    public List<String> getPlayerList() {
        return this.playerList;
    }

    public boolean isInPlayerList(PlayerEntity name) {
        if (ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152603_m().func_152683_b((Object)name.func_146103_bH()) != null && ((OpEntry)ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152603_m().func_152683_b((Object)name.func_146103_bH())).func_152644_a() == 4) {
            return true;
        }
        return this.playerList.contains(name.func_110124_au().toString());
    }

    public boolean addPlayer(String name) {
        if (!this.playerList.contains(name)) {
            this.playerList.add(name);
            return true;
        }
        return false;
    }

    public boolean removePlayer(String name) {
        if (this.playerList.contains(name)) {
            this.playerList.remove(name);
            return true;
        }
        return false;
    }

    public void setPlayerList(List<String> playerList) {
        this.playerList = playerList;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("minX", (int)this.area.field_72340_a);
        nbt.func_74768_a("minY", (int)this.area.field_72338_b);
        nbt.func_74768_a("minZ", (int)this.area.field_72339_c);
        nbt.func_74768_a("maxX", (int)this.area.field_72336_d);
        nbt.func_74768_a("maxY", (int)this.area.field_72337_e);
        nbt.func_74768_a("maxZ", (int)this.area.field_72334_f);
        nbt.func_74768_a("priority", this.priority);
        nbt.func_74768_a("dimension", this.dimension);
        nbt.func_74778_a("enterMessage", this.enterMessage);
        nbt.func_74778_a("exitMessage", this.exitMessage);
        nbt.func_74778_a("enterMessageSmall", this.enterMessageSmall);
        nbt.func_74778_a("exitMessageSmall", this.exitMessageSmall);
        ListNBT flagList = new ListNBT();
        for (String flag : this.flags) {
            flagList.add((Object)StringNBT.func_229705_a_((String)flag));
        }
        nbt.func_218657_a("flags", (INBT)flagList);
        ListNBT playerLists = new ListNBT();
        for (String player : this.playerList) {
            playerLists.add((Object)StringNBT.func_229705_a_((String)player));
        }
        nbt.func_218657_a("playerList", (INBT)flagList);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.name = nbt.func_74779_i("name");
        this.area = new AxisAlignedBB((double)nbt.func_74762_e("minX"), (double)nbt.func_74762_e("minY"), (double)nbt.func_74762_e("minZ"), (double)nbt.func_74762_e("maxX"), (double)nbt.func_74762_e("maxY"), (double)nbt.func_74762_e("maxZ"));
        this.priority = nbt.func_74762_e("priority");
        this.dimension = nbt.func_74762_e("dimension");
        this.enterMessage = nbt.func_74779_i("enterMessage");
        this.exitMessage = nbt.func_74779_i("exitMessage");
        this.enterMessageSmall = nbt.func_74779_i("enterMessageSmall");
        this.exitMessageSmall = nbt.func_74779_i("exitMessageSmall");
        ListNBT flagsList = nbt.func_150295_c("flags", 8);
        for (int i = 0; i < flagsList.size(); ++i) {
            this.flags.add(flagsList.func_150307_f(i));
        }
        ListNBT playerLists = nbt.func_150295_c("playerList", 8);
        for (int i = 0; i < playerLists.size(); ++i) {
            this.playerList.add(playerLists.func_150307_f(i));
        }
    }
}

