/*
 * Decompiled with CFR 0.152.
 */
package fr.mosca421.worldprotector.events;

import fr.mosca421.worldprotector.core.Region;
import fr.mosca421.worldprotector.utils.FlagsUtils;
import fr.mosca421.worldprotector.utils.RegionsUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="worldprotector")
public class EventPlayers {
    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        if (event.getTarget() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getTarget();
            int dim = event.getPlayer().field_70170_p.func_201675_m().func_186058_p().func_186068_a();
            for (Region region : RegionsUtils.getHandlingRegionsFor(player.func_180425_c(), dim)) {
                if (!region.getFlags().contains("damage-players") || !FlagsUtils.isOp((PlayerEntity)player)) continue;
                event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("world.pvp.player", new Object[0]));
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onPickupItem(PlayerEvent.ItemPickupEvent event) {
        int dim = event.getPlayer().field_70170_p.func_201675_m().func_186058_p().func_186068_a();
        for (Region region : RegionsUtils.getHandlingRegionsFor(event.getPlayer().func_180425_c(), dim)) {
            if (!region.getFlags().contains("pickup-item") || region.isInPlayerList(event.getPlayer())) continue;
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("world.pickup.player", new Object[0]));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            int dim = player.field_70170_p.func_201675_m().func_186058_p().func_186068_a();
            for (Region region : RegionsUtils.getHandlingRegionsFor(player.func_180425_c(), dim)) {
                if (!region.getFlags().contains("invincible")) continue;
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            int dim = player.field_70170_p.func_201675_m().func_186058_p().func_186068_a();
            for (Region region : RegionsUtils.getHandlingRegionsFor(player.func_180425_c(), dim)) {
                if (!region.getFlags().contains("fall-damage")) continue;
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onSendChat(ServerChatEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = event.getPlayer();
            int dim = event.getPlayer().field_70170_p.func_201675_m().func_186058_p().func_186068_a();
            for (Region region : RegionsUtils.getHandlingRegionsFor(player.func_180425_c(), dim)) {
                if (!region.getFlags().contains("send-chat") || region.isInPlayerList((PlayerEntity)event.getPlayer())) continue;
                event.setCanceled(true);
                event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("world.speak.player", new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public static void playerDropItem(ItemTossEvent event) {
        int dim = event.getPlayer().field_70170_p.func_201675_m().func_186058_p().func_186068_a();
        for (Region region : RegionsUtils.getHandlingRegionsFor(event.getPlayer().func_180425_c(), dim)) {
            if (!region.getFlags().contains("item-drop") || region.isInPlayerList(event.getPlayer())) continue;
            event.setCanceled(true);
            event.getPlayer().field_71071_by.func_70441_a(event.getEntityItem().func_92059_d());
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("world.drop.player", new Object[0]));
        }
    }
}

