/*
 * Decompiled with CFR 0.152.
 */
package fr.mosca421.worldprotector.events;

import fr.mosca421.worldprotector.core.Region;
import fr.mosca421.worldprotector.utils.RegionsUtils;
import java.util.Iterator;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="worldprotector")
public class EventProtection {
    @SubscribeEvent
    public static void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        int dim = event.getWorld().func_201675_m().func_186058_p().func_186068_a();
        for (Region region : RegionsUtils.getHandlingRegionsFor(event.getPos(), dim)) {
            if (!region.getFlags().contains("break") || region.isInPlayerList(event.getPlayer())) continue;
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("world.protection.break", new Object[0]));
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onPlayerPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        int dim = event.getWorld().func_201675_m().func_186058_p().func_186068_a();
        for (Region region : RegionsUtils.getHandlingRegionsFor(event.getPos(), dim)) {
            if (!region.getFlags().contains("place")) continue;
            if (event.getEntity() instanceof PlayerEntity) {
                if (region.isInPlayerList((PlayerEntity)event.getEntity())) continue;
                ((PlayerEntity)event.getEntity()).func_145747_a((ITextComponent)new TranslationTextComponent("world.protection.place", new Object[0]));
                event.setCanceled(true);
                return;
            }
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        BlockPos pos;
        Iterator it = event.getAffectedBlocks().iterator();
        block0: while (it.hasNext()) {
            pos = (BlockPos)it.next();
            for (Region region : RegionsUtils.getHandlingRegionsFor(pos, event.getWorld().func_201675_m().func_186058_p().func_186068_a())) {
                if (!region.getFlags().contains("explosions")) continue;
                it.remove();
                continue block0;
            }
        }
        it = event.getAffectedBlocks().iterator();
        if (!(event.getExplosion().func_94613_c() instanceof CreeperEntity)) {
            block2: while (it.hasNext()) {
                pos = (BlockPos)it.next();
                for (Region region : RegionsUtils.getHandlingRegionsFor(pos, event.getWorld().func_201675_m().func_186058_p().func_186068_a())) {
                    if (!region.getFlags().contains("other-explosions")) continue;
                    it.remove();
                    continue block2;
                }
            }
        }
        it = event.getAffectedBlocks().iterator();
        if (event.getExplosion().func_94613_c() instanceof CreeperEntity) {
            block4: while (it.hasNext()) {
                pos = (BlockPos)it.next();
                for (Region region : RegionsUtils.getHandlingRegionsFor(pos, event.getWorld().func_201675_m().func_186058_p().func_186068_a())) {
                    if (!region.getFlags().contains("creeper-explosions")) continue;
                    it.remove();
                    continue block4;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBucketFill(FillBucketEvent event) {
        int dim = event.getWorld().func_201675_m().func_186058_p().func_186068_a();
        if (event.getTarget() != null) {
            for (Region region : RegionsUtils.getHandlingRegionsFor(new BlockPos(event.getTarget().func_216347_e()), dim)) {
                if (!region.getFlags().contains("place") || region.isInPlayerList(event.getPlayer())) continue;
                event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("world.protection.place", new Object[0]));
                event.setCanceled(true);
                return;
            }
        }
    }
}

