/*
 * Decompiled with CFR 0.152.
 */
package fr.mosca421.worldprotector.utils;

import com.google.common.base.Joiner;
import fr.mosca421.worldprotector.core.Region;
import fr.mosca421.worldprotector.core.Saver;
import fr.mosca421.worldprotector.items.RegionStick;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class RegionsUtils {
    public static void teleportRegion(String regions, ServerPlayerEntity player) {
        if (Saver.REGIONS.containsKey(regions)) {
            Region region = Saver.REGIONS.get(regions);
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.teleport", new Object[]{regions}));
            player.func_70634_a(region.getArea().field_72340_a, 200.0, region.getArea().field_72339_c);
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.unknown", new Object[]{regions}));
        }
    }

    public static void addPlayer(String regions, ServerPlayerEntity player, String name) {
        if (Saver.REGIONS.containsKey(regions)) {
            Region region = Saver.REGIONS.get(regions);
            if (!region.addPlayer(name)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.errorplayer", new Object[0]));
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.addplayer", new Object[0]));
            Saver.save();
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.unknown", new Object[]{regions}));
        }
    }

    public static void removePlayer(String regions, ServerPlayerEntity player, String name) {
        if (Saver.REGIONS.containsKey(regions)) {
            Region region = Saver.REGIONS.get(regions);
            if (!region.removePlayer(name)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.unknownplayer", new Object[0]));
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.removeplayer", new Object[0]));
            Saver.save();
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.unknown", new Object[]{regions}));
        }
    }

    public static void removeRegion(String regions, ServerPlayerEntity player) {
        if (Saver.REGIONS.remove(regions) != null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.remove", new Object[]{regions}));
            Saver.save();
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.unknown", new Object[]{regions}));
        }
    }

    public static void createRegion(String regionName, ServerPlayerEntity player, ItemStack item) {
        if (item.func_77973_b() instanceof RegionStick) {
            if (item.func_77942_o()) {
                if (item.func_77978_p().func_74767_n("valide")) {
                    AxisAlignedBB regions = new AxisAlignedBB((double)item.func_77978_p().func_74762_e("x1"), (double)item.func_77978_p().func_74762_e("y1"), (double)item.func_77978_p().func_74762_e("z1"), (double)item.func_77978_p().func_74762_e("x2"), (double)item.func_77978_p().func_74762_e("y2"), (double)item.func_77978_p().func_74762_e("z2")).func_186662_g(1.0);
                    Region region = new Region(regionName, regions, player.field_70170_p.func_201675_m().func_186058_p().func_186068_a());
                    Saver.addRegion(region);
                    Saver.save();
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.define", new Object[]{regionName}));
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.itemhand.choose", new Object[0]));
                }
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.itemhand.choose", new Object[0]));
            }
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.itemhand.take", new Object[0]));
        }
    }

    public static void giveHelpMessage(ServerPlayerEntity player) {
        player.func_145747_a((ITextComponent)new TranslationTextComponent("", new Object[0]));
        player.func_145747_a((ITextComponent)new TranslationTextComponent(TextFormatting.BLUE + "==WorldProtector Help==", new Object[0]));
        player.func_145747_a((ITextComponent)new TranslationTextComponent("help.region.1", new Object[0]));
        player.func_145747_a((ITextComponent)new TranslationTextComponent("help.region.2", new Object[0]));
        player.func_145747_a((ITextComponent)new TranslationTextComponent("help.region.3", new Object[0]));
        player.func_145747_a((ITextComponent)new TranslationTextComponent("help.region.4", new Object[0]));
        player.func_145747_a((ITextComponent)new TranslationTextComponent("help.region.5", new Object[0]));
        player.func_145747_a((ITextComponent)new TranslationTextComponent("help.region.6", new Object[0]));
        player.func_145747_a((ITextComponent)new TranslationTextComponent("help.region.7", new Object[0]));
        player.func_145747_a((ITextComponent)new TranslationTextComponent("help.region.8", new Object[0]));
        player.func_145747_a((ITextComponent)new TranslationTextComponent("help.region.9", new Object[0]));
        player.func_145747_a((ITextComponent)new TranslationTextComponent(TextFormatting.BLUE + "==WorldProtector Help==", new Object[0]));
    }

    public static void giveRegionList(ServerPlayerEntity player) {
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.DARK_RED + "Region : " + Joiner.on((String)", ").join(Saver.REGIONS.keySet())));
    }

    public static void redefineRegion(String regionName, ServerPlayerEntity player, ItemStack item) {
        if (item.func_77973_b() instanceof RegionStick) {
            if (item.func_77942_o()) {
                if (item.func_77978_p().func_74767_n("valide")) {
                    AxisAlignedBB regions = new AxisAlignedBB((double)item.func_77978_p().func_74762_e("x1"), (double)item.func_77978_p().func_74762_e("y1"), (double)item.func_77978_p().func_74762_e("z1"), (double)item.func_77978_p().func_74762_e("x2"), (double)item.func_77978_p().func_74762_e("y2"), (double)item.func_77978_p().func_74762_e("z2")).func_186662_g(1.0);
                    Region region = new Region(regionName, regions, player.field_70170_p.func_201675_m().func_186058_p().func_186068_a());
                    if (Saver.REGIONS.containsKey(regionName)) {
                        Region oldRegion = Saver.REGIONS.get(regionName);
                        for (String st : oldRegion.getFlags()) {
                            region.addFlag(st);
                        }
                        Saver.REGIONS.remove(regionName);
                        Saver.addRegion(region);
                        Saver.save();
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.redefine", new Object[]{regionName}));
                    } else {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.unknown", new Object[]{regionName}));
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.itemhand.choose", new Object[0]));
                }
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.itemhand.choose", new Object[0]));
            }
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.itemhand.take", new Object[0]));
        }
    }

    public static List<Region> getHandlingRegionsFor(BlockPos position, int dimension) {
        int maxPriority = 1;
        ArrayList<Region> handlers = new ArrayList<Region>();
        for (Region region : Saver.REGIONS.values()) {
            if (region.getDimension() != dimension || !region.getArea().func_72318_a(new Vec3d((Vec3i)position))) continue;
            if (region.getPriority() == maxPriority) {
                handlers.add(region);
                continue;
            }
            if (region.getPriority() <= maxPriority) continue;
            handlers.clear();
            maxPriority = region.getPriority();
            handlers.add(region);
        }
        return handlers;
    }

    public static void setPriorityRegion(String regionName, int priority, ServerPlayerEntity player) {
        if (Saver.REGIONS.containsKey(regionName)) {
            Region region = Saver.REGIONS.get(regionName);
            if (priority >= 1) {
                region.setPriority(priority);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.setpriority", new Object[]{priority, regionName}));
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.priority", new Object[0]));
            }
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.unknown", new Object[]{regionName}));
        }
    }

    public static void getPriority(String regionName, ServerPlayerEntity player) {
        if (Saver.REGIONS.containsKey(regionName)) {
            Region region = Saver.REGIONS.get(regionName);
            String priority = "" + region.getPriority();
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.infopriority", new Object[]{regionName, priority}));
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.region.unknown", new Object[]{regionName}));
        }
    }

    public static boolean isInRegion(String regionName, ServerPlayerEntity player) {
        if (Saver.REGIONS.containsKey(regionName)) {
            Region region = Saver.REGIONS.get(regionName);
            return region.isInPlayerList((PlayerEntity)player);
        }
        return false;
    }
}

