/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.config;

import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfiguration {
    public final ForgeConfigSpec.IntValue goalSelectorTickRate;
    public final ForgeConfigSpec.IntValue logintimeout;
    public final ForgeConfigSpec.IntValue disconnectTimeout;
    public final ForgeConfigSpec.BooleanValue optimizeTempt;
    public final ForgeConfigSpec.BooleanValue optimizeAvoid;
    public final ForgeConfigSpec.BooleanValue TELoadBalancing;
    public final ForgeConfigSpec.BooleanValue eventLoadBalancing;
    public final ForgeConfigSpec.BooleanValue optimizeHurtByTarget;
    public final ForgeConfigSpec.BooleanValue fastChunkBlocks;
    public final ForgeConfigSpec.BooleanValue optimizePanic;
    public final ForgeConfigSpec.BooleanValue optimizeBreed;
    public final ForgeConfigSpec.BooleanValue disableConfigReload;
    public final ForgeConfigSpec.BooleanValue betterFps;
    public final ForgeConfigSpec.BooleanValue TEUnloadLag;
    public final ForgeConfigSpec.BooleanValue fastCollisions;
    public final ForgeConfigSpec.BooleanValue fastPathFind;
    public final ForgeConfigSpec.BooleanValue fastSpawnRadius;
    public final ForgeConfigSpec.BooleanValue cacheRecipes;
    public final ForgeConfigSpec.BooleanValue noLagItemPickup;
    public final ForgeConfigSpec.BooleanValue fastItems;
    public final ForgeConfigSpec.BooleanValue fixLeash;
    public final ForgeConfigSpec.BooleanValue slowFindShelter;
    public final ForgeConfigSpec.BooleanValue multiEntities;
    public final ForgeConfigSpec.BooleanValue fixBlockBreakGoal;
    public final ForgeConfigSpec.BooleanValue debugChunkLoading;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> forbiddenMobs;
    public final ForgeConfigSpec.BooleanValue AILoadBalancing;
    public final ForgeConfigSpec.BooleanValue TEDebugOutput;
    public final ForgeConfigSpec.BooleanValue eventDebugOutput;
    public final ForgeConfigSpec.BooleanValue logEntityAILag;
    public final ForgeConfigSpec.BooleanValue fastInventoryAdvancement;
    public final ForgeConfigSpec.BooleanValue printWorldSaves;
    public final ForgeConfigSpec.BooleanValue fastChunkSave;
    public final ForgeConfigSpec.IntValue meanTickAITH;
    public final ForgeConfigSpec.IntValue meanTickTH;
    public final ForgeConfigSpec.IntValue meanTickEvent;
    public final ForgeConfigSpec ForgeConfigSpecBuilder;

    public CommonConfiguration(ForgeConfigSpec.Builder builder) {
        builder.push("Load balancing settings");
        builder.comment(new String[]{" Load balancing is a mechanic which profiles and throttles down lagging entities, tileentities and event subscribers.", " It is used to prevent a certain laggy mob or block from lagging out the whole game. Since this is rather invasive and may cause the lagging", " entity/block to not work nicely it is only done once the game goes over the configured lagging threshold.", " Those thresholds as set in miliseconds, anything below 50ms is 20 TPS (1s = 1000ms, 1000 / 50 = 20).", " Above 50ms ticks is where your game starts to lag, as it hits 100% cpu and starts skipping ticks.", " This is where load balancing comes in and reduces the lag caused by specific entities and blocks.", " If you run into trouble with some of the entities or blocks not working correctly you can disable it here", ""});
        builder.push("Entity AI Load balancing settings");
        builder.comment("Enables load balancing for entity AI. default = true");
        this.AILoadBalancing = builder.define("AILoadBalancing", true);
        builder.comment("Mean tick time at which AI load balancing takes effect, 1000 / mean tick time = TPS. default: 55");
        this.meanTickAITH = builder.defineInRange("meanTickAITH", 55, 1, 200);
        builder.comment("Whether to debug lagging entities and log offenders, requires load balancing to be enabled. default = true");
        this.logEntityAILag = builder.define("logEntityAILag", true);
        builder.pop();
        builder.push("Tile entities load balancing settings");
        builder.comment("Enables Tile entity load balancing. default: true");
        this.TELoadBalancing = builder.define("TELoadBalancing", true);
        builder.comment("Mean tick time at which load balancing takes effect, 1000 / mean tick time = TPS. default: 55");
        this.meanTickTH = builder.defineInRange("meanTickTH", 55, 1, 200);
        builder.comment("Enables debug log output for lagging tile entities, default = false");
        this.TEDebugOutput = builder.define("TEDebugOutput", false);
        builder.comment("Requires TELoadBalancing = true. Enables dealing with lag caused by tile entities during chunk unload. This is normally not needed. default = false");
        this.TEUnloadLag = builder.define("TEUnloadLag", false);
        builder.pop();
        builder.push("Event load balancing settings");
        builder.comment("Enables event load balancing, this is mostly stuff which is happening outside entityAI/Tile entities. default: true");
        this.eventLoadBalancing = builder.define("eventLoadBalancing", true);
        builder.comment("Mean tick time at which event load balancing takes effect, 1000 / mean tick time = TPS. default: 55");
        this.meanTickEvent = builder.defineInRange("meanTickEvent", 55, 1, 200);
        builder.comment("Enables debug log output for lagging event subscribers, default = false");
        this.eventDebugOutput = builder.define("eventDebugOutput", false);
        builder.pop();
        builder.pop();
        builder.push("Entity settings");
        builder.comment("This section is about specific settings and fixes for entities");
        builder.comment("Fix leash lag from entities on a leash, default = true");
        this.fixLeash = builder.define("fixLeash", true);
        builder.comment("Enables improved entity collision and movement calculations for items, default = true");
        this.fastItems = builder.define("fastItems", true);
        builder.comment("Enables improved entity collision and movement calculations for any non item entity, default = true");
        this.fastCollisions = builder.define("fastCollisions", true);
        builder.comment("Enables less laggy entity item pickup, default = true");
        this.noLagItemPickup = builder.define("noLagItemPickup", true);
        builder.comment("Enable faster pathfinding, default = true");
        this.fastPathFind = builder.define("fastPathFinding", true);
        builder.comment("Enable fast inventory advancement triggers, many advancements based on items tend to lag the players, default = true");
        this.fastInventoryAdvancement = builder.define("fastInventoryAdvancement", true);
        builder.comment("Enable multithreading support for entities, requires fastCollisions to be enabled. default = true");
        this.multiEntities = builder.define("multiEntities", true);
        builder.pop();
        builder.push("Entity AI Settings");
        builder.comment("This section is about specific settings and tickrates for AI goals. Ticks happen 20 times a second when at 20 TPS.");
        builder.comment("Sets the tick interval in which non-running AI tasks are rechecked. Vanilla default is 1(starting with 1.13+), this mods suggested default is 4(as it was in 1.12)");
        this.goalSelectorTickRate = builder.defineInRange("goalselectorrate", 4, 1, 500);
        builder.comment("Enables a slower updated AI tempt goal, tempt is used e.g. for luring sheep with wheat. default = true");
        this.optimizeTempt = builder.define("optimizeTempt", true);
        builder.comment("Enables a slower updated AI avoid entity goal, avoid is used e.g. for villagers avoiding zombies so it constantly searches for mobs in the area. default = true");
        this.optimizeAvoid = builder.define("optimizeAvoid", true);
        builder.comment("Enables a modified/fixed HurtByTarget goal which is used to call other entities for help. default = true");
        this.optimizeHurtByTarget = builder.define("optimizeHurtByTarget", true);
        builder.comment("Enables a slower updated AI Panic entity goal, panic is used for chickens/other animals running away e.g. on fire. default = true");
        this.optimizePanic = builder.define("optimizePanic", true);
        builder.comment("Enables a slower updated AI Breed entity goal, breed is used for searching nearby similar animals and doesnt have to be checked that often. default = true");
        this.optimizeBreed = builder.define("optimizeBreed", true);
        builder.comment("Enables a slower updated AI Fox find shelter goal, which causes too much load. default = true");
        this.slowFindShelter = builder.define("slowFindShelter", true);
        builder.comment("Fix chunkloading and lag caused by the block break goal, mostly used by zombies or endermen. default = true");
        this.fixBlockBreakGoal = builder.define("fixBlockBreakGoal", true);
        builder.pop();
        builder.push("General performance improvements settings");
        builder.comment("Enable FPS improvements, default = true");
        this.betterFps = builder.define("betterFps", true);
        builder.comment("Reduces crafting lag by caching recipe lookups, helps a lot with autocrafting/crafting related lag. default = true");
        this.cacheRecipes = builder.define("cacheRecipes", true);
        builder.comment("Enable fast spawn radius check, this makes entity spawn mechanics lag less. default = true");
        this.fastSpawnRadius = builder.define("fastSpawnRadius", true);
        builder.comment("Enable fast chunk block ticks, reduces lag on random block ticks in the world but keeps the same growth e.g. on crops. default = true");
        this.fastChunkBlocks = builder.define("fastChunkBlocks", true);
        builder.comment("Enable fast chunk save, unmodified chunks are saved a lot faster and cause less lag when saving to disk. default = true");
        this.fastChunkSave = builder.define("fastChunkSave", true);
        builder.pop();
        builder.push("Utility settings, debugging and other");
        builder.comment("List of mobs disallowed from spawning: e.g. format :  [\"minecraft:zombie\", \"minecraft:creeper\"]");
        this.forbiddenMobs = builder.defineList("forbiddenMobs", Collections.emptyList(), e -> e instanceof String);
        builder.comment("Set the max login timeout during connection in ticks. 20 ticks = 1 sec, default = 120 seconds");
        this.logintimeout = builder.defineInRange("logintimeout", 2400, 600, 20000);
        builder.comment("Set the ingame disconnect timeout for disconnecting players. Default = 60sec");
        this.disconnectTimeout = builder.defineInRange("disconnectTimeout", 60, 15, 400);
        builder.comment("Disables the config reload during the game, can cause performance issues on some linux systems, default = false");
        this.disableConfigReload = builder.define("disableConfigReload", false);
        builder.comment("Enable printing of world/chunk saves for debugging purposes, those normally happen every 5minutes. default = false");
        this.printWorldSaves = builder.define("printWorldSaves", false);
        builder.comment("Enable printing of chunk loading for debugging purposes, default = false");
        this.debugChunkLoading = builder.define("debugChunkLoading", false);
        builder.pop();
        this.ForgeConfigSpecBuilder = builder.build();
    }
}

