/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.event;

import com.electronwill.nightconfig.core.file.FileWatcher;
import com.mojang.brigadier.CommandDispatcher;
import com.performant.coremod.Performant;
import com.performant.coremod.commands.EntryPoint;
import com.performant.coremod.config.ConfigurationCache;
import com.performant.coremod.entity.ai.CustomGoalSelector;
import com.performant.coremod.entity.threading.ActionThread;
import com.performant.coremod.entity.threading.MoveThread;
import com.performant.coremod.world.IServerChunkProviderThreadsUnloadChunk;
import java.io.IOException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.MobEntity;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ForgeBusEventHandler {
    private static int serverTickTimer = 0;
    private static int meanTickCount = 0;
    private static double meanTickSum = 1.0;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityAdded(@NotNull EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K) {
            String registryName = event.getEntity().func_200600_R().getRegistryName().toString();
            if (!registryName.isEmpty() && ConfigurationCache.forbiddenMobs.contains(registryName)) {
                event.setCanceled(true);
                event.getEntity().func_70106_y();
                return;
            }
            if (event.getEntity() instanceof MobEntity) {
                MobEntity mob = (MobEntity)event.getEntity();
                mob.field_70715_bh = new CustomGoalSelector(mob.field_70715_bh, mob);
                mob.field_70714_bg = new CustomGoalSelector(mob.field_70714_bg, mob);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        ConfigurationCache.chunkDirtyCount = 0;
        if (++serverTickTimer == 20) {
            meanTickSum += (double)ForgeBusEventHandler.average(ServerLifecycleHooks.getCurrentServer().field_71311_j) * 1.0E-6;
            if (++meanTickCount >= 30) {
                ConfigurationCache.CURRENT_MEAN_TICK_TIME = meanTickSum / (double)meanTickCount;
                ConfigurationCache.TPS = 1000.0 / ConfigurationCache.CURRENT_MEAN_TICK_TIME;
                meanTickCount = 0;
                meanTickSum = 1.0;
            }
            serverTickTimer = 0;
        }
    }

    private static long average(long[] values) {
        if (values == null || values.length == 0) {
            return 0L;
        }
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        EntryPoint.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent
    public static void onServerStarted(FMLServerStartedEvent event) {
        for (int i = 0; i < 4; ++i) {
            new MoveThread();
        }
        MoveThread.running = true;
        new ActionThread();
        ActionThread.running = true;
        if (((Boolean)Performant.getConfig().getCommon().disableConfigReload.get()).booleanValue()) {
            try {
                FileWatcher.defaultInstance().stop();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        AbstractChunkProvider provider;
        if (!event.getWorld().func_201670_d() && (provider = event.getWorld().func_72863_F()) instanceof IServerChunkProviderThreadsUnloadChunk) {
            ((IServerChunkProviderThreadsUnloadChunk)provider).onChunkUnloadClean(event.getChunk().func_76632_l().func_201841_a());
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(FMLServerStoppingEvent event) {
        MoveThread.running = false;
        ActionThread.running = false;
    }
}

