/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.restrictions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.api.restrictions.Type;
import jeresources.util.BiomeHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeRestriction {
    public static final BiomeRestriction NONE = new BiomeRestriction();
    public static final BiomeRestriction OCEAN = new BiomeRestriction(BiomeDictionary.Type.OCEAN, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction PLAINS = new BiomeRestriction(BiomeDictionary.Type.PLAINS, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction FOREST = new BiomeRestriction(BiomeDictionary.Type.FOREST, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction SANDY = new BiomeRestriction(BiomeDictionary.Type.FOREST, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction SNOWY = new BiomeRestriction(BiomeDictionary.Type.FOREST, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction HILLS = new BiomeRestriction(BiomeDictionary.Type.HILLS, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction MUSHROOM = new BiomeRestriction(BiomeDictionary.Type.MUSHROOM, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction BADLANDS = new BiomeRestriction(BiomeDictionary.Type.MESA, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction HOT = new BiomeRestriction(BiomeDictionary.Type.HOT, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction COLD = new BiomeRestriction(BiomeDictionary.Type.COLD, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction TEMPERATE = new BiomeRestriction(Type.BLACKLIST, BiomeDictionary.Type.HOT, BiomeDictionary.Type.COLD);
    public static final BiomeRestriction EXTREME_HILLS = new BiomeRestriction(Type.WHITELIST, (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("minecraft:mountains")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("minecraft:mountain_edge")));
    private List<Biome> biomes = new ArrayList<Biome>();
    private Type type;

    public BiomeRestriction() {
        this.type = Type.NONE;
    }

    public BiomeRestriction(Biome biome) {
        this(Type.WHITELIST, biome);
    }

    public BiomeRestriction(Type type, Biome biome) {
        this(type, biome, new Biome[0]);
    }

    public BiomeRestriction(Biome biome, Biome ... moreBiomes) {
        this(Type.WHITELIST, biome, moreBiomes);
    }

    public BiomeRestriction(Type type, Biome biome, Biome ... moreBiomes) {
        this.type = type;
        switch (type) {
            case NONE: {
                break;
            }
            case WHITELIST: {
                this.biomes.add(biome);
                this.biomes.addAll(Arrays.asList(moreBiomes));
                break;
            }
            default: {
                this.biomes = BiomeHelper.getAllBiomes();
                this.biomes.remove(biome);
                this.biomes.removeAll(Arrays.asList(moreBiomes));
            }
        }
    }

    public BiomeRestriction(BiomeDictionary.Type type, BiomeDictionary.Type ... biomeTypes) {
        this(Type.WHITELIST, type, biomeTypes);
    }

    public BiomeRestriction(Type type, BiomeDictionary.Type biomeType, BiomeDictionary.Type ... biomeTypes) {
        this.type = type;
        switch (type) {
            case NONE: {
                break;
            }
            case WHITELIST: {
                this.biomes = this.getBiomes(biomeType, biomeTypes);
                break;
            }
            default: {
                this.biomes = BiomeHelper.getAllBiomes();
                this.biomes.removeAll(this.getBiomes(biomeType, biomeTypes));
            }
        }
    }

    private ArrayList<Biome> getBiomes(BiomeDictionary.Type biomeType, BiomeDictionary.Type ... biomeTypes) {
        ArrayList<Object> biomes = new ArrayList<Biome>();
        biomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeType));
        for (int i = 1; i < biomeTypes.length; ++i) {
            ArrayList<Biome> newBiomes = new ArrayList<Biome>();
            for (Biome biome : BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeTypes[i])) {
                if (!biomes.remove(biome)) continue;
                newBiomes.add(biome);
            }
            biomes = newBiomes;
        }
        return biomes;
    }

    public List<String> toStringList() {
        return this.biomes.stream().filter(biome -> !biome.func_205403_k().getString().equals("")).map(biome -> "  " + biome.func_205403_k().getString()).collect(Collectors.toList());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiomeRestriction) {
            BiomeRestriction other = (BiomeRestriction)obj;
            return other.biomes.size() == this.biomes.size() && other.biomes.containsAll(this.biomes);
        }
        return false;
    }

    public boolean isMergeAble(BiomeRestriction other) {
        return other.type == Type.NONE || this.type != Type.NONE && !this.biomes.isEmpty() && other.biomes.containsAll(this.biomes);
    }

    public String toString() {
        return "Biomes: " + (Object)((Object)this.type) + (this.type != Type.NONE ? " - " + this.biomes.size() : "");
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.biomes.hashCode();
    }
}

