/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import jeresources.api.render.ColorHelper;
import jeresources.api.render.IMobRenderHook;
import jeresources.api.render.IScissorHook;
import jeresources.compatibility.MobRegistryImpl;
import jeresources.reference.Resources;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static void drawArrow(double xBegin, double yBegin, double xEnd, double yEnd, int color) {
        double scale = RenderHelper.getGuiScaleFactor();
        ColorHelper.setColor3f(color);
        GL11.glLineWidth((float)((float)(scale * (double)1.3f)));
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)xBegin, (double)yBegin);
        GL11.glVertex2d((double)xEnd, (double)yEnd);
        GL11.glEnd();
        double angle = Math.atan2(yEnd - yBegin, xEnd - xBegin) * 180.0 / Math.PI;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)xEnd, (double)yEnd, (double)0.0);
        RenderSystem.rotatef((float)((float)angle), (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.scaled((double)scale, (double)scale, (double)1.0);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)3.0, (double)0.0);
        GL11.glVertex2d((double)0.0, (double)-1.5);
        GL11.glVertex2d((double)0.0, (double)1.5);
        GL11.glEnd();
        RenderSystem.popMatrix();
    }

    public static void drawLine(double xBegin, double yBegin, double xEnd, double yEnd, int color) {
        ColorHelper.setColor3f(color);
        GL11.glLineWidth((float)((float)(RenderHelper.getGuiScaleFactor() * (double)1.3f)));
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)xBegin, (double)yBegin);
        GL11.glVertex2d((double)xEnd, (double)yEnd);
        GL11.glEnd();
    }

    public static void drawPoint(double x, double y, int color) {
        ColorHelper.setColor3f(color);
        GL11.glPointSize((float)((float)(Minecraft.func_71410_x().func_228018_at_().func_198100_s() * (double)1.3f)));
        GL11.glBegin((int)0);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glEnd();
    }

    public static void renderEntity(int x, int y, double scale, double yaw, double pitch, LivingEntity livingEntity) {
        if (livingEntity.field_70170_p == null) {
            livingEntity.field_70170_p = Minecraft.func_71410_x().field_71441_e;
        }
        RenderSystem.enableColorMaterial();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)50.0f);
        RenderSystem.scaled((double)(-scale), (double)scale, (double)scale);
        RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float renderYawOffset = livingEntity.field_70761_aq;
        float rotationYaw = livingEntity.field_70177_z;
        float rotationPitch = livingEntity.field_70125_A;
        float prevRotationYawHead = livingEntity.field_70758_at;
        float rotationYawHead = livingEntity.field_70759_as;
        net.minecraft.client.renderer.RenderHelper.func_227783_c_();
        IMobRenderHook.RenderInfo renderInfo = MobRegistryImpl.applyRenderHooks(livingEntity, new IMobRenderHook.RenderInfo(x, y, scale, yaw, pitch));
        x = renderInfo.x;
        y = renderInfo.y;
        scale = renderInfo.scale;
        yaw = renderInfo.yaw;
        pitch = renderInfo.pitch;
        RenderSystem.rotatef((float)(-((float)Math.atan(pitch / 40.0)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        livingEntity.field_70761_aq = (float)Math.atan(yaw / 40.0) * 20.0f;
        livingEntity.field_70177_z = (float)Math.atan(yaw / 40.0) * 40.0f;
        livingEntity.field_70125_A = -((float)Math.atan(pitch / 40.0)) * 20.0f;
        livingEntity.field_70759_as = livingEntity.field_70177_z;
        livingEntity.field_70758_at = livingEntity.field_70177_z;
        RenderSystem.translated((double)0.0, (double)livingEntity.func_70033_W(), (double)0.0);
        livingEntity.field_70761_aq = renderYawOffset;
        livingEntity.field_70177_z = rotationYaw;
        livingEntity.field_70125_A = rotationPitch;
        livingEntity.field_70758_at = prevRotationYawHead;
        livingEntity.field_70759_as = rotationYawHead;
        RenderSystem.popMatrix();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        RenderSystem.disableRescaleNormal();
        RenderSystem.activeTexture((int)33985);
        RenderSystem.disableTexture();
        RenderSystem.activeTexture((int)33984);
    }

    public static void renderChest(float x, float y, float rotate, float scale, float lidAngle) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Resources.Vanilla.CHEST);
        RenderSystem.pushMatrix();
        RenderSystem.enableRescaleNormal();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)x, (float)y, (float)50.0f);
        RenderSystem.rotatef((float)-160.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.scalef((float)scale, (float)(-scale), (float)(-scale));
        RenderSystem.translatef((float)0.5f, (float)0.5f, (float)0.5f);
        RenderSystem.rotatef((float)rotate, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float lidAngleF = lidAngle / 180.0f;
        lidAngleF = 1.0f - lidAngleF;
        lidAngleF = 1.0f - lidAngleF * lidAngleF * lidAngleF;
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    public static void renderBlock(BlockState block, float x, float y, float z, float rotate, float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderSystem.enableRescaleNormal();
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(new Quaternion(-30.0f, 0.0f, 1.0f, 0.0f));
        net.minecraft.client.renderer.RenderHelper.func_227783_c_();
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, (double)(50.0f + z));
        matrixStack.func_227863_a_(new Quaternion(20.0f, 1.0f, 0.0f, 0.0f));
        matrixStack.func_227862_a_(scale *= 50.0f, -scale, -scale);
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(new Quaternion(rotate, 0.0f, 1.0f, 0.0f));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        mc.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        matrixStack.func_227865_b_();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        RenderSystem.disableRescaleNormal();
    }

    public static void scissor(int x, int y, int w, int h) {
        double scale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        double[] xyzTranslation = RenderHelper.getGLTranslation(scale);
        x = (int)((double)x * scale);
        y = (int)((double)y * scale);
        w = (int)((double)w * scale);
        h = (int)((double)h * scale);
        int scissorX = Math.round(Math.round(xyzTranslation[0] + (double)x));
        int scissorY = Math.round(Math.round((double)(Minecraft.func_71410_x().func_228018_at_().func_198083_n() - y - h) - xyzTranslation[1]));
        int scissorW = Math.round(w);
        int scissorH = Math.round(h);
        IScissorHook.ScissorInfo scissorInfo = MobRegistryImpl.applyScissorHooks(new IScissorHook.ScissorInfo(scissorX, scissorY, scissorW, scissorH));
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scissorInfo.x, (int)scissorInfo.y, (int)scissorInfo.width, (int)scissorInfo.height);
    }

    public static void stopScissor() {
        GL11.glDisable((int)3089);
    }

    public static void drawTexture(int x, int y, int u, int v, int width, int height, ResourceLocation resource) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        GuiUtils.drawTexturedModalRect((int)x, (int)y, (int)u, (int)v, (int)width, (int)height, (float)0.0f);
    }

    private static EntityRendererManager getRenderManager() {
        return Minecraft.func_71410_x().func_175598_ae();
    }

    public static double[] getGLTranslation(double scale) {
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloatv((int)2982, (FloatBuffer)buf);
        return new double[]{(double)buf.get(RenderHelper.getIndexFloatBuffer(0, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(1, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(2, 3)) * scale};
    }

    private static int getIndexFloatBuffer(int x, int y) {
        return x * 4 + y;
    }

    public static double getGuiScaleFactor() {
        return Minecraft.func_71410_x().func_228018_at_().func_198100_s();
    }
}

