/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.dungeonsarise;

import java.util.function.Supplier;
import net.aurelj.dungeonsarise.DungeonsAriseMod;
import net.aurelj.dungeonsarise.DungeonsAriseModElements;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class DungeonsAriseModVariables {
    public DungeonsAriseModVariables(DungeonsAriseModElements elements) {
        elements.addNetworkMessage(WorldSavedDataSyncMessage.class, WorldSavedDataSyncMessage::buffer, WorldSavedDataSyncMessage::new, WorldSavedDataSyncMessage::handler);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            MapVariables mapdata = MapVariables.get((IWorld)event.getPlayer().field_70170_p);
            WorldVariables worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p);
            if (mapdata != null) {
                DungeonsAriseMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(0, mapdata));
            }
            if (worlddata != null) {
                DungeonsAriseMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(1, worlddata));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        WorldVariables worlddata;
        if (!event.getPlayer().field_70170_p.field_72995_K && (worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p)) != null) {
            DungeonsAriseMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(1, worlddata));
        }
    }

    public static class WorldSavedDataSyncMessage {
        public int type;
        public WorldSavedData data;

        public WorldSavedDataSyncMessage(PacketBuffer buffer) {
            this.type = buffer.readInt();
            this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            this.data.func_76184_a(buffer.func_150793_b());
        }

        public WorldSavedDataSyncMessage(int type, WorldSavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(WorldSavedDataSyncMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.type);
            buffer.func_150786_a(message.data.func_189551_b(new CompoundNBT()));
        }

        public static void handler(WorldSavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "dungeons_arise_mapvars";
        public double pillagerpalace_spawnrate = 300.0;
        public double randomhouse_spawnrate = 9000.0;
        public double randomship_spawnrate = 2100.0;
        public double randomicyship_spawnrate = 1800.0;
        public double miningsystem_spawnrate = 5500.0;
        public double tallspruce_spawnrate = 6000.0;
        public double randomairship_spawnrate = 2500.0;
        public double campsite_spawnrate = 5600.0;
        public double wishingwell_spawnrate = 1200.0;
        public double windmill_spawnrate = 2950.0;
        public double heavenlyrider_spawnrate = 400.0;
        public double magesand_spawnrate = 2250.0;
        public double magesnow_spawnrate = 1400.0;
        public double robusthouse_spawnrate = 6000.0;
        public double bunkerruins_spawnrate = 2100.0;
        public double randomtribalhouse_spawnrate = 2000.0;
        public double treehouse_spawnrate = 3150.0;
        public double orientaltemple_spawnrate = 700.0;
        public double desertgardens_spawnrate = 950.0;
        public double coliseum_spawnrate = 600.0;
        public double obsidianspikes_spawnrate = 13000.0;
        public double plainsstatue_spawnrate = 800.0;
        public double desertstatue_spawnrate = 1200.0;
        public double oceanstatue_spawnrate = 1300.0;
        public boolean protected_spawners = false;
        public double oceanexperience_spawnrate = 0.0;
        public boolean wda_devmode = false;
        public double mushroommines_spawnrate = 400.0;
        public double giantmushroom_spawnrate = 1200.0;
        public double swamptree_spawnrate = 900.0;
        public boolean waystones_compatibility = true;
        public double illagerfortress_spawnrate = 300.0;
        public double desertcity_spawnrate = 300.0;
        public double greenwoodbuild_spawnrate = 1000.0;
        public boolean enable_unfinished_structures = false;
        public double lighthouse_spawnrate = 150.0;
        public double fortifiedbuild_spawnrate = 900.0;
        public double bonetreehouse_spawnrate = 600.0;
        static MapVariables clientSide = new MapVariables();

        public MapVariables() {
            super(DATA_NAME);
        }

        public MapVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.pillagerpalace_spawnrate = nbt.func_74769_h("pillagerpalace_spawnrate");
            this.randomhouse_spawnrate = nbt.func_74769_h("randomhouse_spawnrate");
            this.randomship_spawnrate = nbt.func_74769_h("randomship_spawnrate");
            this.randomicyship_spawnrate = nbt.func_74769_h("randomicyship_spawnrate");
            this.miningsystem_spawnrate = nbt.func_74769_h("miningsystem_spawnrate");
            this.tallspruce_spawnrate = nbt.func_74769_h("tallspruce_spawnrate");
            this.randomairship_spawnrate = nbt.func_74769_h("randomairship_spawnrate");
            this.campsite_spawnrate = nbt.func_74769_h("campsite_spawnrate");
            this.wishingwell_spawnrate = nbt.func_74769_h("wishingwell_spawnrate");
            this.windmill_spawnrate = nbt.func_74769_h("windmill_spawnrate");
            this.heavenlyrider_spawnrate = nbt.func_74769_h("heavenlyrider_spawnrate");
            this.magesand_spawnrate = nbt.func_74769_h("magesand_spawnrate");
            this.magesnow_spawnrate = nbt.func_74769_h("magesnow_spawnrate");
            this.robusthouse_spawnrate = nbt.func_74769_h("robusthouse_spawnrate");
            this.bunkerruins_spawnrate = nbt.func_74769_h("bunkerruins_spawnrate");
            this.randomtribalhouse_spawnrate = nbt.func_74769_h("randomtribalhouse_spawnrate");
            this.treehouse_spawnrate = nbt.func_74769_h("treehouse_spawnrate");
            this.orientaltemple_spawnrate = nbt.func_74769_h("orientaltemple_spawnrate");
            this.desertgardens_spawnrate = nbt.func_74769_h("desertgardens_spawnrate");
            this.coliseum_spawnrate = nbt.func_74769_h("coliseum_spawnrate");
            this.obsidianspikes_spawnrate = nbt.func_74769_h("obsidianspikes_spawnrate");
            this.plainsstatue_spawnrate = nbt.func_74769_h("plainsstatue_spawnrate");
            this.desertstatue_spawnrate = nbt.func_74769_h("desertstatue_spawnrate");
            this.oceanstatue_spawnrate = nbt.func_74769_h("oceanstatue_spawnrate");
            this.protected_spawners = nbt.func_74767_n("protected_spawners");
            this.oceanexperience_spawnrate = nbt.func_74769_h("oceanexperience_spawnrate");
            this.wda_devmode = nbt.func_74767_n("wda_devmode");
            this.mushroommines_spawnrate = nbt.func_74769_h("mushroommines_spawnrate");
            this.giantmushroom_spawnrate = nbt.func_74769_h("giantmushroom_spawnrate");
            this.swamptree_spawnrate = nbt.func_74769_h("swamptree_spawnrate");
            this.waystones_compatibility = nbt.func_74767_n("waystones_compatibility");
            this.illagerfortress_spawnrate = nbt.func_74769_h("illagerfortress_spawnrate");
            this.desertcity_spawnrate = nbt.func_74769_h("desertcity_spawnrate");
            this.greenwoodbuild_spawnrate = nbt.func_74769_h("greenwoodbuild_spawnrate");
            this.enable_unfinished_structures = nbt.func_74767_n("enable_unfinished_structures");
            this.lighthouse_spawnrate = nbt.func_74769_h("lighthouse_spawnrate");
            this.fortifiedbuild_spawnrate = nbt.func_74769_h("fortifiedbuild_spawnrate");
            this.bonetreehouse_spawnrate = nbt.func_74769_h("bonetreehouse_spawnrate");
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            nbt.func_74780_a("pillagerpalace_spawnrate", this.pillagerpalace_spawnrate);
            nbt.func_74780_a("randomhouse_spawnrate", this.randomhouse_spawnrate);
            nbt.func_74780_a("randomship_spawnrate", this.randomship_spawnrate);
            nbt.func_74780_a("randomicyship_spawnrate", this.randomicyship_spawnrate);
            nbt.func_74780_a("miningsystem_spawnrate", this.miningsystem_spawnrate);
            nbt.func_74780_a("tallspruce_spawnrate", this.tallspruce_spawnrate);
            nbt.func_74780_a("randomairship_spawnrate", this.randomairship_spawnrate);
            nbt.func_74780_a("campsite_spawnrate", this.campsite_spawnrate);
            nbt.func_74780_a("wishingwell_spawnrate", this.wishingwell_spawnrate);
            nbt.func_74780_a("windmill_spawnrate", this.windmill_spawnrate);
            nbt.func_74780_a("heavenlyrider_spawnrate", this.heavenlyrider_spawnrate);
            nbt.func_74780_a("magesand_spawnrate", this.magesand_spawnrate);
            nbt.func_74780_a("magesnow_spawnrate", this.magesnow_spawnrate);
            nbt.func_74780_a("robusthouse_spawnrate", this.robusthouse_spawnrate);
            nbt.func_74780_a("bunkerruins_spawnrate", this.bunkerruins_spawnrate);
            nbt.func_74780_a("randomtribalhouse_spawnrate", this.randomtribalhouse_spawnrate);
            nbt.func_74780_a("treehouse_spawnrate", this.treehouse_spawnrate);
            nbt.func_74780_a("orientaltemple_spawnrate", this.orientaltemple_spawnrate);
            nbt.func_74780_a("desertgardens_spawnrate", this.desertgardens_spawnrate);
            nbt.func_74780_a("coliseum_spawnrate", this.coliseum_spawnrate);
            nbt.func_74780_a("obsidianspikes_spawnrate", this.obsidianspikes_spawnrate);
            nbt.func_74780_a("plainsstatue_spawnrate", this.plainsstatue_spawnrate);
            nbt.func_74780_a("desertstatue_spawnrate", this.desertstatue_spawnrate);
            nbt.func_74780_a("oceanstatue_spawnrate", this.oceanstatue_spawnrate);
            nbt.func_74757_a("protected_spawners", this.protected_spawners);
            nbt.func_74780_a("oceanexperience_spawnrate", this.oceanexperience_spawnrate);
            nbt.func_74757_a("wda_devmode", this.wda_devmode);
            nbt.func_74780_a("mushroommines_spawnrate", this.mushroommines_spawnrate);
            nbt.func_74780_a("giantmushroom_spawnrate", this.giantmushroom_spawnrate);
            nbt.func_74780_a("swamptree_spawnrate", this.swamptree_spawnrate);
            nbt.func_74757_a("waystones_compatibility", this.waystones_compatibility);
            nbt.func_74780_a("illagerfortress_spawnrate", this.illagerfortress_spawnrate);
            nbt.func_74780_a("desertcity_spawnrate", this.desertcity_spawnrate);
            nbt.func_74780_a("greenwoodbuild_spawnrate", this.greenwoodbuild_spawnrate);
            nbt.func_74757_a("enable_unfinished_structures", this.enable_unfinished_structures);
            nbt.func_74780_a("lighthouse_spawnrate", this.lighthouse_spawnrate);
            nbt.func_74780_a("fortifiedbuild_spawnrate", this.fortifiedbuild_spawnrate);
            nbt.func_74780_a("bonetreehouse_spawnrate", this.bonetreehouse_spawnrate);
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (!world.func_201672_e().field_72995_K) {
                DungeonsAriseMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new WorldSavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(IWorld world) {
            if (world.func_201672_e() instanceof ServerWorld) {
                return (MapVariables)world.func_201672_e().func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215752_a(MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "dungeons_arise_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public WorldVariables() {
            super(DATA_NAME);
        }

        public WorldVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (!world.func_201672_e().field_72995_K) {
                DungeonsAriseMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Dimension)world.func_201672_e().field_73011_w).func_186058_p()), (Object)new WorldSavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(IWorld world) {
            if (world.func_201672_e() instanceof ServerWorld) {
                return (WorldVariables)((ServerWorld)world.func_201672_e()).func_217481_x().func_215752_a(WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }
}

