/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.loading.FMLPaths;
import thut.essentials.Essentials;
import thut.essentials.commands.misc.RTP;
import thut.essentials.config.Config;
import thut.essentials.config.Configure;
import thut.essentials.land.LandEventsHandler;
import thut.essentials.util.ChatManager;
import thut.essentials.util.HomeManager;
import thut.essentials.util.InventoryLogger;
import thut.essentials.util.KitManager;
import thut.essentials.util.MobManager;
import thut.essentials.util.PlayerMover;
import thut.essentials.util.PvPManager;
import thut.essentials.util.WarpManager;

public class Config
extends Config.ConfigData {
    public static final String LAND = "land";
    public static final String MISC = "misc";
    public static final String HOME = "homes";
    public static final String WARP = "warps";
    public static final String KITS = "kits";
    public static final String BACK = "back";
    public static final String BED = "bed";
    public static final String ECON = "economy";
    public static final String STAFF = "staff";
    public static final String LOGS = "logging";
    public static final String CHAT = "chat";
    public static final String RTP = "rtp";
    public static final String TPA = "tpa";
    public static final String MOBS = "mobs";
    @Configure(category="land")
    public boolean defaultMessages = true;
    @Configure(category="land")
    public boolean denyExplosions = true;
    @Configure(category="land")
    public boolean chunkLoading = true;
    @Configure(category="land")
    public boolean landEnabled = true;
    @Configure(category="land")
    public String defaultTeamName = "Plebs";
    @Configure(category="land")
    public boolean wildernessTeam = false;
    @Configure(category="land")
    public String wildernessTeamName = "Wilderness";
    @Configure(category="land")
    public boolean logTeamChat = true;
    @Configure(category="land")
    public int teamLandPerPlayer = 125;
    @Configure(category="land")
    public int prefixLength = 12;
    @Configure(category="land")
    public int maxChunkloads = 9;
    @Configure(category="land")
    public boolean noMobGriefing = true;
    @Configure(category="land")
    public List<String> itemUseWhitelist = Lists.newArrayList();
    @Configure(category="land")
    public List<String> blockUseWhitelist = Lists.newArrayList();
    @Configure(category="land")
    public List<String> mobUseWhitelist = Lists.newArrayList();
    @Configure(category="land")
    public List<String> blockBreakWhitelist = Lists.newArrayList();
    @Configure(category="land")
    public List<String> blockPlaceWhitelist = Lists.newArrayList();
    @Configure(category="land")
    public List<String> customMobUsePerms = Lists.newArrayList((Object[])new String[]{"minecraft:armor_stand->thutessentials.land.useblock.unowned,thutessentials.land.useblock.owned.self,thutessentials.land.useblock.owned.other", "minecraft:item_frame->thutessentials.land.useblock.unowned,thutessentials.land.useblock.owned.self,thutessentials.land.useblock.owned.other", "minecraft:chest_minecart->thutessentials.land.useblock.unowned,thutessentials.land.useblock.owned.self,thutessentials.land.useblock.owned.other", "minecraft:furnace_minecart->thutessentials.land.useblock.unowned,thutessentials.land.useblock.owned.self,thutessentials.land.useblock.owned.other"});
    @Configure(category="land")
    public boolean foodWhitelisted = true;
    @Configure(category="homes")
    public int maxHomes = 2;
    @Configure(category="homes")
    public int homeActivateDelay = 50;
    @Configure(category="homes")
    public int homeReUseDelay = 100;
    @Configure(category="homes")
    public int kitReuseDelay = -1;
    @Configure(category="warps")
    public List<String> warps = Lists.newArrayList();
    @Configure(category="warps")
    public int warpActivateDelay = 50;
    @Configure(category="warps")
    public int warpReUseDelay = 100;
    @Configure(category="back")
    public int backRangeCheck = 5;
    @Configure(category="back")
    public int backReUseDelay = 100;
    @Configure(category="back")
    public int backActivateDelay = 50;
    @Configure(category="back")
    public boolean back_on_death = true;
    @Configure(category="back")
    public boolean back_on_tp = true;
    @Configure(category="bed")
    public int bedReUseDelay = 100;
    @Configure(category="bed")
    public int bedActivateDelay = 50;
    @Configure(category="rtp")
    public int rtpReUseDelay = 100;
    @Configure(category="rtp")
    public int rtpActivateDelay = 50;
    @Configure(category="rtp")
    public String rtpCentre = "0,0";
    @Configure(category="rtp")
    public int rtpDistance = 5000;
    @Configure(category="rtp")
    public boolean rtpSpawnCentred = true;
    @Configure(category="rtp")
    public boolean rtpPlayerCentred = false;
    @Configure(category="economy")
    public List<String> sellTags = Lists.newArrayList((Object[])new String[]{"Sell", "Sells", "Sale"});
    @Configure(category="economy")
    public List<String> recycleTags = Lists.newArrayList((Object[])new String[]{"Recycle"});
    @Configure(category="economy")
    public boolean shopsEnabled = true;
    @Configure(category="economy")
    public int initialBalance = 1000;
    @Configure(category="chat")
    public boolean useChatFormat = true;
    @Configure(category="chat")
    public String chatFormat = "<%s> %s";
    @Configure(category="logging")
    public List<String> inventory_log_blacklist = Lists.newArrayList();
    @Configure(category="logging")
    public boolean log_interactions = true;
    @Configure(category="logging")
    public boolean log_teleports = true;
    @Configure(category="logging")
    public boolean log_inventory_use = true;
    @Configure(category="tpa")
    public int tpaActivateDelay = 50;
    @Configure(category="tpa")
    public int tpaReUseDelay = 100;
    @Configure(category="tpa")
    public boolean tpaCrossDim = true;
    @Configure(category="misc")
    public List<String> commandBlacklist = Lists.newArrayList();
    @Configure(category="misc")
    public List<String> rules = Lists.newArrayList();
    @Configure(category="misc")
    public List<String> invulnMobs = Lists.newArrayList();
    @Configure(category="misc")
    public boolean debug = false;
    @Configure(category="misc")
    public boolean defuzz = true;
    @Configure(category="misc")
    public boolean comandDisableSpam = true;
    @Configure(category="misc")
    public boolean pvpPerms = false;
    @Configure(category="misc")
    public int spawnDim = 0;
    @Configure(category="misc")
    public int spawnActivateDelay = 50;
    @Configure(category="misc")
    public long spawnReUseDelay = 100L;
    @Configure(category="misc")
    public double maxSpeed = 10.0;
    @Configure(category="staff")
    public List<String> staff = Lists.newArrayList();
    @Configure(category="misc")
    public String lang_file = "en_us.json";
    @Configure(category="mobs")
    public List<String> mobSpawnBlacklist = Lists.newArrayList();
    @Configure(category="mobs")
    public List<String> mobSpawnWhitelist = Lists.newArrayList();
    @Configure(category="mobs")
    public boolean mobSpawnUsesWhitelist = false;
    @Configure(category="mobs")
    public List<String> mobGriefAllowBlacklist = Lists.newArrayList();
    @Configure(category="mobs")
    public List<String> mobGriefAllowWhitelist = Lists.newArrayList((Object[])new String[]{EntityType.field_200756_av.getRegistryName().toString()});
    @Configure(category="mobs")
    public boolean mobGriefAllowUsesWhitelist = true;
    public DimensionType spawnDimension = DimensionType.field_223227_a_;
    private final Path configpath;
    private final Map<String, String> lang_overrides_map = Maps.newHashMap();

    public Config() {
        super("thutessentials");
        this.configpath = FMLPaths.CONFIGDIR.get().resolve("thutessentials");
    }

    public ITextComponent getMessage(String key, Object ... args) {
        if (this.lang_overrides_map.containsKey(key)) {
            return new StringTextComponent(String.format(this.lang_overrides_map.get(key), args));
        }
        return new TranslationTextComponent(key, args);
    }

    public void sendFeedback(CommandSource target, String key, boolean log, Object ... args) {
        target.func_197030_a(this.getMessage(key, args), log);
    }

    public void sendError(CommandSource target, String key, Object ... args) {
        target.func_197021_a(this.getMessage(key, args));
    }

    @Override
    public void onUpdated() {
        this.spawnDimension = DimensionType.func_186069_a((int)this.spawnDim);
        File file = this.configpath.resolve(this.lang_file).toFile();
        if (file.exists()) {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
                Gson gson = new GsonBuilder().create();
                JsonObject o = (JsonObject)gson.fromJson((Reader)in, JsonObject.class);
                for (Map.Entry entry : o.entrySet()) {
                    try {
                        String key = (String)entry.getKey();
                        String value = ((JsonElement)entry.getValue()).getAsString();
                        this.lang_overrides_map.put(key, value);
                    }
                    catch (Exception e) {
                        Essentials.LOGGER.error("Error with keypair {}, {}", entry.getKey(), entry.getValue());
                    }
                }
            }
            catch (Exception e) {
                Essentials.LOGGER.error("Error loading lang json from config!", (Throwable)e);
            }
        }
        if (this.log_inventory_use) {
            InventoryLogger.enable();
        } else {
            InventoryLogger.disable();
        }
        if (this.rtpSpawnCentred) {
            thut.essentials.commands.misc.RTP.centre = null;
        } else {
            try {
                String[] args = this.rtpCentre.split(",");
                int x = Integer.parseInt(args[0]);
                int z = Integer.parseInt(args[1]);
                thut.essentials.commands.misc.RTP.centre = new BlockPos(x, 0, z);
            }
            catch (Exception e) {
                Essentials.LOGGER.error("Error with value in rtpCentre, defaulting to spawn centred!");
                thut.essentials.commands.misc.RTP.centre = null;
            }
        }
        HomeManager.registerPerms();
        WarpManager.init();
        KitManager.init();
        ChatManager.init();
        MobManager.init();
        PlayerMover.INTERUPTED = this.getMessage("thutessentials.tp.standstill", new Object[0]);
        LandEventsHandler.init();
        PvPManager.init();
    }
}

