/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.minecraft.command.CommandSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.FileAppender;
import thut.essentials.commands.CommandManager;
import thut.essentials.config.Config;
import thut.essentials.defuzz.SpawnDefuzzer;
import thut.essentials.economy.EconomyManager;
import thut.essentials.land.LandEventsHandler;
import thut.essentials.land.LandManager;
import thut.essentials.util.MobManager;
import thut.essentials.util.PlayerDataHandler;
import thut.essentials.util.world.WorldStructures;

@Mod(value="thutessentials")
public class Essentials {
    public static final String MODID = "thutessentials";
    public static final thut.essentials.Config config = new thut.essentials.Config();
    public static final Logger LOGGER = LogManager.getLogger((String)"thutessentials");

    public Essentials() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Config.setupConfigs(config, MODID, MODID);
        File logfile = FMLPaths.GAMEDIR.get().resolve("logs").resolve("thutessentials.log").toFile();
        if (logfile.exists()) {
            FMLPaths.GAMEDIR.get().resolve("logs").resolve(MODID).toFile().mkdirs();
            try {
                Files.move(FMLPaths.GAMEDIR.get().resolve("logs").resolve("thutessentials.log"), FMLPaths.GAMEDIR.get().resolve("logs").resolve(MODID).resolve(logfile.lastModified() + ".log"), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LOGGER;
        FileAppender appender = ((FileAppender.Builder)FileAppender.newBuilder().withFileName(logfile.getAbsolutePath()).setName(MODID)).build();
        logger.addAppender((Appender)appender);
        appender.start();
        MinecraftForge.EVENT_BUS.register(LandEventsHandler.ChunkLoadHandler.class);
        MinecraftForge.EVENT_BUS.register(MobManager.class);
        if (Essentials.config.defuzz) {
            LOGGER.info("Registering Defuzzer!");
            MinecraftForge.EVENT_BUS.register(SpawnDefuzzer.class);
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (in, net) -> true));
    }

    public void setup(FMLCommonSetupEvent event) {
        WorldStructures.setup();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void serverStarting(FMLServerStartingEvent event) {
        if (Essentials.config.landEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)LandEventsHandler.TEAMMANAGER);
        }
        if (Essentials.config.shopsEnabled) {
            EconomyManager.getInstance();
        }
        LandEventsHandler.TEAMMANAGER.registerPerms();
        LandEventsHandler.ChunkLoadHandler.server = event.getServer();
        CommandManager.register_commands((CommandDispatcher<CommandSource>)event.getCommandDispatcher(), event.getServer());
        LOGGER.info("Server Started");
    }

    @SubscribeEvent
    public void serverUnload(FMLServerStoppingEvent evt) {
        if (Essentials.config.landEnabled) {
            MinecraftForge.EVENT_BUS.unregister((Object)LandEventsHandler.TEAMMANAGER);
        }
        if (Essentials.config.shopsEnabled) {
            EconomyManager.clearInstance();
        }
        LandManager.clearInstance();
        PlayerDataHandler.saveAll();
        PlayerDataHandler.clear();
        LOGGER.info("Server Stopped");
    }
}

