/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.admin.StaffChat;
import thut.essentials.commands.economy.Balance;
import thut.essentials.commands.economy.Pay;
import thut.essentials.commands.homes.Create;
import thut.essentials.commands.homes.Delete;
import thut.essentials.commands.homes.Homes;
import thut.essentials.commands.land.claims.Claim;
import thut.essentials.commands.land.claims.Deed;
import thut.essentials.commands.land.claims.Load;
import thut.essentials.commands.land.claims.Owner;
import thut.essentials.commands.land.claims.Unclaim;
import thut.essentials.commands.land.claims.Unload;
import thut.essentials.commands.land.management.Admins;
import thut.essentials.commands.land.management.Edit;
import thut.essentials.commands.land.management.Invite;
import thut.essentials.commands.land.management.Join;
import thut.essentials.commands.land.management.Kick;
import thut.essentials.commands.land.management.Ranks;
import thut.essentials.commands.land.management.Relations;
import thut.essentials.commands.land.management.Rename;
import thut.essentials.commands.land.util.Chat;
import thut.essentials.commands.land.util.Check;
import thut.essentials.commands.land.util.Home;
import thut.essentials.commands.land.util.Members;
import thut.essentials.commands.land.util.Reload;
import thut.essentials.commands.land.util.Show;
import thut.essentials.commands.land.util.Teams;
import thut.essentials.commands.misc.Back;
import thut.essentials.commands.misc.Bed;
import thut.essentials.commands.misc.Config;
import thut.essentials.commands.misc.Kits;
import thut.essentials.commands.misc.Nick;
import thut.essentials.commands.misc.RTP;
import thut.essentials.commands.misc.Spawn;
import thut.essentials.commands.structures.Structuregen;
import thut.essentials.commands.tpa.TpAccept;
import thut.essentials.commands.tpa.TpToggle;
import thut.essentials.commands.tpa.Tpa;
import thut.essentials.commands.util.Heal;
import thut.essentials.commands.util.RAM;
import thut.essentials.commands.util.Repair;
import thut.essentials.commands.util.Speed;
import thut.essentials.commands.warps.Warps;
import thut.essentials.land.LandEventsHandler;
import thut.essentials.util.PlayerMover;

public class CommandManager {
    public static GameProfile getProfile(MinecraftServer server, UUID id) {
        GameProfile profile = null;
        if (id != null) {
            profile = server.func_152358_ax().func_152652_a(id);
        }
        if (profile == null) {
            profile = new GameProfile(id, null);
        }
        LandEventsHandler.TEAMMANAGER.queueUpdate(profile);
        return profile;
    }

    public static GameProfile getProfile(MinecraftServer server, String arg) {
        UUID id = null;
        String name = null;
        try {
            id = UUID.fromString(arg);
        }
        catch (Exception e) {
            name = arg;
        }
        GameProfile profile = null;
        if (id != null) {
            profile = server.func_152358_ax().func_152652_a(id);
        }
        if (profile == null) {
            profile = new GameProfile(id, name);
        }
        LandEventsHandler.TEAMMANAGER.queueUpdate(profile);
        if (profile.getId() == null) {
            ServerPlayerEntity player = server.func_184103_al().func_152612_a(profile.getName());
            profile = player.func_146103_bH();
        }
        return profile;
    }

    public static boolean hasPerm(CommandSource source, String permission) {
        try {
            ServerPlayerEntity player = source.func_197035_h();
            return CommandManager.hasPerm(player, permission);
        }
        catch (CommandSyntaxException e) {
            return true;
        }
    }

    public static boolean hasPerm(ServerPlayerEntity player, String permission) {
        if (!PermissionAPI.getPermissionHandler().getRegisteredNodes().contains(permission)) {
            String message = "Autogenerated node, this is a bug and should be pre-registered.";
            PermissionAPI.getPermissionHandler().registerNode(permission, DefaultPermissionLevel.OP, "Autogenerated node, this is a bug and should be pre-registered.");
            System.err.println("Autogenerated node, this is a bug and should be pre-registered.: " + permission);
        }
        return PermissionAPI.hasPermission((PlayerEntity)player, (String)permission);
    }

    public static void register_commands(CommandDispatcher<CommandSource> commandDispatcher, MinecraftServer server) {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerMover());
        Balance.register(commandDispatcher);
        Pay.register(commandDispatcher);
        StaffChat.register(commandDispatcher);
        Homes.register(commandDispatcher);
        Create.register(commandDispatcher);
        Delete.register(commandDispatcher);
        Warps.register(commandDispatcher);
        thut.essentials.commands.warps.Create.register(commandDispatcher);
        thut.essentials.commands.warps.Delete.register(commandDispatcher);
        Tpa.register(commandDispatcher);
        TpAccept.register(commandDispatcher);
        TpToggle.register(commandDispatcher);
        Back.register(commandDispatcher);
        RTP.register(commandDispatcher);
        Bed.register(commandDispatcher);
        Config.register(commandDispatcher);
        Kits.register(commandDispatcher);
        Spawn.register(commandDispatcher);
        Nick.register(commandDispatcher, server);
        Structuregen.register(commandDispatcher);
        Chat.register(commandDispatcher);
        Check.register(commandDispatcher);
        Home.register(commandDispatcher);
        Members.register(commandDispatcher);
        Reload.register(commandDispatcher);
        Teams.register(commandDispatcher);
        Show.register(commandDispatcher);
        Speed.register(commandDispatcher);
        Repair.register(commandDispatcher);
        Heal.register(commandDispatcher);
        RAM.register(commandDispatcher);
        thut.essentials.commands.land.management.Create.register(commandDispatcher);
        Rename.register(commandDispatcher);
        Invite.register(commandDispatcher);
        Join.register(commandDispatcher);
        Admins.register(commandDispatcher);
        thut.essentials.commands.land.management.Delete.register(commandDispatcher);
        Kick.register(commandDispatcher);
        Edit.register(commandDispatcher);
        Ranks.register(commandDispatcher);
        Relations.register(commandDispatcher);
        Claim.register(commandDispatcher);
        Owner.register(commandDispatcher);
        Unclaim.register(commandDispatcher);
        Deed.register(commandDispatcher);
        Load.register(commandDispatcher);
        Unload.register(commandDispatcher);
    }

    public static ITextComponent makeFormattedCommandLink(String text, String command, Object ... args) {
        ITextComponent message = Essentials.config.getMessage(text, args);
        Style style = message.func_150256_b();
        if (style == null) {
            style = new Style();
        }
        return message.func_150255_a(style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)));
    }

    public static ITextComponent makeFormattedComponent(String text, TextFormatting colour, boolean bold, Object ... args) {
        ITextComponent message = Essentials.config.getMessage(text, args);
        Style style = message.func_150256_b();
        if (style == null) {
            style = new Style();
        }
        if (colour != null) {
            style.func_150238_a(colour);
        }
        if (bold) {
            style.func_150227_a(Boolean.valueOf(bold));
        }
        return message.func_150255_a(style);
    }

    public static ITextComponent makeFormattedComponent(String text, TextFormatting colour, boolean bold) {
        return CommandManager.makeFormattedComponent(text, colour, bold, new Object[0]);
    }

    public static ITextComponent makeFormattedComponent(String text) {
        return CommandManager.makeFormattedComponent(text, null, false, new Object[0]);
    }

    public static ITextComponent makeFormattedCommandLink(String text, String command) {
        return CommandManager.makeFormattedCommandLink(text, command, new Object[0]);
    }
}

