/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.admin;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.command.arguments.MessageArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;

public class StaffChat {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "staff";
        String perm = "command.staff";
        PermissionAPI.registerNode((String)"command.staff", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player use /staff");
        if (Essentials.config.commandBlacklist.contains("staff")) {
            return;
        }
        StaffChat.createCommand(commandDispatcher, "staff", perm);
        StaffChat.createCommand(commandDispatcher, "sc", perm);
    }

    private static void createCommand(CommandDispatcher<CommandSource> commandDispatcher, String name, String perm) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"target", (ArgumentType)GameProfileArgument.func_197108_a()).executes(context -> StaffChat.addStaff((CommandSource)context.getSource(), GameProfileArgument.func_197109_a((CommandContext)context, (String)"target")))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"target", (ArgumentType)GameProfileArgument.func_197108_a()).suggests((context, builder) -> ISuggestionProvider.func_197005_b((Iterable)Essentials.config.staff.stream().map(UUID::fromString).map(id -> ((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_177451_a(id)).map(player -> player != null ? player.func_200200_C_().func_150254_d() : "Unknown").collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> StaffChat.removeStaff((CommandSource)context.getSource(), GameProfileArgument.func_197109_a((CommandContext)context, (String)"target")))))).then(Commands.func_197056_a((String)"message", (ArgumentType)MessageArgument.func_197123_a()).executes(context -> StaffChat.execute((CommandSource)context.getSource(), MessageArgument.func_197124_a((CommandContext)context, (String)"message")))));
    }

    private static int removeStaff(CommandSource source, Collection<GameProfile> target) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        ArrayList staffList = Lists.newArrayList(Essentials.config.staff);
        GameProfile gameProfile = target.stream().findFirst().get();
        staffList.remove(gameProfile.getId().toString());
        try {
            Essentials.config.staff = staffList;
            Essentials.config.onUpdated();
            Essentials.config.write();
            player.func_145747_a(CommandManager.makeFormattedComponent("Removed form Staff: " + gameProfile.getName()));
            return 1;
        }
        catch (Exception e) {
            player.func_145747_a(CommandManager.makeFormattedComponent("Error removing a Staff"));
            e.printStackTrace();
            return 0;
        }
    }

    private static int addStaff(CommandSource source, Collection<GameProfile> target) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        ArrayList staffList = Lists.newArrayList(Essentials.config.staff);
        GameProfile gameProfile = target.stream().findFirst().get();
        staffList.add(gameProfile.getId().toString());
        try {
            Essentials.config.staff = staffList;
            Essentials.config.onUpdated();
            Essentials.config.write();
            player.func_145747_a(CommandManager.makeFormattedComponent("Added to Staff: " + gameProfile.getName()));
            return 1;
        }
        catch (Exception e) {
            player.func_145747_a(CommandManager.makeFormattedComponent("Error adding to Staff"));
            e.printStackTrace();
            return 0;
        }
    }

    private static int execute(CommandSource source, ITextComponent message) throws CommandSyntaxException {
        ServerPlayerEntity sender = source.func_197035_h();
        ITextComponent textComponent = CommandManager.makeFormattedComponent("[Staff] <" + sender.func_200200_C_().func_150254_d() + "> " + message.func_150254_d(), TextFormatting.YELLOW, false);
        source.func_197028_i().func_145747_a(textComponent);
        Essentials.config.staff.forEach(s -> {
            try {
                UUID id = UUID.fromString(s);
                ServerPlayerEntity player = source.func_197028_i().func_184103_al().func_177451_a(id);
                if (player != null) {
                    player.func_145747_a(textComponent);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return 1;
    }
}

