/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.economy;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.economy.EconomyManager;

public class Pay {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "pay";
        if (Essentials.config.commandBlacklist.contains("pay")) {
            return;
        }
        String perm = "command.pay";
        PermissionAPI.registerNode((String)"command.pay", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /pay");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"pay").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"target_player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> Pay.execute((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"target_player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount")))));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source, ServerPlayerEntity payee, int toSend) throws CommandSyntaxException {
        ServerPlayerEntity player = null;
        int senderBalance = Integer.MAX_VALUE;
        try {
            player = source.func_197035_h();
            senderBalance = EconomyManager.getBalance(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (toSend <= 0) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.econ.pay.positive", new Object[0]));
            return 1;
        }
        if (toSend <= senderBalance) {
            EconomyManager.addBalance(payee, toSend);
            player.func_145747_a(Essentials.config.getMessage("thutessentials.econ.pay.got", toSend, source.func_197019_b()));
            if (player != null) {
                EconomyManager.addBalance(player, -toSend);
            }
            Essentials.config.sendFeedback(source, "thutessentials.econ.pay.send", false, toSend, payee.func_145748_c_());
            return 0;
        }
        player.func_145747_a(Essentials.config.getMessage("thutessentials.econ.pay.notenough", new Object[0]));
        return 1;
    }
}

