/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.homes;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.HomeManager;

public class Create {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "set_home";
        if (!Essentials.config.commandBlacklist.contains("set_home")) {
            String perm = "command.set_home";
            PermissionAPI.registerNode((String)"command.set_home", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /set_home");
            LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"set_home").requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"home_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> Create.execute((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"home_name"))));
            commandDispatcher.register(command);
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"set_home").requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.executes(ctx -> Create.execute((CommandSource)ctx.getSource(), null));
            commandDispatcher.register(command);
        }
    }

    private static int execute(CommandSource source, String homeName) throws CommandSyntaxException {
        if (homeName == null) {
            homeName = "Home";
        }
        ServerPlayerEntity player = source.func_197035_h();
        int ret = HomeManager.setHome(player, homeName);
        switch (ret) {
            case 0: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.homes.added", null, false, homeName);
                player.func_145747_a(message);
                break;
            }
            case 1: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.homes.toomany");
                player.func_145747_a(message);
                break;
            }
            case 2: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.homes.noperms");
                player.func_145747_a(message);
                break;
            }
            case 3: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.homes.exists", null, false, homeName);
                player.func_145747_a(message);
            }
        }
        return ret;
    }
}

