/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.homes;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.HomeManager;
import thut.essentials.util.PlayerDataHandler;

public class Delete {
    private static SuggestionProvider<CommandSource> SUGGEST_NAMES = (ctx, sb) -> {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        ArrayList opts = Lists.newArrayList();
        CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
        CompoundNBT homes = tag.func_74775_l("homes");
        opts.addAll(homes.func_150296_c());
        opts.replaceAll(s -> s.contains(" ") ? "\"" + s + "\"" : s);
        return ISuggestionProvider.func_197005_b((Iterable)opts, (SuggestionsBuilder)sb);
    };

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "del_home";
        if (!Essentials.config.commandBlacklist.contains("del_home")) {
            String perm = "command.del_home";
            PermissionAPI.registerNode((String)"command.del_home", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /del_home");
            LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"del_home").requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"home_name", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_NAMES).executes(ctx -> Delete.execute((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"home_name"))));
            commandDispatcher.register(command);
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"del_home").requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.executes(ctx -> Delete.execute((CommandSource)ctx.getSource(), null));
            commandDispatcher.register(command);
        }
    }

    private static int execute(CommandSource source, String homeName) throws CommandSyntaxException {
        if (homeName == null) {
            homeName = "Home";
        }
        ServerPlayerEntity player = source.func_197035_h();
        int ret = HomeManager.removeHome(player, homeName);
        switch (ret) {
            case 0: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.homes.removed", null, false, homeName);
                player.func_145747_a(message);
                break;
            }
            case 1: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.homes.noexists", null, false, homeName);
                player.func_145747_a(message);
            }
        }
        return ret;
    }
}

