/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.homes;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.HomeManager;
import thut.essentials.util.PlayerDataHandler;
import thut.essentials.util.PlayerMover;

public class Homes {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        LiteralArgumentBuilder command;
        String perm;
        String name = "homes";
        if (!Essentials.config.commandBlacklist.contains(name)) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.executes(ctx -> Homes.execute((CommandSource)ctx.getSource()));
            commandDispatcher.register(command);
        }
        if (!Essentials.config.commandBlacklist.contains(name = "home")) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"home_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> Homes.execute((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"home_name"))));
            commandDispatcher.register(command);
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.executes(ctx -> Homes.execute((CommandSource)ctx.getSource(), null));
            commandDispatcher.register(command);
        }
    }

    private static int execute(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        HomeManager.sendHomeList(player);
        return 0;
    }

    private static int execute(CommandSource source, String homeName) throws CommandSyntaxException {
        long time;
        ServerPlayerEntity player;
        int[] home;
        if (homeName == null) {
            homeName = "Home";
        }
        if ((home = HomeManager.getHome(player = source.func_197035_h(), homeName)) == null) {
            ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.homes.noexists", null, false, homeName);
            player.func_145747_a(message);
            return 1;
        }
        CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
        CompoundNBT tptag = tag.func_74775_l("tp");
        long last = tptag.func_74763_f("homeDelay");
        if (last > (time = player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_82737_E()) && Essentials.config.homeReUseDelay > 0) {
            ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.tp.tosoon");
            player.func_145747_a(message);
            return 2;
        }
        ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.homes.warping", null, false, homeName);
        player.func_145747_a(message);
        message = CommandManager.makeFormattedComponent("thutessentials.homes.warped", null, false, homeName);
        tptag.func_74772_a("homeDelay", time + (long)Essentials.config.homeReUseDelay);
        tag.func_218657_a("tp", (INBT)tptag);
        PlayerDataHandler.saveCustomData((PlayerEntity)player);
        PlayerMover.setMove((PlayerEntity)player, Essentials.config.homeActivateDelay, home[3], new BlockPos(home[0], home[1], home[2]), message, PlayerMover.INTERUPTED);
        return 0;
    }
}

