/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.claims;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.events.ClaimLandEvent;
import thut.essentials.land.LandManager;
import thut.essentials.land.LandSaveHandler;
import thut.essentials.util.Coordinate;

public class Claim {
    private static final String BYPASSLIMIT = "thutessentials.land.claim.nolimit";
    private static final String AUTOCLAIM = "thutessentials.land.claim.autoclaim";
    private static final String BULKCLAIM = "thutessentials.land.claim.bulkclaim";
    private static final Set<UUID> autoclaimers = Sets.newHashSet();
    private static final Map<UUID, GlobalPos> claimstarts = Maps.newHashMap();

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "claim";
        if (Essentials.config.commandBlacklist.contains("claim")) {
            return;
        }
        MinecraftForge.EVENT_BUS.register(Claim.class);
        String perm = "command.claim";
        PermissionAPI.registerNode((String)"command.claim", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /claim");
        PermissionAPI.registerNode((String)BYPASSLIMIT, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Permission to bypass the land per player limit for a team.");
        PermissionAPI.registerNode((String)AUTOCLAIM, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Permission to use autoclaim to claim land as they walk around.");
        PermissionAPI.registerNode((String)BULKCLAIM, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Permission to use /claim start and /claim end to bulk claim chunks.");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"claim").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> Claim.execute((CommandSource)ctx.getSource(), true, true, false));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"claim").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197057_a((String)"up").executes(ctx -> Claim.execute((CommandSource)ctx.getSource(), true, false, false)));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"claim").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197057_a((String)"down").executes(ctx -> Claim.execute((CommandSource)ctx.getSource(), false, true, false)));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"claim").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197057_a((String)"here").executes(ctx -> Claim.execute((CommandSource)ctx.getSource(), false, false, true)));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"claim").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"auto").requires(cs -> CommandManager.hasPerm(cs, AUTOCLAIM))).executes(ctx -> Claim.executeAuto((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"claim").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197057_a((String)"check").executes(ctx -> Claim.executeCheck((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"claim").requires(cs -> CommandManager.hasPerm(cs, BULKCLAIM));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197057_a((String)"start").executes(ctx -> Claim.executeStart((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"claim").requires(cs -> CommandManager.hasPerm(cs, BULKCLAIM));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197057_a((String)"end").executes(ctx -> Claim.executeEnd((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
    }

    @SubscribeEvent
    public static void livingUpdate(LivingEvent.LivingUpdateEvent evt) {
        Coordinate oldChunk;
        if (!(evt.getEntity().func_70089_S() && autoclaimers.contains(evt.getEntity().func_110124_au()) && evt.getEntityLiving() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)evt.getEntityLiving();
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        BlockPos here = new BlockPos(player.field_71094_bP, player.field_71095_bQ, player.field_71085_bR);
        BlockPos old = new BlockPos(player.field_71091_bM, player.field_71096_bN, player.field_71097_bO);
        Coordinate newChunk = Coordinate.getChunkCoordFromWorldCoord(here, player.field_71093_bK.func_186068_a());
        if (newChunk.equals(oldChunk = Coordinate.getChunkCoordFromWorldCoord(old, player.func_130014_f_().func_201675_m()))) {
            return;
        }
        int dim = player.field_71093_bK.func_186068_a();
        int x = MathHelper.func_76141_d((float)(player.func_180425_c().func_177958_n() >> 4));
        int z = MathHelper.func_76141_d((float)(player.func_180425_c().func_177952_p() >> 4));
        boolean noLimit = PermissionAPI.hasPermission((PlayerEntity)player, (String)BYPASSLIMIT);
        for (int i = 0; i < 16; ++i) {
            Claim.claim(x, i, z, dim, (PlayerEntity)player, team, false, noLimit);
        }
    }

    @SubscribeEvent
    public static void serverUnload(FMLServerStoppingEvent evt) {
        autoclaimers.clear();
        claimstarts.clear();
        MinecraftForge.EVENT_BUS.unregister(Claim.class);
    }

    private static int executeCheck(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        int count = LandManager.getInstance().countLand(team.teamName);
        int teamCount = team.member.size();
        int maxLand = team.maxLand < 0 ? teamCount * Essentials.config.teamLandPerPlayer : team.maxLand;
        player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.claimed.count", count, maxLand));
        return 0;
    }

    private static int executeStart(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        if (!team.hasRankPerm(player.func_110124_au(), "claim")) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.notallowed.teamperms", new Object[0]));
            return 1;
        }
        GlobalPos start = GlobalPos.func_218179_a((DimensionType)player.getEntity().field_71093_bK, (BlockPos)player.func_180425_c());
        claimstarts.put(player.func_110124_au(), start);
        player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.start.set", player.func_180425_c()));
        return 0;
    }

    private static int executeEnd(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        if (!team.hasRankPerm(player.func_110124_au(), "claim")) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.notallowed.teamperms", new Object[0]));
            return 1;
        }
        GlobalPos end = GlobalPos.func_218179_a((DimensionType)player.getEntity().field_71093_bK, (BlockPos)player.func_180425_c());
        GlobalPos start = claimstarts.get(player.func_110124_au());
        if (start == null) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.start.not_set", new Object[0]));
            return 1;
        }
        if (end.func_218177_a() != start.func_218177_a()) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.start.wrong_dim", new Object[0]));
            return 1;
        }
        AxisAlignedBB box = new AxisAlignedBB(start.func_218180_b(), end.func_218180_b());
        boolean noLimit = PermissionAPI.hasPermission((PlayerEntity)player, (String)BYPASSLIMIT);
        int dim = player.field_71093_bK.func_186068_a();
        int n = 0;
        for (int x = MathHelper.func_76128_c((double)box.field_72340_a) >> 4; x <= MathHelper.func_76128_c((double)box.field_72336_d) >> 4; ++x) {
            int z = MathHelper.func_76128_c((double)box.field_72339_c) >> 4;
            while (x <= MathHelper.func_76128_c((double)box.field_72334_f) >> 4) {
                for (int y = 0; y < 16; ++y) {
                    n += Claim.claim(x, y, z, dim, (PlayerEntity)player, team, false, noLimit);
                }
                ++z;
            }
        }
        player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.start.end", n, team.teamName));
        return 0;
    }

    private static int executeAuto(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        if (autoclaimers.contains(player.func_110124_au())) {
            autoclaimers.remove(player.func_110124_au());
            Essentials.config.sendFeedback(source, "thutessentials.claim.autooff", true, new Object[0]);
        } else {
            autoclaimers.add(player.func_110124_au());
            Essentials.config.sendFeedback(source, "thutessentials.claim.autoon", true, new Object[0]);
        }
        return 0;
    }

    private static int execute(CommandSource source, boolean up, boolean down, boolean here) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        if (!team.hasRankPerm(player.func_110124_au(), "claim")) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.notallowed.teamperms", new Object[0]));
            return 1;
        }
        boolean noLimit = PermissionAPI.hasPermission((PlayerEntity)player, (String)BYPASSLIMIT);
        int x = player.func_180425_c().func_177958_n() >> 4;
        int y = player.func_180425_c().func_177956_o() >> 4;
        int z = player.func_180425_c().func_177952_p() >> 4;
        int dim = player.field_71093_bK.func_186068_a();
        if (here) {
            return Claim.claim(x, y, z, dim, (PlayerEntity)player, team, true, noLimit);
        }
        int min = down ? 0 : y;
        int max = up ? 16 : y;
        boolean claimed = false;
        int claimnum = 0;
        int notclaimed = 0;
        for (int i = min; i < max; ++i) {
            int check = Claim.claim(x, i, z, dim, (PlayerEntity)player, team, false, noLimit);
            if (check == 0) {
                claimed = true;
                ++claimnum;
            } else {
                ++notclaimed;
            }
            if (check != 3) continue;
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.notallowed.needmoreland", new Object[0]));
            break;
        }
        if (notclaimed > 0) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.warn.alreadyclaimed", notclaimed));
        }
        if (claimed) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.claimed.num", claimnum, team.teamName));
        } else {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.claimed.failed", team.teamName));
        }
        LandSaveHandler.saveTeam(team.teamName);
        return claimed ? 0 : 1;
    }

    public static int claim(int x, int y, int z, int dim, PlayerEntity player, LandManager.LandTeam team, boolean messages, boolean noLimit) {
        Coordinate chunk = new Coordinate(x, y, z, dim);
        return Claim.claim(chunk, player, team, messages, noLimit);
    }

    public static int claim(Coordinate chunk, PlayerEntity player, LandManager.LandTeam team, boolean messages, boolean noLimit) {
        if (chunk.y < 0 || chunk.y > 15) {
            return 1;
        }
        LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(chunk);
        if (owner != null) {
            if (messages) {
                player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.notallowed.alreadyclaimedby", owner.teamName));
            }
            return 2;
        }
        int teamCount = team.member.size();
        int maxLand = team.maxLand < 0 ? teamCount * Essentials.config.teamLandPerPlayer : team.maxLand;
        int count = LandManager.getInstance().countLand(team.teamName);
        if (count >= maxLand && !noLimit) {
            if (messages) {
                player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.notallowed.needmoreland", new Object[0]));
            }
            return 3;
        }
        ClaimLandEvent event = new ClaimLandEvent(new BlockPos(chunk.x, chunk.y, chunk.z), chunk.dim, player, team.teamName);
        MinecraftForge.EVENT_BUS.post((Event)event);
        LandManager.getInstance().addTeamLand(team.teamName, chunk, true);
        if (messages) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.claimed", team.teamName));
        }
        return 0;
    }
}

