/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.claims;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashSet;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.commands.land.claims.Claim;
import thut.essentials.land.LandManager;
import thut.essentials.land.LandSaveHandler;
import thut.essentials.util.Coordinate;

public class Deed {
    private static final String BYPASSLIMIT = "thutessentials.land.deed.nolimit";
    private static final String CANREDEEMDEEDS = "thutessentials.land.deed";
    private static final String DEEDTEAM = "__deeds__";
    private static boolean registered = false;

    @SubscribeEvent(receiveCanceled=true)
    public static void interact(PlayerInteractEvent.RightClickItem evt) {
        if (!(evt.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ItemStack stack = evt.getItemStack();
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("isDeed")) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)evt.getPlayer();
        if (!PermissionAPI.hasPermission((PlayerEntity)player, (String)CANREDEEMDEEDS)) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.notallowed.teamperms", new Object[0]));
            return;
        }
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        if (!team.hasRankPerm(player.func_110124_au(), "claim")) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.notallowed.teamperms", new Object[0]));
            return;
        }
        int num = stack.func_77978_p().func_74762_e("num");
        int n = 0;
        int x = 0;
        int z = 0;
        for (int i = 0; i < num; ++i) {
            CompoundNBT tag = stack.func_77978_p().func_74775_l("" + i);
            Coordinate c = new Coordinate(tag);
            x = c.x;
            z = c.z;
            LandManager.getInstance().removeTeamLand(DEEDTEAM, c);
            int re = Claim.claim(c, (PlayerEntity)player, team, false, PermissionAPI.hasPermission((PlayerEntity)player, (String)BYPASSLIMIT));
            if (re != 0) continue;
            ++n;
            stack.func_77978_p().func_82580_o("" + i);
        }
        stack.func_77978_p().func_74768_a("num", num - n);
        player.func_145747_a(Essentials.config.getMessage("thutessentials.deed.claimed", n, team.teamName));
        if (n == num) {
            stack.func_190917_f(-1);
        } else {
            stack.func_200302_a(Essentials.config.getMessage("thutessentials.deed.for", num - n, x << 4, z << 4));
        }
    }

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "reclaim_deed";
        if (Essentials.config.commandBlacklist.contains("reclaim_deed")) {
            return;
        }
        String perm = "command.reclaim_deed";
        PermissionAPI.registerNode((String)"command.reclaim_deed", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /reclaim_deed");
        PermissionAPI.registerNode((String)BYPASSLIMIT, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Permission to bypass the land per player limit for a team using deeds.");
        PermissionAPI.registerNode((String)CANREDEEMDEEDS, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Permission to use deeds to claim land.");
        if (!registered) {
            MinecraftForge.EVENT_BUS.register(Deed.class);
        }
        registered = true;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"reclaim_deed").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> Deed.execute((CommandSource)ctx.getSource(), true, true, false));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"reclaim_deed").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197057_a((String)"up").executes(ctx -> Deed.execute((CommandSource)ctx.getSource(), true, false, false)));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"reclaim_deed").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197057_a((String)"down").executes(ctx -> Deed.execute((CommandSource)ctx.getSource(), false, true, false)));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"reclaim_deed").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197057_a((String)"here").executes(ctx -> Deed.execute((CommandSource)ctx.getSource(), false, false, true)));
        commandDispatcher.register(command);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int execute(CommandSource source, boolean up, boolean down, boolean here) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        boolean canUnclaimAnything = PermissionAPI.hasPermission((PlayerEntity)player, (String)"thutessentials.land.unclaim.any");
        if (!canUnclaimAnything && !team.hasRankPerm(player.func_110124_au(), "unclaim")) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.notallowed.teamperms", new Object[0]));
            return 1;
        }
        int x = player.func_180425_c().func_177958_n() >> 4;
        int y = player.func_180425_c().func_177956_o() >> 4;
        int z = player.func_180425_c().func_177952_p() >> 4;
        HashSet deeds = Sets.newHashSet();
        int dim = player.field_71093_bK.func_186068_a();
        boolean done = false;
        if (here) {
            int ret = Deed.unclaim(x, y, z, (PlayerEntity)player, team, true, canUnclaimAnything);
            if (ret != 0) return ret;
            Coordinate chunk = new Coordinate(x, y, z, dim);
            done = true;
            deeds.add(chunk);
        } else {
            int min = down ? 0 : y;
            int max = up ? 16 : y;
            int claimnum = 0;
            int owned_other = 0;
            for (int i = min; i < max; ++i) {
                int check = Deed.unclaim(x, i, z, (PlayerEntity)player, team, false, canUnclaimAnything);
                if (check == 0) {
                    Coordinate chunk = new Coordinate(x, i, z, dim);
                    deeds.add(chunk);
                    done = true;
                    ++claimnum;
                    continue;
                }
                if (check != 3) continue;
                ++owned_other;
            }
            if (owned_other > 0) {
                player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.notallowed.notowner", owned_other));
            }
            if (done) {
                player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.done.num", claimnum, team.teamName));
            } else {
                player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.done.failed", claimnum, team.teamName));
            }
        }
        if (!deeds.isEmpty()) {
            ItemStack deed = new ItemStack((IItemProvider)Items.field_151121_aF);
            deed.func_77982_d(new CompoundNBT());
            deed.func_77978_p().func_74768_a("num", deeds.size());
            deed.func_77978_p().func_74757_a("isDeed", true);
            int i = 0;
            for (Coordinate c : deeds) {
                deed.func_77978_p().func_218657_a("" + i++, (INBT)c.serializeNBT());
            }
            deed.func_200302_a(Essentials.config.getMessage("thutessentials.deed.for", deeds.size(), x << 4, z << 4));
            if (!player.func_191521_c(deed)) {
                player.func_71019_a(deed, false);
            }
        }
        LandSaveHandler.saveTeam(team.teamName);
        LandSaveHandler.saveTeam(DEEDTEAM);
        if (!done) return 1;
        return 0;
    }

    private static int unclaim(Coordinate chunk, PlayerEntity player, LandManager.LandTeam team, boolean messages, boolean canUnclaimAnything) {
        LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(chunk);
        if (owner == null) {
            if (messages) {
                player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.notallowed.noowner", new Object[0]));
            }
            return 2;
        }
        if (owner != team && !canUnclaimAnything) {
            if (messages) {
                player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.notallowed.notowner", owner.teamName));
            }
            return 3;
        }
        LandManager.getInstance().removeTeamLand(team.teamName, chunk);
        Deed.initDeedTeam();
        LandManager.getInstance().addTeamLand(DEEDTEAM, chunk, true);
        if (messages) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.done", team.teamName));
        }
        return 0;
    }

    private static void initDeedTeam() {
        LandManager.LandTeam team = LandManager.getInstance().getTeam(DEEDTEAM, true);
        team.reserved = true;
    }

    private static int unclaim(int x, int y, int z, PlayerEntity player, LandManager.LandTeam team, boolean messages, boolean canUnclaimAnything) {
        if (y < 0 || y > 15) {
            return 1;
        }
        int dim = player.field_71093_bK.func_186068_a();
        Coordinate chunk = new Coordinate(x, y, z, dim);
        return Deed.unclaim(chunk, player, team, messages, canUnclaimAnything);
    }
}

