/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.claims;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.land.LandManager;
import thut.essentials.util.Coordinate;

public class Owner {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "land_owner";
        if (Essentials.config.commandBlacklist.contains("land_owner")) {
            return;
        }
        String perm = "command.land_owner";
        PermissionAPI.registerNode((String)"command.land_owner", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /land_owner");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"land_owner").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> Owner.execute((CommandSource)ctx.getSource()));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        int x = MathHelper.func_76141_d((float)(player.func_180425_c().func_177958_n() >> 4));
        int y = MathHelper.func_76141_d((float)(player.func_180425_c().func_177956_o() >> 4));
        int z = MathHelper.func_76141_d((float)(player.func_180425_c().func_177952_p() >> 4));
        if (y < 0 || y > 15) {
            return 1;
        }
        int dim = player.field_71093_bK.func_186068_a();
        Coordinate chunk = new Coordinate(x, y, z, dim);
        LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(chunk);
        if (owner != null) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.ownedby", owner.teamName));
        } else {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.unowned", new Object[0]));
        }
        return 0;
    }
}

