/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.claims;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.events.UnclaimLandEvent;
import thut.essentials.land.LandManager;
import thut.essentials.land.LandSaveHandler;
import thut.essentials.util.Coordinate;

public class Unclaim {
    public static final String GLOBALPERM = "thutessentials.land.unclaim.any";

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "unclaim";
        if (Essentials.config.commandBlacklist.contains("unclaim")) {
            return;
        }
        String perm = "command.unclaim";
        PermissionAPI.registerNode((String)"command.unclaim", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /unclaim");
        PermissionAPI.registerNode((String)GLOBALPERM, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Permission to unclaim land regardless of owner.");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"unclaim").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> Unclaim.execute((CommandSource)ctx.getSource(), true, true, false, false));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"unclaim").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197057_a((String)"up").executes(ctx -> Unclaim.execute((CommandSource)ctx.getSource(), true, false, false, false)));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"unclaim").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197057_a((String)"down").executes(ctx -> Unclaim.execute((CommandSource)ctx.getSource(), false, true, false, false)));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"unclaim").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197057_a((String)"here").executes(ctx -> Unclaim.execute((CommandSource)ctx.getSource(), false, false, true, false)));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"unclaim").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197057_a((String)"everything").executes(ctx -> Unclaim.execute((CommandSource)ctx.getSource(), false, false, false, true)));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source, boolean up, boolean down, boolean here, boolean all) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        boolean canUnclaimAnything = PermissionAPI.hasPermission((PlayerEntity)player, (String)GLOBALPERM);
        if (!canUnclaimAnything && !team.hasRankPerm(player.func_110124_au(), "unclaim")) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.notallowed.teamperms", new Object[0]));
            return 1;
        }
        if (all) {
            ArrayList allLand = Lists.newArrayList(team.land.land);
            for (Coordinate c : allLand) {
                Unclaim.unclaim(c, (PlayerEntity)player, team, false, canUnclaimAnything);
            }
            player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.done.num", allLand.size(), team.teamName));
            return 0;
        }
        int x = MathHelper.func_76141_d((float)(player.func_180425_c().func_177958_n() >> 4));
        int y = MathHelper.func_76141_d((float)(player.func_180425_c().func_177956_o() >> 4));
        int z = MathHelper.func_76141_d((float)(player.func_180425_c().func_177952_p() >> 4));
        if (here) {
            return Unclaim.unclaim(x, y, z, (PlayerEntity)player, team, true, canUnclaimAnything);
        }
        int min = down ? 0 : y;
        int max = up ? 16 : y;
        boolean done = false;
        int claimnum = 0;
        int owned_other = 0;
        for (int i = min; i < max; ++i) {
            int check = Unclaim.unclaim(x, i, z, (PlayerEntity)player, team, false, canUnclaimAnything);
            if (check == 0) {
                done = true;
                ++claimnum;
                continue;
            }
            if (check != 3) continue;
            ++owned_other;
        }
        if (owned_other > 0) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.notallowed.notowner", owned_other));
        }
        if (done) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.done.num", claimnum, team.teamName));
        } else {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.done.failed", claimnum, team.teamName));
        }
        LandSaveHandler.saveTeam(team.teamName);
        return done ? 0 : 1;
    }

    private static int unclaim(Coordinate chunk, PlayerEntity player, LandManager.LandTeam team, boolean messages, boolean canUnclaimAnything) {
        LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(chunk);
        if (owner == null) {
            if (messages) {
                player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.notallowed.noowner", new Object[0]));
            }
            return 2;
        }
        if (owner != team && !canUnclaimAnything) {
            if (messages) {
                player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.notallowed.notowner", owner.teamName));
            }
            return 3;
        }
        UnclaimLandEvent event = new UnclaimLandEvent(new BlockPos(chunk.x, chunk.y, chunk.z), chunk.dim, player, team.teamName);
        MinecraftForge.EVENT_BUS.post((Event)event);
        LandManager.getInstance().removeTeamLand(team.teamName, chunk);
        if (messages) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.unclaim.done", team.teamName));
        }
        return 0;
    }

    private static int unclaim(int x, int y, int z, PlayerEntity player, LandManager.LandTeam team, boolean messages, boolean canUnclaimAnything) {
        if (y < 0 || y > 15) {
            return 1;
        }
        int dim = player.field_71093_bK.func_186068_a();
        Coordinate chunk = new Coordinate(x, y, z, dim);
        return Unclaim.unclaim(chunk, player, team, messages, canUnclaimAnything);
    }
}

