/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.claims;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.land.LandManager;
import thut.essentials.util.Coordinate;

public class Unload {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        if (!Essentials.config.chunkLoading) {
            return;
        }
        String name = "unchunkload";
        if (Essentials.config.commandBlacklist.contains("unchunkload")) {
            return;
        }
        String perm = "command.unchunkload";
        PermissionAPI.registerNode((String)"command.unchunkload", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /unchunkload");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"unchunkload").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> Unload.execute((CommandSource)ctx.getSource()));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source) throws CommandSyntaxException {
        int maxLoaded;
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        if (!team.hasRankPerm(player.func_110124_au(), "claim")) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.notallowed.teamperms", new Object[0]));
            return 1;
        }
        int x = MathHelper.func_76141_d((float)(player.func_180425_c().func_177958_n() >> 4));
        int y = MathHelper.func_76141_d((float)(player.func_180425_c().func_177956_o() >> 4));
        int z = MathHelper.func_76141_d((float)(player.func_180425_c().func_177952_p() >> 4));
        if (y < 0 || y > 15) {
            return 1;
        }
        int dim = player.field_71093_bK.func_186068_a();
        Coordinate chunk = new Coordinate(x, 0, z, dim);
        LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(chunk);
        int n = maxLoaded = team.maxLoaded != -1 ? team.maxLoaded : Essentials.config.maxChunkloads;
        if (owner == team && team.land.getLoaded().contains(chunk) && LandManager.getInstance().unLoadLand(chunk, team)) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.claim.unloaded", maxLoaded - team.land.getLoaded().size()));
        }
        return 0;
    }
}

