/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.management;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.commands.land.management.Edit;
import thut.essentials.land.LandManager;

public class Admins {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        LiteralArgumentBuilder command;
        String perm;
        String name = "list_team_admins";
        if (!Essentials.config.commandBlacklist.contains(name)) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.executes(ctx -> Admins.list((CommandSource)ctx.getSource()));
            commandDispatcher.register(command);
        }
        if (!Essentials.config.commandBlacklist.contains(name = "remove_team_admin")) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> Edit.adminUse(cs, perm));
            command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"player", (ArgumentType)GameProfileArgument.func_197108_a()).executes(ctx -> Admins.remove((CommandSource)ctx.getSource(), GameProfileArgument.func_197109_a((CommandContext)ctx, (String)"player"))));
            commandDispatcher.register(command);
        }
        if (!Essentials.config.commandBlacklist.contains(name = "add_team_admin")) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> Edit.adminUse(cs, perm));
            command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"player", (ArgumentType)GameProfileArgument.func_197108_a()).executes(ctx -> Admins.add((CommandSource)ctx.getSource(), GameProfileArgument.func_197109_a((CommandContext)ctx, (String)"player"))));
            commandDispatcher.register(command);
        }
    }

    private static int list(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        String teamName = team.teamName;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.admins.header", null, false, teamName));
        Set<UUID> c = team.admin;
        for (UUID o : c) {
            GameProfile profile = CommandManager.getProfile(source.func_197028_i(), o);
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.admins.entry", null, false, profile.getName()));
        }
        return 0;
    }

    private static int remove(CommandSource source, GameProfile player) throws CommandSyntaxException {
        LandManager.LandTeam teamB;
        ServerPlayerEntity user = source.func_197035_h();
        LandManager.LandTeam teamA = LandManager.getTeam((Entity)user);
        if (teamA != (teamB = LandManager.getTeam(player.getId()))) {
            source.func_197021_a(CommandManager.makeFormattedComponent("thutessentials.team.admins.mustbeteam"));
            return 1;
        }
        String teamName = teamA.teamName;
        LandManager.getInstance().removeAdmin(player.getId(), teamName);
        source.func_197030_a(CommandManager.makeFormattedComponent("thutessentials.team.admin.removed", null, false, player.getName(), teamName), false);
        return 0;
    }

    private static int remove(CommandSource source, Collection<GameProfile> collection) throws CommandSyntaxException {
        int i = 0;
        for (GameProfile player : collection) {
            i += Admins.remove(source, player);
        }
        return i;
    }

    private static int add(CommandSource source, Collection<GameProfile> collection) throws CommandSyntaxException {
        int i = 0;
        for (GameProfile player : collection) {
            i += Admins.add(source, player);
        }
        return i;
    }

    private static int add(CommandSource source, GameProfile player) throws CommandSyntaxException {
        LandManager.LandTeam teamB;
        ServerPlayerEntity user = source.func_197035_h();
        LandManager.LandTeam teamA = LandManager.getTeam((Entity)user);
        if (teamA != (teamB = LandManager.getTeam(player.getId()))) {
            source.func_197021_a(CommandManager.makeFormattedComponent("thutessentials.team.admins.mustbeteam"));
            return 1;
        }
        String teamName = teamA.teamName;
        LandManager.getInstance().addAdmin(player.getId(), teamName);
        source.func_197030_a(CommandManager.makeFormattedComponent("thutessentials.team.admin.added", null, false, player.getName(), teamName), false);
        return 0;
    }
}

